/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.devmode;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ReplacementDebugPage {
    private static final String HTML_TEMPLATE = "<!doctype html>\n<html lang=\"en\">\n<head>\n    <title>Error restarting Quarkus: %1$s</title>\n    <meta charset=\"utf-8\">\n    <style>%3$s</style>\n</head>\n<body>\n<header>\n    <h1 class=\"container\">Error restarting Quarkus</h1>\n    <div class=\"exception-message\">\n        <h2 class=\"container\">%1$s</h2>\n    </div>\n</header>\n<div class=\"container\">\n    <div class=\"trace\">\n        <pre>%2$s</pre>\n    </div>\n</div>\n</body>\n</html>\n";
    private static final String ERROR_CSS = "\nhtml, body {\n    margin: 0;\n    padding: 0;\n    font-family: Helvetica, Arial, sans-serif;\n    font-size: 14px;\n    line-height: 1.4;\n}\n\nhtml {\n    overflow-y: scroll;\n}\n\nbody {\n    background: #f9f9f9;\n}\n\n.container {\n    width: 80%;\n    margin: 0 auto;\n}\n\nheader {\n    background: #ad1c1c;\n}\n\n.exception-message {\n    background: #be2828;\n}\n\nh1, h2 {\n    margin: 0;\n    padding: 0;\n    font-weight: normal;\n}\n\nh1 {\n    font-size: 22px;\n    color: #fff;\n    padding: 10px 0;\n}\n\nh2 {\n    font-size: 18px;\n    color: rgba(255, 255, 255, 0.85);\n    padding: 20px 0;\n}\n\n.trace {\n    background: #fff;\n    padding: 15px;\n    margin: 15px auto;\n    overflow-y: scroll;\n    border: 1px solid #ececec;\n}\n\npre {\n    white-space: pre;\n    font-family: Consolas, Monaco, Menlo, \"Ubuntu Mono\", \"Liberation Mono\", monospace;\n    font-size: 12px;\n    line-height: 1.5;\n}\n";

    public static String generateHtml(Throwable exception) {
        String headerMessage = ReplacementDebugPage.generateHeaderMessage(exception);
        String stackTrace = ReplacementDebugPage.generateStackTrace(exception);
        return String.format(HTML_TEMPLATE, headerMessage, stackTrace, ERROR_CSS);
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return ReplacementDebugPage.escapeHtml(stringWriter.toString().trim());
    }

    private static String generateHeaderMessage(Throwable exception) {
        return ReplacementDebugPage.escapeHtml(String.format("%s: %s", exception.getClass().getName(), ReplacementDebugPage.extractFirstLine(exception.getMessage())));
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    private static String escapeHtml(String bodyText) {
        if (bodyText == null) {
            return "null";
        }
        return bodyText.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

