/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.recording.AnnotationProxyProvider;
import io.quarkus.deployment.recording.ObjectLoader;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ObjectSubstitution;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.wildfly.common.Assert;

public class BytecodeRecorderImpl
implements RecorderContext {
    private static final AtomicInteger COUNT = new AtomicInteger();
    private static final AtomicInteger OUTPUT_COUNT = new AtomicInteger();
    private static final String BASE_PACKAGE = "io.quarkus.deployment.steps.";
    private static final String PROXY_KEY = "proxykey";
    private static final MethodDescriptor COLLECTION_ADD = MethodDescriptor.ofMethod(Collection.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private final boolean staticInit;
    private final ClassLoader classLoader;
    private final MethodRecorder methodRecorder = new MethodRecorder();
    private final Map<Class, ProxyFactory<?>> returnValueProxy = new HashMap();
    private final IdentityHashMap<Class<?>, String> classProxies = new IdentityHashMap();
    private final Map<Class<?>, SubstitutionHolder> substitutions = new HashMap();
    private final Map<Class<?>, NonDefaultConstructorHolder> nonDefaultConstructors = new HashMap();
    private final String className;
    private final List<ObjectLoader> loaders = new ArrayList<ObjectLoader>();
    private final IdentityHashMap<Object, ResultHandle> loadedObjects = new IdentityHashMap();

    public BytecodeRecorderImpl(ClassLoader classLoader, boolean staticInit, String className) {
        this.classLoader = classLoader;
        this.staticInit = staticInit;
        this.className = className;
    }

    public BytecodeRecorderImpl(boolean staticInit, String buildStepName, String methodName) {
        this(Thread.currentThread().getContextClassLoader(), staticInit, BASE_PACKAGE + buildStepName + "$" + methodName + OUTPUT_COUNT.incrementAndGet());
    }

    public boolean isEmpty() {
        return this.methodRecorder.storedMethodCalls.isEmpty();
    }

    @Override
    public <F, T> void registerSubstitution(Class<F> from, Class<T> to, Class<? extends ObjectSubstitution<F, T>> substitution) {
        this.substitutions.put(from, new SubstitutionHolder(from, to, substitution));
    }

    @Override
    public <T> void registerNonDefaultConstructor(Constructor<T> constructor, Function<T, List<Object>> parameters) {
        this.nonDefaultConstructors.put(constructor.getDeclaringClass(), new NonDefaultConstructorHolder(constructor, parameters));
    }

    @Override
    public void registerObjectLoader(ObjectLoader loader) {
        Assert.checkNotNullParam((String)"loader", (Object)loader);
        this.loaders.add(loader);
    }

    public <T> T getRecordingProxy(Class<T> theClass) {
        return this.methodRecorder.getRecordingProxy(theClass);
    }

    @Override
    public Class<?> classProxy(String name) {
        ProxyFactory factory = new ProxyFactory(new ProxyConfiguration().setSuperClass(Object.class).setClassLoader(this.classLoader).setProxyName(this.getClass().getName() + "$$ClassProxy" + COUNT.incrementAndGet()));
        Class theClass = factory.defineClass();
        this.classProxies.put(theClass, name);
        return theClass;
    }

    @Override
    public <T> RuntimeValue<T> newInstance(String name) {
        try {
            ProxyInstance ret = this.methodRecorder.getProxyInstance(RuntimeValue.class);
            NewInstance instance = new NewInstance(name, ret.proxy, ret.key);
            this.methodRecorder.storedMethodCalls.add(instance);
            return (RuntimeValue)ret.proxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void writeBytecode(ClassOutput classOutput) {
        StoredMethodCall call;
        ClassCreator file = ClassCreator.builder().classOutput(ClassOutput.gizmoAdaptor(classOutput, true)).className(this.className).superClass(Object.class).interfaces(new Class[]{StartupTask.class}).build();
        MethodCreator method = file.getMethodCreator("deploy", Void.TYPE, new Class[]{StartupContext.class});
        HashMap classInstanceVariables = new HashMap();
        IdentityHashMap<Object, ResultHandle> returnValueResults = new IdentityHashMap<Object, ResultHandle>();
        for (BytecodeInstruction set : this.methodRecorder.storedMethodCalls) {
            if (!(set instanceof StoredMethodCall)) continue;
            call = (StoredMethodCall)set;
            if (classInstanceVariables.containsKey(call.theClass)) continue;
            ResultHandle instance = method.newInstance(MethodDescriptor.ofConstructor(call.theClass, (Class[])new Class[0]), new ResultHandle[0]);
            classInstanceVariables.put(call.theClass, instance);
        }
        for (BytecodeInstruction set : this.methodRecorder.storedMethodCalls) {
            if (set instanceof StoredMethodCall) {
                call = (StoredMethodCall)set;
                ResultHandle[] params = new ResultHandle[call.parameters.length];
                for (int i = 0; i < call.parameters.length; ++i) {
                    Class<?> targetType = call.method.getParameterTypes()[i];
                    params[i] = call.parameters[i] != null ? this.loadObjectInstance(method, call.parameters[i], returnValueResults, targetType) : method.loadNull();
                }
                ResultHandle callResult = method.invokeVirtualMethod(MethodDescriptor.ofMethod(call.method.getDeclaringClass(), (String)call.method.getName(), call.method.getReturnType(), (Class[])call.method.getParameterTypes()), (ResultHandle)classInstanceVariables.get(call.theClass), params);
                if (call.method.getReturnType() == Void.TYPE || call.returnedProxy == null) continue;
                returnValueResults.put(call.returnedProxy, callResult);
                method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"putValue", Void.TYPE, (Class[])new Class[]{String.class, Object.class}), method.getMethodParam(0), new ResultHandle[]{method.load(call.proxyId), callResult});
                continue;
            }
            if (set instanceof NewInstance) {
                NewInstance ni = (NewInstance)set;
                ResultHandle val = method.newInstance(MethodDescriptor.ofConstructor((String)ni.theClass, (String[])new String[0]), new ResultHandle[0]);
                ResultHandle rv = method.newInstance(MethodDescriptor.ofConstructor(RuntimeValue.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{val});
                method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"putValue", Void.TYPE, (Class[])new Class[]{String.class, Object.class}), method.getMethodParam(0), new ResultHandle[]{method.load(ni.proxyId), rv});
                continue;
            }
            throw new RuntimeException("unknown type " + set);
        }
        method.returnValue(null);
        file.close();
    }

    /*
     * WARNING - void declaration
     */
    private ResultHandle loadObjectInstance(MethodCreator method, Object param, Map<Object, ResultHandle> returnValueResults, Class<?> expectedType) {
        ResultHandle out;
        block118: {
            ResultHandle existing = returnValueResults.get(param);
            if (existing != null) {
                return existing;
            }
            if (param == null) {
                out = method.loadNull();
            } else {
                if (this.findLoaded((BytecodeCreator)method, param)) {
                    return this.loadedObjects.get(param);
                }
                if (this.substitutions.containsKey(param.getClass()) || this.substitutions.containsKey(expectedType)) {
                    SubstitutionHolder holder = this.substitutions.get(param.getClass());
                    if (holder == null) {
                        holder = this.substitutions.get(expectedType);
                    }
                    try {
                        ObjectSubstitution<?, ?> objectSubstitution = holder.sub.newInstance();
                        Object res = objectSubstitution.serialize(param);
                        ResultHandle serialized = this.loadObjectInstance(method, res, returnValueResults, holder.to);
                        ResultHandle subInstance = method.newInstance(MethodDescriptor.ofConstructor(holder.sub, (Class[])new Class[0]), new ResultHandle[0]);
                        out = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(ObjectSubstitution.class, (String)"deserialize", Object.class, (Class[])new Class[]{Object.class}), subInstance, new ResultHandle[]{serialized});
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to substitute " + param, exception);
                    }
                }
                if (param instanceof Optional) {
                    Optional val = (Optional)param;
                    if (val.isPresent()) {
                        ResultHandle resultHandle = this.loadObjectInstance(method, val.get(), returnValueResults, Object.class);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{resultHandle});
                    }
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]), new ResultHandle[0]);
                }
                if (param instanceof String) {
                    out = method.load((String)param);
                } else if (param instanceof Integer) {
                    out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(((Integer)param).intValue())});
                } else if (param instanceof Boolean) {
                    out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{method.load(((Boolean)param).booleanValue())});
                } else {
                    if (param instanceof URL) {
                        String url = ((URL)param).toExternalForm();
                        AssignableResultHandle assignableResultHandle = method.createVariable(URL.class);
                        try (TryBlock et = method.tryBlock();){
                            et.assign(assignableResultHandle, et.newInstance(MethodDescriptor.ofConstructor(URL.class, (Class[])new Class[]{String.class}), new ResultHandle[]{et.load(url)}));
                            out = assignableResultHandle;
                            Throwable throwable = null;
                            try (CatchBlockCreator malformed = et.addCatch(MalformedURLException.class);){
                                malformed.throwException(RuntimeException.class, "Malformed URL", malformed.getCaughtException());
                                break block118;
                            }
                            catch (Throwable throwable2) {
                                Throwable throwable3 = throwable2;
                                throw throwable2;
                            }
                        }
                    }
                    if (param instanceof Enum) {
                        Enum e = (Enum)param;
                        ResultHandle resultHandle = method.load(e.name());
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(e.getDeclaringClass(), (String)"valueOf", e.getDeclaringClass(), (Class[])new Class[]{String.class}), new ResultHandle[]{resultHandle});
                    } else if (param instanceof ReturnedProxy) {
                        ReturnedProxy rp = (ReturnedProxy)param;
                        if (!rp.__static$$init() && this.staticInit) {
                            throw new RuntimeException("Invalid proxy passed to template. " + rp + " was created in a runtime recorder method, while this recorder is for a static init method. The object will not have been created at the time this method is run.");
                        }
                        String string = rp.__returned$proxy$key();
                        out = method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class}), method.getMethodParam(0), new ResultHandle[]{method.load(string)});
                    } else if (param instanceof Class) {
                        String name = this.classProxies.get(param);
                        if (name == null) {
                            name = ((Class)param).getName();
                        }
                        ResultHandle resultHandle = method.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
                        ResultHandle tccl = method.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0]);
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{method.load(name), method.load(true), tccl});
                    } else if (expectedType == Boolean.TYPE) {
                        out = method.load(((Boolean)param).booleanValue());
                    } else if (expectedType == Boolean.class) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{method.load(((Boolean)param).booleanValue())});
                    } else if (expectedType == Integer.TYPE) {
                        out = method.load(((Integer)param).intValue());
                    } else if (expectedType == Integer.class) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(((Integer)param).intValue())});
                    } else if (expectedType == Short.TYPE) {
                        out = method.load(((Short)param).shortValue());
                    } else if (expectedType == Short.class || param instanceof Short) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Short.class, (String)"valueOf", Short.class, (Class[])new Class[]{Short.TYPE}), new ResultHandle[]{method.load(((Short)param).shortValue())});
                    } else if (expectedType == Byte.TYPE) {
                        out = method.load(((Byte)param).byteValue());
                    } else if (expectedType == Byte.class || param instanceof Byte) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Byte.class, (String)"valueOf", Byte.class, (Class[])new Class[]{Byte.TYPE}), new ResultHandle[]{method.load(((Byte)param).byteValue())});
                    } else if (expectedType == Character.TYPE) {
                        out = method.load(((Character)param).charValue());
                    } else if (expectedType == Character.class || param instanceof Character) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Character.class, (String)"valueOf", Character.class, (Class[])new Class[]{Character.TYPE}), new ResultHandle[]{method.load(((Character)param).charValue())});
                    } else if (expectedType == Long.TYPE) {
                        out = method.load(((Long)param).longValue());
                    } else if (expectedType == Long.class || param instanceof Long) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"valueOf", Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{method.load(((Long)param).longValue())});
                    } else if (expectedType == Float.TYPE) {
                        out = method.load(((Float)param).floatValue());
                    } else if (expectedType == Float.class || param instanceof Float) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Float.class, (String)"valueOf", Float.class, (Class[])new Class[]{Float.TYPE}), new ResultHandle[]{method.load(((Float)param).floatValue())});
                    } else if (expectedType == Double.TYPE) {
                        out = method.load(((Double)param).doubleValue());
                    } else if (expectedType == Double.class || param instanceof Double) {
                        out = method.invokeStaticMethod(MethodDescriptor.ofMethod(Double.class, (String)"valueOf", Double.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{method.load(((Double)param).doubleValue())});
                    } else if (expectedType.isArray()) {
                        void var8_25;
                        int length = Array.getLength(param);
                        out = method.newArray(expectedType.getComponentType(), method.load(length));
                        boolean bl = false;
                        while (var8_25 < length) {
                            ResultHandle component = this.loadObjectInstance(method, Array.get(param, (int)var8_25), returnValueResults, expectedType.getComponentType());
                            method.writeArrayValue(out, (int)var8_25, component);
                            ++var8_25;
                        }
                    } else if (AnnotationProxyProvider.AnnotationProxy.class.isAssignableFrom(expectedType)) {
                        AnnotationProxyProvider.AnnotationProxy annotationProxy = (AnnotationProxyProvider.AnnotationProxy)param;
                        List list = annotationProxy.getAnnotationClass().methods().stream().filter(m -> !m.name().equals("<clinit>") && !m.name().equals("<init>")).collect(Collectors.toList());
                        Map annotationValues = annotationProxy.getAnnotationInstance().values().stream().collect(Collectors.toMap(AnnotationValue::name, Function.identity()));
                        ResultHandle[] constructorParamsHandles = new ResultHandle[list.size()];
                        ListIterator iterator = list.listIterator();
                        while (iterator.hasNext()) {
                            ResultHandle retValue;
                            MethodInfo methodInfo = (MethodInfo)iterator.next();
                            AnnotationValue value = (AnnotationValue)annotationValues.get(methodInfo.name());
                            if (value == null) {
                                Object defaultValue = annotationProxy.getDefaultValues().get(methodInfo.name());
                                if (defaultValue != null) {
                                    constructorParamsHandles[iterator.previousIndex()] = this.loadObjectInstance(method, defaultValue, returnValueResults, defaultValue.getClass());
                                    continue;
                                }
                                if (value == null) {
                                    value = methodInfo.defaultValue();
                                }
                            }
                            if (value == null) {
                                throw new NullPointerException("Value not set for " + method);
                            }
                            constructorParamsHandles[iterator.previousIndex()] = retValue = BytecodeRecorderImpl.loadValue((BytecodeCreator)method, value, annotationProxy.getAnnotationClass(), methodInfo);
                        }
                        out = method.newInstance(MethodDescriptor.ofConstructor((Object)annotationProxy.getAnnotationLiteralType(), (Object[])list.stream().map(m -> m.returnType().name().toString()).toArray()), constructorParamsHandles);
                    } else {
                        if (this.nonDefaultConstructors.containsKey(param.getClass())) {
                            NonDefaultConstructorHolder holder = this.nonDefaultConstructors.get(param.getClass());
                            List<Object> list = holder.paramGenerator.apply(param);
                            if (list.size() != holder.constructor.getParameterCount()) {
                                throw new RuntimeException("Unable to serialize " + param + " as the wrong number of parameters were generated for " + holder.constructor);
                            }
                            ArrayList<ResultHandle> handles = new ArrayList<ResultHandle>();
                            int count = 0;
                            for (Object object : list) {
                                handles.add(this.loadObjectInstance(method, object, returnValueResults, holder.constructor.getParameterTypes()[count++]));
                            }
                            out = method.newInstance(MethodDescriptor.ofConstructor(holder.constructor.getDeclaringClass(), (Class[])holder.constructor.getParameterTypes()), handles.toArray(new ResultHandle[handles.size()]));
                        } else {
                            try {
                                param.getClass().getDeclaredConstructor(new Class[0]);
                                out = method.newInstance(MethodDescriptor.ofConstructor(param.getClass(), (Class[])new Class[0]), new ResultHandle[0]);
                            }
                            catch (NoSuchMethodException e) {
                                if (expectedType == Map.class) {
                                    out = method.newInstance(MethodDescriptor.ofConstructor(LinkedHashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                                }
                                if (expectedType == List.class) {
                                    out = method.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                                }
                                if (expectedType == Set.class) {
                                    out = method.newInstance(MethodDescriptor.ofConstructor(Set.class, (Class[])new Class[0]), new ResultHandle[0]);
                                }
                                throw new RuntimeException("Unable to serialize objects of type " + param.getClass() + " to bytecode as it has no default constructor");
                            }
                        }
                        returnValueResults.put(param, out);
                        if (param instanceof Collection) {
                            for (Object e : (Collection)param) {
                                ResultHandle val = this.loadObjectInstance(method, e, returnValueResults, e.getClass());
                                method.invokeInterfaceMethod(COLLECTION_ADD, out, new ResultHandle[]{val});
                            }
                        }
                        if (param instanceof Map) {
                            for (Map.Entry entry : ((Map)param).entrySet()) {
                                ResultHandle key = this.loadObjectInstance(method, entry.getKey(), returnValueResults, entry.getKey().getClass());
                                ResultHandle val = entry.getValue() != null ? this.loadObjectInstance(method, entry.getValue(), returnValueResults, entry.getValue().getClass()) : null;
                                method.invokeInterfaceMethod(MAP_PUT, out, new ResultHandle[]{key, val});
                            }
                        }
                        HashSet<String> handledProperties = new HashSet<String>();
                        PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors((Object)param);
                        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                            Object propertyValue;
                            if (propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() == null) {
                                try {
                                    ResultHandle prop;
                                    if (Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                                        handledProperties.add(propertyDescriptor.getName());
                                        propertyValue = (Collection)PropertyUtils.getProperty((Object)param, (String)propertyDescriptor.getName());
                                        if (propertyValue.isEmpty()) continue;
                                        prop = method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)propertyDescriptor.getReadMethod()), out, new ResultHandle[0]);
                                        Method[] methodArray = propertyValue.iterator();
                                        while (methodArray.hasNext()) {
                                            Object e = methodArray.next();
                                            ResultHandle toAdd = this.loadObjectInstance(method, e, returnValueResults, Object.class);
                                            method.invokeInterfaceMethod(COLLECTION_ADD, prop, new ResultHandle[]{toAdd});
                                        }
                                        continue;
                                    }
                                    if (!Map.class.isAssignableFrom(propertyDescriptor.getPropertyType())) continue;
                                    handledProperties.add(propertyDescriptor.getName());
                                    propertyValue = (Map)PropertyUtils.getProperty((Object)param, (String)propertyDescriptor.getName());
                                    if (propertyValue.isEmpty()) continue;
                                    prop = method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)propertyDescriptor.getReadMethod()), out, new ResultHandle[0]);
                                    for (Map.Entry entry : propertyValue.entrySet()) {
                                        ResultHandle key = this.loadObjectInstance(method, entry.getKey(), returnValueResults, Object.class);
                                        ResultHandle val = entry.getValue() != null ? this.loadObjectInstance(method, entry.getValue(), returnValueResults, Object.class) : method.loadNull();
                                        method.invokeInterfaceMethod(MAP_PUT, prop, new ResultHandle[]{key, val});
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
                            try {
                                handledProperties.add(propertyDescriptor.getName());
                                propertyValue = PropertyUtils.getProperty((Object)param, (String)propertyDescriptor.getName());
                                if (propertyValue == null) continue;
                                Class<?> propertyType = propertyDescriptor.getPropertyType();
                                if (propertyDescriptor.getReadMethod().getReturnType() != propertyDescriptor.getWriteMethod().getParameterTypes()[0]) {
                                    for (Method m2 : param.getClass().getMethods()) {
                                        if (!m2.getName().equals(propertyDescriptor.getWriteMethod().getName()) || m2.getParameterTypes().length <= 0 || !m2.getParameterTypes()[0].isAssignableFrom(param.getClass())) continue;
                                        propertyType = m2.getParameterTypes()[0];
                                        break;
                                    }
                                }
                                ResultHandle val = this.loadObjectInstance(method, propertyValue, returnValueResults, propertyDescriptor.getPropertyType());
                                method.invokeVirtualMethod(MethodDescriptor.ofMethod(param.getClass(), (String)propertyDescriptor.getWriteMethod().getName(), Void.TYPE, (Class[])new Class[]{propertyType}), out, new ResultHandle[]{val});
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        for (Field field : param.getClass().getFields()) {
                            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || handledProperties.contains(field.getName())) continue;
                            try {
                                ResultHandle val = this.loadObjectInstance(method, field.get(param), returnValueResults, field.getType());
                                method.writeInstanceField(FieldDescriptor.of(param.getClass(), (String)field.getName(), field.getType()), out, val);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
            }
        }
        returnValueResults.put(param, out);
        return out;
    }

    private boolean findLoaded(BytecodeCreator body, Object param) {
        if (this.loadedObjects.containsKey(param)) {
            return true;
        }
        for (ObjectLoader loader : this.loaders) {
            ResultHandle handle = loader.load(body, param, this.staticInit);
            if (handle == null) continue;
            this.loadedObjects.put(param, handle);
            return true;
        }
        return false;
    }

    static ResultHandle loadValue(BytecodeCreator valueMethod, AnnotationValue value, ClassInfo annotationClass, MethodInfo method) {
        ResultHandle retValue;
        switch (value.kind()) {
            case BOOLEAN: {
                retValue = valueMethod.load(value.asBoolean());
                break;
            }
            case STRING: {
                retValue = valueMethod.load(value.asString());
                break;
            }
            case BYTE: {
                retValue = valueMethod.load(value.asByte());
                break;
            }
            case SHORT: {
                retValue = valueMethod.load(value.asShort());
                break;
            }
            case LONG: {
                retValue = valueMethod.load(value.asLong());
                break;
            }
            case INTEGER: {
                retValue = valueMethod.load(value.asInt());
                break;
            }
            case FLOAT: {
                retValue = valueMethod.load(value.asFloat());
                break;
            }
            case DOUBLE: {
                retValue = valueMethod.load(value.asDouble());
                break;
            }
            case CHARACTER: {
                retValue = valueMethod.load(value.asChar());
                break;
            }
            case CLASS: {
                retValue = valueMethod.loadClass(value.asClass().toString());
                break;
            }
            case ARRAY: {
                retValue = BytecodeRecorderImpl.arrayValue(value, valueMethod, method, annotationClass);
                break;
            }
            case ENUM: {
                retValue = valueMethod.readStaticField(FieldDescriptor.of((String)value.asEnumType().toString(), (String)value.asEnum(), (String)value.asEnumType().toString()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported value: " + value);
            }
        }
        return retValue;
    }

    static ResultHandle arrayValue(AnnotationValue value, BytecodeCreator valueMethod, MethodInfo method, ClassInfo annotationClass) {
        ResultHandle retValue;
        switch (value.componentKind()) {
            case CLASS: {
                Type[] classArray = value.asClassArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(classArray.length));
                for (int i = 0; i < classArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.loadClass(classArray[i].name().toString()));
                }
                break;
            }
            case STRING: {
                String[] stringArray = value.asStringArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(stringArray.length));
                for (int i = 0; i < stringArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(stringArray[i]));
                }
                break;
            }
            case INTEGER: {
                int[] intArray = value.asIntArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(intArray.length));
                for (int i = 0; i < intArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(intArray[i]));
                }
                break;
            }
            case LONG: {
                long[] longArray = value.asLongArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(longArray.length));
                for (int i = 0; i < longArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(longArray[i]));
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = value.asByteArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(byteArray.length));
                for (int i = 0; i < byteArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(byteArray[i]));
                }
                break;
            }
            case CHARACTER: {
                char[] charArray = value.asCharArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(charArray.length));
                for (int i = 0; i < charArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(charArray[i]));
                }
                break;
            }
            case ENUM: {
                String[] enumArray = value.asEnumArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(enumArray.length));
                String enumType = BytecodeRecorderImpl.componentType(method);
                for (int i = 0; i < enumArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.readStaticField(FieldDescriptor.of((String)enumType, (String)enumArray[i], (String)enumType)));
                }
                break;
            }
            default: {
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(0));
            }
        }
        return retValue;
    }

    static String componentType(MethodInfo method) {
        ArrayType arrayType = method.returnType().asArrayType();
        return arrayType.component().name().toString();
    }

    private static final class ProxyInstance {
        final Object proxy;
        final String key;

        ProxyInstance(Object proxy, String key) {
            this.proxy = proxy;
            this.key = key;
        }
    }

    static final class NonDefaultConstructorHolder {
        final Constructor<?> constructor;
        final Function<Object, List<Object>> paramGenerator;

        NonDefaultConstructorHolder(Constructor<?> constructor, Function<Object, List<Object>> paramGenerator) {
            this.constructor = constructor;
            this.paramGenerator = paramGenerator;
        }
    }

    static final class SubstitutionHolder {
        final Class<?> from;
        final Class<?> to;
        final Class<? extends ObjectSubstitution<?, ?>> sub;

        SubstitutionHolder(Class<?> from, Class<?> to, Class<? extends ObjectSubstitution<?, ?>> sub) {
            this.from = from;
            this.to = to;
            this.sub = sub;
        }
    }

    static final class NewInstance
    implements BytecodeInstruction {
        final String theClass;
        final Object returnedProxy;
        final String proxyId;

        NewInstance(String theClass, Object returnedProxy, String proxyId) {
            this.theClass = theClass;
            this.returnedProxy = returnedProxy;
            this.proxyId = proxyId;
        }
    }

    static final class StoredMethodCall
    implements BytecodeInstruction {
        final Class<?> theClass;
        final Method method;
        final Object[] parameters;
        Object returnedProxy;
        String proxyId;

        StoredMethodCall(Class<?> theClass, Method method, Object[] parameters) {
            this.theClass = theClass;
            this.method = method;
            this.parameters = parameters;
        }
    }

    public static interface ReturnedProxy {
        public String __returned$proxy$key();

        public boolean __static$$init();
    }

    static interface BytecodeInstruction {
    }

    private class MethodRecorder {
        private final Map<Class<?>, Object> existingProxyClasses = new HashMap();
        private final List<BytecodeInstruction> storedMethodCalls = new ArrayList<BytecodeInstruction>();

        private MethodRecorder() {
        }

        public <T> T getRecordingProxy(final Class<T> theClass) {
            if (this.existingProxyClasses.containsKey(theClass)) {
                return theClass.cast(this.existingProxyClasses.get(theClass));
            }
            ProxyFactory factory = new ProxyFactory(new ProxyConfiguration().setSuperClass(theClass).setClassLoader(BytecodeRecorderImpl.this.classLoader).setProxyName(this.getClass().getName() + "$$RecordingProxyProxy" + COUNT.incrementAndGet()));
            try {
                Object recordingProxy = factory.newInstance(new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        StoredMethodCall storedMethodCall = new StoredMethodCall(theClass, method, args);
                        MethodRecorder.this.storedMethodCalls.add(storedMethodCall);
                        Class<?> returnType = method.getReturnType();
                        if (returnType.isPrimitive()) {
                            return 0;
                        }
                        if (Modifier.isFinal(returnType.getModifiers())) {
                            return null;
                        }
                        ProxyInstance instance = MethodRecorder.this.getProxyInstance(returnType);
                        if (instance == null) {
                            return null;
                        }
                        storedMethodCall.returnedProxy = instance.proxy;
                        storedMethodCall.proxyId = instance.key;
                        return instance.proxy;
                    }
                });
                this.existingProxyClasses.put(theClass, recordingProxy);
                return (T)recordingProxy;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        private ProxyInstance getProxyInstance(final Class<?> returnType) throws InstantiationException, IllegalAccessException {
            ProxyFactory proxyFactory;
            boolean returnInterface = returnType.isInterface();
            if (!returnInterface) {
                try {
                    returnType.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
            if ((proxyFactory = (ProxyFactory)BytecodeRecorderImpl.this.returnValueProxy.get(returnType)) == null) {
                ProxyConfiguration proxyConfiguration = new ProxyConfiguration().setSuperClass(returnInterface ? Object.class : returnType).setClassLoader(BytecodeRecorderImpl.this.classLoader).addAdditionalInterface(ReturnedProxy.class).setProxyName(this.getClass().getName() + "$$ReturnValueProxy" + COUNT.incrementAndGet());
                if (returnInterface) {
                    proxyConfiguration.addAdditionalInterface(returnType);
                }
                proxyFactory = new ProxyFactory(proxyConfiguration);
                BytecodeRecorderImpl.this.returnValueProxy.put(returnType, proxyFactory);
            }
            final String key = BytecodeRecorderImpl.PROXY_KEY + COUNT.incrementAndGet();
            Object proxyInstance = proxyFactory.newInstance(new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("__returned$proxy$key")) {
                        return key;
                    }
                    if (method.getName().equals("__static$$init")) {
                        return BytecodeRecorderImpl.this.staticInit;
                    }
                    if (method.getName().equals("toString") && method.getParameterTypes().length == 0 && method.getReturnType().equals(String.class)) {
                        return "Runtime proxy of " + returnType + " with id " + key;
                    }
                    throw new RuntimeException("You cannot invoke directly on an object returned from the bytecode recorded, you can only pass is back into the recorder as a parameter");
                }
            });
            ProxyInstance instance = new ProxyInstance(proxyInstance, key);
            return instance;
        }
    }
}

