/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.BuildTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.BuildTimeRunTimeFixedConfigurationBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.ConfigurationCustomConverterBuildItem;
import io.quarkus.deployment.builditem.ExtensionClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigDefinition;
import io.quarkus.deployment.configuration.ConfigPatternMap;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.recording.ObjectLoader;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSource;
import io.quarkus.runtime.configuration.BuildTimeConfigFactory;
import io.quarkus.runtime.configuration.CidrAddressConverter;
import io.quarkus.runtime.configuration.ConverterFactory;
import io.quarkus.runtime.configuration.DefaultConfigSource;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.InetAddressConverter;
import io.quarkus.runtime.configuration.InetSocketAddressConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.PathConverter;
import io.quarkus.runtime.configuration.RegexConverter;
import io.quarkus.runtime.configuration.SimpleConfigurationProviderResolver;
import io.quarkus.runtime.configuration.ssl.CipherSuiteSelectorConverter;
import io.quarkus.runtime.configuration.ssl.ProtocolConverter;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;

public class ConfigurationSetup {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.configuration");
    public static final String BUILD_TIME_CONFIG = "io.quarkus.runtime.generated.BuildTimeConfig";
    public static final String BUILD_TIME_CONFIG_ROOT = "io.quarkus.runtime.generated.BuildTimeConfigRoot";
    public static final String RUN_TIME_CONFIG = "io.quarkus.runtime.generated.RunTimeConfig";
    public static final String RUN_TIME_CONFIG_ROOT = "io.quarkus.runtime.generated.RunTimeConfigRoot";
    public static final MethodDescriptor CREATE_RUN_TIME_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.RunTimeConfig", (String)"getRunTimeConfiguration", Void.TYPE, (Object[])new Object[0]);
    private static final FieldDescriptor RUN_TIME_CONFIG_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.RunTimeConfig", (String)"runConfig", (String)"io.quarkus.runtime.generated.RunTimeConfigRoot");
    private static final FieldDescriptor BUILD_TIME_CONFIG_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.BuildTimeConfig", (String)"buildConfig", (String)"io.quarkus.runtime.generated.BuildTimeConfigRoot");
    private static final FieldDescriptor CONVERTERS_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.BuildTimeConfig", (String)"converters", Converter[].class);
    private static final MethodDescriptor NI_HAS_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor NI_NEXT_EQUALS = MethodDescriptor.ofMethod(NameIterator.class, (String)"nextSegmentEquals", Boolean.TYPE, (Class[])new Class[]{String.class});
    private static final MethodDescriptor NI_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"next", Void.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor ITR_HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor ITR_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor CF_GET_IMPLICIT_CONVERTER = MethodDescriptor.ofMethod(ConverterFactory.class, (String)"getImplicitConverter", Converter.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor CPR_SET_INSTANCE = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"setInstance", Void.TYPE, (Class[])new Class[]{ConfigProviderResolver.class});
    private static final MethodDescriptor CPR_REGISTER_CONFIG = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"registerConfig", Void.TYPE, (Class[])new Class[]{Config.class, ClassLoader.class});
    private static final MethodDescriptor CPR_INSTANCE = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"instance", ConfigProviderResolver.class, (Class[])new Class[0]);
    private static final MethodDescriptor SCPR_CONSTRUCT = MethodDescriptor.ofConstructor(SimpleConfigurationProviderResolver.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_BUILD = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"build", Config.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_WITH_CONVERTER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withConverter", ConfigBuilder.class, (Class[])new Class[]{Class.class, Integer.TYPE, Converter.class});
    private static final MethodDescriptor SRCB_WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", ConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    private static final MethodDescriptor SRCB_ADD_DEFAULT_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"addDefaultSources", ConfigBuilder.class, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_CONSTRUCT = MethodDescriptor.ofConstructor(SmallRyeConfigBuilder.class, (Class[])new Class[0]);
    private static final MethodDescriptor II_IN_IMAGE_RUN = MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageRuntimeCode", Boolean.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor SRCB_WITH_WRAPPER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withWrapper", SmallRyeConfigBuilder.class, (Class[])new Class[]{UnaryOperator.class});
    private static final MethodDescriptor BTCF_GET_CONFIG_SOURCE = MethodDescriptor.ofMethod(BuildTimeConfigFactory.class, (String)"getBuildTimeConfigSource", ConfigSource.class, (Class[])new Class[0]);
    private static final FieldDescriptor ECS_WRAPPER = FieldDescriptor.of(ExpandingConfigSource.class, (String)"WRAPPER", UnaryOperator.class);
    private static final String CONFIG_ROOTS_LIST = "META-INF/quarkus-config-roots.list";

    @BuildStep
    public void setUpConverters(BuildProducer<ConfigurationCustomConverterBuildItem> configurationTypes) {
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, InetSocketAddress.class, InetSocketAddressConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, CidrAddress.class, CidrAddressConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, InetAddress.class, InetAddressConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, Pattern.class, RegexConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, CipherSuiteSelector.class, CipherSuiteSelectorConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, Protocol.class, ProtocolConverter.class));
        configurationTypes.produce(new ConfigurationCustomConverterBuildItem(200, Path.class, PathConverter.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    public void initializeConfiguration(List<ConfigurationCustomConverterBuildItem> converters, Consumer<RunTimeConfigurationBuildItem> runTimeConfigConsumer, Consumer<BuildTimeConfigurationBuildItem> buildTimeConfigConsumer, Consumer<BuildTimeRunTimeFixedConfigurationBuildItem> buildTimeRunTimeConfigConsumer, Consumer<GeneratedResourceBuildItem> resourceConsumer, Consumer<SubstrateResourceBuildItem> niResourceConsumer, Consumer<RunTimeConfigurationDefaultBuildItem> runTimeDefaultConsumer, ExtensionClassLoaderBuildItem extensionClassLoaderBuildItem, ArchiveRootBuildItem archiveRootBuildItem) throws IOException, ClassNotFoundException {
        byte[] bytes;
        ConfigDefinition buildTimeConfig = new ConfigDefinition(FieldDescriptor.of((String)"Bogus", (String)"No field", (String)"Nothing"));
        ConfigDefinition buildTimeRunTimeConfig = new ConfigDefinition(BUILD_TIME_CONFIG_FIELD);
        ConfigDefinition runTimeConfig = new ConfigDefinition(RUN_TIME_CONFIG_FIELD);
        for (Class<?> clazz : ServiceUtil.classesNamedIn(extensionClassLoaderBuildItem.getExtensionClassLoader(), CONFIG_ROOTS_LIST)) {
            ConfigRoot annotation = clazz.getAnnotation(ConfigRoot.class);
            if (annotation == null) {
                log.warnf("Ignoring configuration root %s because it has no annotation", clazz);
                continue;
            }
            ConfigPhase phase = annotation.phase();
            if (phase == ConfigPhase.RUN_TIME) {
                runTimeConfig.registerConfigRoot(clazz);
                continue;
            }
            if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                buildTimeRunTimeConfig.registerConfigRoot(clazz);
                continue;
            }
            if (phase == ConfigPhase.BUILD_TIME) {
                buildTimeConfig.registerConfigRoot(clazz);
                continue;
            }
            log.warnf("Unrecognized configuration phase \"%s\" on %s", (Object)phase, clazz);
        }
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.withWrapper(ExpandingConfigSource::new);
        builder.addDefaultSources();
        ApplicationPropertiesConfigSource.InJar inJar = new ApplicationPropertiesConfigSource.InJar();
        builder.withSources(new ConfigSource[]{inJar});
        for (ConfigurationCustomConverterBuildItem converter : converters) {
            ConfigurationSetup.withConverterHelper(builder, converter.getType(), converter.getPriority(), converter.getConverter());
        }
        SmallRyeConfig src = (SmallRyeConfig)builder.build();
        SmallRyeConfigProviderResolver.instance().registerConfig((Config)src, Thread.currentThread().getContextClassLoader());
        HashSet<String> unmatched = new HashSet<String>();
        ConfigDefinition.loadConfiguration(src, unmatched, buildTimeConfig, buildTimeRunTimeConfig, runTimeConfig);
        Set inJarPropertyNames = inJar.getPropertyNames();
        unmatched.removeIf(s -> !inJarPropertyNames.contains(s) && !s.startsWith("quarkus."));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Object object = null;
        try {
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)buildTimeRunTimeConfig.getLoadedProperties());
                properties.store(osw, "This file is generated from captured build-time values; do not edit this file manually");
            }
            os.flush();
            bytes = os.toByteArray();
        }
        catch (Throwable osw) {
            object = osw;
            throw osw;
        }
        finally {
            if (os != null) {
                if (object != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable osw) {
                        ((Throwable)object).addSuppressed(osw);
                    }
                } else {
                    os.close();
                }
            }
        }
        resourceConsumer.accept(new GeneratedResourceBuildItem("META-INF/build-config.properties", bytes));
        niResourceConsumer.accept(new SubstrateResourceBuildItem("META-INF/build-config.properties"));
        unmatched.addAll(runTimeConfig.getLoadedProperties().keySet());
        boolean old = ExpandingConfigSource.setExpanding((boolean)false);
        try {
            for (String propName : unmatched) {
                runTimeDefaultConsumer.accept(new RunTimeConfigurationDefaultBuildItem(propName, (String)src.getValue(propName, String.class)));
            }
        }
        finally {
            ExpandingConfigSource.setExpanding((boolean)old);
        }
        runTimeConfigConsumer.accept(new RunTimeConfigurationBuildItem(runTimeConfig));
        buildTimeRunTimeConfigConsumer.accept(new BuildTimeRunTimeFixedConfigurationBuildItem(buildTimeRunTimeConfig));
        buildTimeConfigConsumer.accept(new BuildTimeConfigurationBuildItem(buildTimeConfig));
    }

    private static <T> void withConverterHelper(SmallRyeConfigBuilder builder, Class<T> type, int priority, Class<? extends Converter<?>> converterClass) {
        try {
            builder.withConverter(type, priority, converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            throw ReflectUtil.toError(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectUtil.toError(e);
        }
        catch (NoSuchMethodException e) {
            throw ReflectUtil.toError(e);
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }

    @BuildStep
    void setUpConfigFile(BuildProducer<RunTimeConfigurationSourceBuildItem> configSourceConsumer) {
        configSourceConsumer.produce(new RunTimeConfigurationSourceBuildItem(ApplicationPropertiesConfigSource.InJar.class.getName(), OptionalInt.empty()));
        configSourceConsumer.produce(new RunTimeConfigurationSourceBuildItem(ApplicationPropertiesConfigSource.InFileSystem.class.getName(), OptionalInt.empty()));
    }

    @BuildStep
    RunTimeConfigurationSourceBuildItem writeDefaults(List<RunTimeConfigurationDefaultBuildItem> defaults, Consumer<GeneratedResourceBuildItem> resourceConsumer, Consumer<SubstrateResourceBuildItem> niResourceConsumer) throws IOException {
        Properties properties = new Properties();
        for (RunTimeConfigurationDefaultBuildItem item : defaults) {
            String key = item.getKey();
            String value = item.getValue();
            String existing = properties.getProperty(key);
            if (existing != null && !existing.equals(value)) {
                log.warnf("Two conflicting default values were specified for configuration key \"%s\": \"%s\" and \"%s\" (using \"%2$s\")", (Object)key, (Object)existing, (Object)value);
                continue;
            }
            properties.setProperty(key, value);
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            properties.store(osw, "This is the generated set of default configuration values");
            osw.flush();
            resourceConsumer.accept(new GeneratedResourceBuildItem("META-INF/quarkus-default-config.properties", os.toByteArray()));
            niResourceConsumer.accept(new SubstrateResourceBuildItem("META-INF/quarkus-default-config.properties"));
        }
        return new RunTimeConfigurationSourceBuildItem(DefaultConfigSource.class.getName(), OptionalInt.empty());
    }

    @BuildStep
    void finalizeConfigLoader(RunTimeConfigurationBuildItem runTimeConfigItem, BuildTimeRunTimeFixedConfigurationBuildItem buildTimeRunTimeConfigItem, final Consumer<GeneratedClassBuildItem> classConsumer, Consumer<RuntimeInitializedClassBuildItem> runTimeInitConsumer, Consumer<BytecodeRecorderObjectLoaderBuildItem> objectLoaderConsumer, List<ConfigurationCustomConverterBuildItem> converters, List<RunTimeConfigurationSourceBuildItem> runTimeSources) {
        Throwable throwable;
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                classConsumer.accept(new GeneratedClassBuildItem(false, name, data));
            }
        };
        AccessorFinder accessorFinder = new AccessorFinder();
        final ConfigDefinition runTimeConfigDef = runTimeConfigItem.getConfigDefinition();
        ConfigPatternMap<LeafConfigType> runTimePatterns = runTimeConfigDef.getLeafPatterns();
        runTimeConfigDef.generateConfigRootClass(classOutput, accessorFinder);
        final ConfigDefinition buildTimeConfigDef = buildTimeRunTimeConfigItem.getConfigDefinition();
        ConfigPatternMap<LeafConfigType> buildTimePatterns = buildTimeConfigDef.getLeafPatterns();
        buildTimeConfigDef.generateConfigRootClass(classOutput, accessorFinder);
        HashSet encountered = new HashSet();
        ArrayList<Class> configTypes = new ArrayList<Class>();
        for (LeafConfigType item : runTimePatterns) {
            Class<?> typeClass = item.getItemClass();
            if (typeClass.isPrimitive() || !encountered.add(typeClass) || ConverterFactory.getImplicitConverter(typeClass) == null) continue;
            configTypes.add(typeClass);
        }
        configTypes.sort(Comparator.comparing(Class::getName));
        int converterCnt = configTypes.size();
        try (ClassCreator cc = new ClassCreator(classOutput, BUILD_TIME_CONFIG, null, Object.class.getName(), new String[0]);){
            cc.getFieldCreator(CONVERTERS_FIELD).setModifiers(24);
            cc.getFieldCreator(BUILD_TIME_CONFIG_FIELD).setModifiers(73);
            throwable = null;
            try (MethodCreator clinit = cc.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);){
                clinit.setModifiers(8);
                BranchResult inImageBuild = clinit.ifNonZero(clinit.invokeStaticMethod(MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageBuildtimeCode", Boolean.TYPE, (Class[])new Class[0]), new ResultHandle[0]));
                try (BytecodeCreator yes = inImageBuild.trueBranch();){
                    ResultHandle array = yes.newArray(Converter.class, yes.load(converterCnt));
                    for (int i = 0; i < converterCnt; ++i) {
                        yes.writeArrayValue(array, i, yes.invokeStaticMethod(CF_GET_IMPLICIT_CONVERTER, new ResultHandle[]{yes.loadClass((Class)configTypes.get(i))}));
                    }
                    yes.writeStaticField(CONVERTERS_FIELD, array);
                }
                var23_33 = null;
                try (BytecodeCreator no = inImageBuild.falseBranch();){
                    no.writeStaticField(CONVERTERS_FIELD, no.loadNull());
                }
                catch (Throwable array) {
                    var23_33 = array;
                    throw array;
                }
                ResultHandle builder = clinit.newInstance(SRCB_CONSTRUCT, new ResultHandle[0]);
                ResultHandle array = clinit.newArray(ConfigSource[].class, clinit.load(1));
                clinit.writeArrayValue(array, 0, clinit.invokeStaticMethod(BTCF_GET_CONFIG_SOURCE, new ResultHandle[0]));
                clinit.invokeVirtualMethod(SRCB_WITH_SOURCES, builder, new ResultHandle[]{array});
                clinit.invokeVirtualMethod(SRCB_ADD_DEFAULT_SOURCES, builder, new ResultHandle[0]);
                ResultHandle config = clinit.checkCast(clinit.invokeVirtualMethod(SRCB_BUILD, builder, new ResultHandle[0]), SmallRyeConfig.class);
                clinit.writeStaticField(BUILD_TIME_CONFIG_FIELD, clinit.newInstance(MethodDescriptor.ofConstructor((Object)BUILD_TIME_CONFIG_ROOT, (Object[])new Object[]{SmallRyeConfig.class}), new ResultHandle[]{config}));
                this.writeParsing(cc, (BytecodeCreator)clinit, config, buildTimePatterns);
                clinit.returnValue(null);
            }
            catch (Throwable inImageBuild) {
                throwable = inImageBuild;
                throw inImageBuild;
            }
        }
        cc = new ClassCreator(classOutput, RUN_TIME_CONFIG, null, Object.class.getName(), new String[0]);
        var18_19 = null;
        try {
            cc.getFieldCreator(RUN_TIME_CONFIG_FIELD).setModifiers(73);
            throwable = null;
            try (MethodCreator carc = cc.getMethodCreator(CREATE_RUN_TIME_CONFIG);){
                carc.setModifiers(9);
                ResultHandle builder = carc.newInstance(SRCB_CONSTRUCT, new ResultHandle[0]);
                carc.invokeVirtualMethod(SRCB_ADD_DEFAULT_SOURCES, builder, new ResultHandle[0]);
                int size = runTimeSources.size();
                if (size > 0) {
                    ResultHandle arrayHandle = carc.newArray(ConfigSource[].class, carc.load(size));
                    for (int i = 0; i < size; ++i) {
                        RunTimeConfigurationSourceBuildItem source = runTimeSources.get(i);
                        OptionalInt priority = source.getPriority();
                        ResultHandle val = priority.isPresent() ? carc.newInstance(MethodDescriptor.ofConstructor((Object)source.getClassName(), (Object[])new Object[]{Integer.TYPE}), new ResultHandle[]{carc.load(priority.getAsInt())}) : carc.newInstance(MethodDescriptor.ofConstructor((String)source.getClassName(), (String[])new String[0]), new ResultHandle[0]);
                        carc.writeArrayValue(arrayHandle, i, val);
                    }
                    carc.invokeVirtualMethod(SRCB_WITH_SOURCES, builder, new ResultHandle[]{arrayHandle});
                }
                for (ConfigurationCustomConverterBuildItem converter : converters) {
                    carc.invokeVirtualMethod(SRCB_WITH_CONVERTER, builder, new ResultHandle[]{carc.loadClass(converter.getType()), carc.load(converter.getPriority()), carc.newInstance(MethodDescriptor.ofConstructor(converter.getConverter(), (Class[])new Class[0]), new ResultHandle[0])});
                }
                ResultHandle wrapper = carc.readStaticField(ECS_WRAPPER);
                carc.invokeVirtualMethod(SRCB_WITH_WRAPPER, builder, new ResultHandle[]{wrapper});
                BranchResult imgRun = carc.ifNonZero(carc.invokeStaticMethod(II_IN_IMAGE_RUN, new ResultHandle[0]));
                try (BytecodeCreator inImageRun = imgRun.trueBranch();){
                    ResultHandle array = inImageRun.readStaticField(CONVERTERS_FIELD);
                    for (int i = 0; i < converterCnt; ++i) {
                        inImageRun.invokeVirtualMethod(SRCB_WITH_CONVERTER, builder, new ResultHandle[]{inImageRun.loadClass((Class)configTypes.get(i)), inImageRun.load(100), inImageRun.readArrayValue(array, i)});
                    }
                }
                ResultHandle config = carc.checkCast(carc.invokeVirtualMethod(SRCB_BUILD, builder, new ResultHandle[0]), SmallRyeConfig.class);
                carc.invokeStaticMethod(CPR_SET_INSTANCE, new ResultHandle[]{carc.newInstance(SCPR_CONSTRUCT, new ResultHandle[0])});
                carc.invokeVirtualMethod(CPR_REGISTER_CONFIG, carc.invokeStaticMethod(CPR_INSTANCE, new ResultHandle[0]), new ResultHandle[]{config, carc.loadNull()});
                carc.writeStaticField(RUN_TIME_CONFIG_FIELD, carc.newInstance(MethodDescriptor.ofConstructor((Object)RUN_TIME_CONFIG_ROOT, (Object[])new Object[]{SmallRyeConfig.class}), new ResultHandle[]{config}));
                this.writeParsing(cc, (BytecodeCreator)carc, config, runTimePatterns);
                carc.returnValue(null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var18_19 = throwable3;
            throw throwable3;
        }
        finally {
            if (cc != null) {
                if (var18_19 != null) {
                    try {
                        cc.close();
                    }
                    catch (Throwable throwable4) {
                        var18_19.addSuppressed(throwable4);
                    }
                } else {
                    cc.close();
                }
            }
        }
        objectLoaderConsumer.accept(new BytecodeRecorderObjectLoaderBuildItem(new ObjectLoader(){

            @Override
            public ResultHandle load(BytecodeCreator body, Object obj, boolean staticInit) {
                boolean buildTime = false;
                ConfigDefinition.RootInfo rootInfo = runTimeConfigDef.getInstanceInfo(obj);
                if (rootInfo == null) {
                    rootInfo = buildTimeConfigDef.getInstanceInfo(obj);
                    buildTime = true;
                }
                if (rootInfo == null || staticInit && !buildTime) {
                    Class<?> objClass = obj.getClass();
                    if (objClass.isAnnotationPresent(ConfigRoot.class)) {
                        String msg = String.format("You are trying to use a ConfigRoot[%s] at static initialization time", objClass.getName());
                        throw new IllegalStateException(msg);
                    }
                    return null;
                }
                FieldDescriptor fieldDescriptor = rootInfo.getFieldDescriptor();
                ResultHandle configRoot = body.readStaticField(buildTime ? BUILD_TIME_CONFIG_FIELD : RUN_TIME_CONFIG_FIELD);
                return body.readInstanceField(fieldDescriptor, configRoot);
            }
        }));
        runTimeInitConsumer.accept(new RuntimeInitializedClassBuildItem(RUN_TIME_CONFIG));
    }

    private void writeParsing(ClassCreator cc, BytecodeCreator body, ResultHandle config, ConfigPatternMap<LeafConfigType> keyMap) {
        ResultHandle iterable = body.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getPropertyNames", Iterable.class, (Class[])new Class[0]), config, new ResultHandle[0]);
        ResultHandle iterator = body.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), iterable, new ResultHandle[0]);
        try (BytecodeCreator loop = body.createScope();){
            BranchResult ifHasNext = loop.ifNonZero(loop.invokeInterfaceMethod(ITR_HAS_NEXT, iterator, new ResultHandle[0]));
            try (BytecodeCreator hasNext = ifHasNext.trueBranch();){
                ResultHandle key = hasNext.checkCast(hasNext.invokeInterfaceMethod(ITR_NEXT, iterator, new ResultHandle[0]), String.class);
                ResultHandle keyIter = hasNext.newInstance(MethodDescriptor.ofConstructor(NameIterator.class, (Class[])new Class[]{String.class}), new ResultHandle[]{key});
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch().continueScope(loop);
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{hasNext.load("quarkus")})).falseBranch().continueScope(loop);
                hasNext.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                hasNext.invokeStaticMethod(this.generateParserBody(cc, keyMap, new StringBuilder("parseKey"), new HashMap<String, MethodDescriptor>()), new ResultHandle[]{config, keyIter});
                hasNext.continueScope(loop);
            }
        }
        body.returnValue(body.loadNull());
    }

    private MethodDescriptor generateParserBody(ClassCreator cc, ConfigPatternMap<LeafConfigType> keyMap, StringBuilder methodName, Map<String, MethodDescriptor> parseMethodCache) {
        String methodNameStr = methodName.toString();
        MethodDescriptor existing = parseMethodCache.get(methodNameStr);
        if (existing != null) {
            return existing;
        }
        try (MethodCreator body = cc.getMethodCreator(methodName.toString(), Void.TYPE, new Class[]{SmallRyeConfig.class, NameIterator.class});){
            Object object;
            body.setModifiers(10);
            ResultHandle config = body.getMethodParam(0);
            ResultHandle keyIter = body.getMethodParam(1);
            LeafConfigType matched = keyMap.getMatched();
            try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                if (matched != null) {
                    matched.generateAcceptConfigurationValue(matchedBody, keyIter, config);
                }
                matchedBody.returnValue(null);
            }
            boolean hasWildCard = false;
            Iterable<String> names = keyMap.childNames();
            for (String name : names) {
                if (name.equals("{*}")) {
                    hasWildCard = true;
                    continue;
                }
                BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();
                Throwable throwable = null;
                try {
                    nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append(name);
                    nameMatched.invokeStaticMethod(this.generateParserBody(cc, keyMap.getChild(name), methodName, parseMethodCache), new ResultHandle[]{config, keyIter});
                    methodName.setLength(length);
                    nameMatched.returnValue(null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameMatched == null) continue;
                    if (throwable != null) {
                        try {
                            nameMatched.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameMatched.close();
                }
            }
            if (hasWildCard) {
                BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).trueBranch();
                object = null;
                try {
                    matchedBody.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    int length = methodName.length();
                    methodName.append('_').append("wildcard");
                    matchedBody.invokeStaticMethod(this.generateParserBody(cc, keyMap.getChild("{*}"), methodName, parseMethodCache), new ResultHandle[]{config, keyIter});
                    methodName.setLength(length);
                    matchedBody.returnValue(null);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (matchedBody != null) {
                        if (object != null) {
                            try {
                                matchedBody.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            matchedBody.close();
                        }
                    }
                }
            }
            body.returnValue(null);
            MethodDescriptor md = body.getMethodDescriptor();
            parseMethodCache.put(methodNameStr, md);
            object = md;
            return object;
        }
    }

    @BuildStep
    void writeDefaultConfiguration() {
    }
}

