/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.Base58;

public final class ConfigureUtil {
    private static final Map<String, Properties> DEVSERVICES_PROPS = new ConcurrentHashMap<String, Properties>();

    private ConfigureUtil() {
    }

    public static String configureSharedNetwork(GenericContainer<?> container, String hostNamePrefix) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl.getName().contains("Deployment")) {
            try {
                Class<?> networkClass = tccl.getParent().loadClass("org.testcontainers.containers.Network");
                Object sharedNetwork = networkClass.getField("SHARED").get(null);
                container.setNetwork((Network)sharedNetwork);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to obtain SHARED network from testcontainers", e);
            }
        } else {
            container.setNetwork(Network.SHARED);
        }
        String hostName = hostNamePrefix + "-" + Base58.randomString((int)5);
        container.setNetworkAliases(Collections.singletonList(hostName));
        return hostName;
    }

    public static String getDefaultImageNameFor(String devserviceName) {
        String imageName = DEVSERVICES_PROPS.computeIfAbsent(devserviceName, ConfigureUtil::loadProperties).getProperty("default.image");
        if (imageName == null) {
            throw new IllegalArgumentException("No default.image configured for " + devserviceName);
        }
        return imageName;
    }

    private static Properties loadProperties(String devserviceName) {
        Properties properties;
        block9: {
            String fileName = devserviceName + "-devservice.properties";
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            try {
                if (in == null) {
                    throw new IllegalArgumentException(fileName + " not found on classpath");
                }
                Properties properties2 = new Properties();
                properties2.load(in);
                properties = properties2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return properties;
    }
}

