/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mariadb.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MariaDBDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(MariaDBDevServicesProcessor.class);
    public static final String TAG = "10.5.9";
    public static final Integer PORT = 3306;

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMariaDB(final Optional<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("mariadb", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties, OptionalInt fixedExposedPort, LaunchMode launchMode) {
                final QuarkusMariaDBContainer container = new QuarkusMariaDBContainer(imageName, fixedExposedPort, devServicesSharedNetworkBuildItem.isPresent());
                container.withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default"));
                additionalProperties.forEach((arg_0, arg_1) -> ((QuarkusMariaDBContainer)container).withUrlParam(arg_0, arg_1));
                container.start();
                LOG.info((Object)"Dev Services for MariaDB started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getEffectiveJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                        LOG.info((Object)"Dev Services for MariaDB shut down.");
                    }
                });
            }
        });
    }

    private static class QuarkusMariaDBContainer
    extends MariaDBContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusMariaDBContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElse(MariaDBContainer.IMAGE + ":10.5.9")).asCompatibleSubstituteFor(DockerImageName.parse((String)MariaDBContainer.IMAGE)));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mariadb");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), PORT);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters("?", "&");
                return "jdbc:mariadb://" + this.hostName + ":" + PORT + "/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }
    }
}

