/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing.codestarts;

import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class QuarkusCodestartTesting {
    public static Collection<String> getPlatformBoms() {
        return Collections.singletonList("io.quarkus:quarkus-mock-bom:999-MOCK");
    }

    public static Map<String, Object> getMockedTestInputData(Map<String, Object> override) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(QuarkusCodestartData.QuarkusDataKey.PROJECT_GROUP_ID.key(), "org.test");
        data.put(QuarkusCodestartData.QuarkusDataKey.PROJECT_ARTIFACT_ID.key(), "test-codestart");
        data.put(QuarkusCodestartData.QuarkusDataKey.PROJECT_VERSION.key(), "1.0.0-codestart");
        data.put(QuarkusCodestartData.QuarkusDataKey.BOM_GROUP_ID.key(), "io.quarkus");
        data.put(QuarkusCodestartData.QuarkusDataKey.BOM_ARTIFACT_ID.key(), "quarkus-mock-bom");
        data.put(QuarkusCodestartData.QuarkusDataKey.BOM_VERSION.key(), "999-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_VERSION.key(), "999-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_MAVEN_PLUGIN_GROUP_ID.key(), "io.quarkus");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_MAVEN_PLUGIN_ARTIFACT_ID.key(), "quarkus-mock-maven-plugin");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_MAVEN_PLUGIN_VERSION.key(), "999-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_GRADLE_PLUGIN_ID.key(), "io.quarkus");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_GRADLE_PLUGIN_VERSION.key(), "999-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.JAVA_VERSION.key(), "11");
        data.put(QuarkusCodestartData.QuarkusDataKey.KOTLIN_VERSION.key(), "1.4.28-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.SCALA_VERSION.key(), "2.12.8-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.SCALA_MAVEN_PLUGIN_VERSION.key(), "4.1.1-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.MAVEN_COMPILER_PLUGIN_VERSION.key(), "3.8.1-MOCK");
        data.put(QuarkusCodestartData.QuarkusDataKey.MAVEN_SUREFIRE_PLUGIN_VERSION.key(), "3.0.0-MOCK");
        if (override != null) {
            data.putAll(override);
        }
        return data;
    }

    public static Map<String, Object> getRealTestInputData(ExtensionCatalog catalog, Map<String, Object> override) {
        ArtifactCoords bom = catalog.getBom();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Properties quarkusProp = QuarkusCodestartTesting.getQuarkusProperties(catalog);
        data.put(QuarkusCodestartData.QuarkusDataKey.PROJECT_GROUP_ID.key(), "org.test");
        data.put(QuarkusCodestartData.QuarkusDataKey.PROJECT_ARTIFACT_ID.key(), "test-codestart");
        data.put(QuarkusCodestartData.QuarkusDataKey.PROJECT_VERSION.key(), "1.0.0-codestart");
        data.put(QuarkusCodestartData.QuarkusDataKey.BOM_GROUP_ID.key(), bom.getGroupId());
        data.put(QuarkusCodestartData.QuarkusDataKey.BOM_ARTIFACT_ID.key(), bom.getArtifactId());
        data.put(QuarkusCodestartData.QuarkusDataKey.BOM_VERSION.key(), bom.getVersion());
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_VERSION.key(), catalog.getQuarkusCoreVersion());
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_MAVEN_PLUGIN_GROUP_ID.key(), "io.quarkus");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_MAVEN_PLUGIN_ARTIFACT_ID.key(), "quarkus-maven-plugin");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_MAVEN_PLUGIN_VERSION.key(), catalog.getQuarkusCoreVersion());
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_GRADLE_PLUGIN_ID.key(), "io.quarkus");
        data.put(QuarkusCodestartData.QuarkusDataKey.QUARKUS_GRADLE_PLUGIN_VERSION.key(), catalog.getQuarkusCoreVersion());
        data.put(QuarkusCodestartData.QuarkusDataKey.KOTLIN_VERSION.key(), quarkusProp.getProperty("kotlin-version"));
        data.put(QuarkusCodestartData.QuarkusDataKey.SCALA_VERSION.key(), quarkusProp.getProperty("scala-version"));
        data.put(QuarkusCodestartData.QuarkusDataKey.SCALA_MAVEN_PLUGIN_VERSION.key(), quarkusProp.getProperty("scala-plugin-version"));
        data.put(QuarkusCodestartData.QuarkusDataKey.MAVEN_COMPILER_PLUGIN_VERSION.key(), quarkusProp.getProperty("compiler-plugin-version"));
        data.put(QuarkusCodestartData.QuarkusDataKey.MAVEN_SUREFIRE_PLUGIN_VERSION.key(), quarkusProp.getProperty("surefire-plugin-version"));
        data.put(QuarkusCodestartData.QuarkusDataKey.JAVA_VERSION.key(), "11");
        if (override != null) {
            data.putAll(override);
        }
        return data;
    }

    public static Collection<String> getBoms(Map<String, Object> inputData) {
        return Collections.singletonList(QuarkusCodestartTesting.getBom(inputData));
    }

    private static String getBom(Map<String, Object> inputData) {
        return QuarkusCodestartTesting.getRequiredValue(inputData, QuarkusCodestartData.QuarkusDataKey.BOM_GROUP_ID) + ":" + QuarkusCodestartTesting.getRequiredValue(inputData, QuarkusCodestartData.QuarkusDataKey.BOM_ARTIFACT_ID) + ":" + QuarkusCodestartTesting.getRequiredValue(inputData, QuarkusCodestartData.QuarkusDataKey.BOM_VERSION);
    }

    private static Object getRequiredValue(Map<String, Object> inputData, QuarkusCodestartData.QuarkusDataKey key) {
        Object o = inputData.get(key.key());
        if (o == null) {
            throw new IllegalArgumentException("Required key " + key.key() + " is missing among " + inputData.keySet());
        }
        return o;
    }

    private static Properties getQuarkusProperties(ExtensionCatalog catalog) {
        return ToolsUtils.readQuarkusProperties((ExtensionCatalog)catalog);
    }
}

