/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing.registry.client;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.testing.registry.client.TestRegistryClientBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.client.spi.RegistryClientEnvironment;
import io.quarkus.registry.config.RegistriesConfigLocator;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class TestRegistryClient
implements RegistryClient {
    private final MavenArtifactResolver resolver;
    private final MessageWriter log;
    private final RegistryConfig config;
    private final Path registryDir;
    private final boolean enableMavenResolver;

    public TestRegistryClient(RegistryClientEnvironment env, RegistryConfig clientConfig) {
        Object o;
        RegistryConfig.Mutable registryConfig;
        this.resolver = env.resolver();
        this.log = env.log();
        Path configYaml = RegistriesConfigLocator.locateConfigYaml();
        if (configYaml == null) {
            throw new IllegalStateException("Failed to locate the dev tools config file (.quarkus/config.yaml)");
        }
        this.registryDir = TestRegistryClientBuilder.getRegistryDir(configYaml.getParent(), clientConfig.getId());
        if (!Files.exists(this.registryDir, new LinkOption[0])) {
            throw new IllegalStateException("The test registry directory " + this.registryDir + " does not exist");
        }
        Path configPath = TestRegistryClientBuilder.getRegistryDescriptorPath(this.registryDir);
        try {
            registryConfig = RegistryConfig.mutableFromFile((Path)configPath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize registry configuration from " + configPath, e);
        }
        registryConfig.setId(clientConfig.getId());
        if (clientConfig.getNonPlatformExtensions() != null) {
            registryConfig.setNonPlatformExtensions(clientConfig.getNonPlatformExtensions());
        }
        if (clientConfig.getPlatforms() != null) {
            registryConfig.setPlatforms(clientConfig.getPlatforms());
        }
        if (clientConfig.getDescriptor() != null) {
            registryConfig.setDescriptor(clientConfig.getDescriptor());
        }
        if (clientConfig.getQuarkusVersions() != null) {
            registryConfig.setQuarkusVersions(clientConfig.getQuarkusVersions());
        }
        this.enableMavenResolver = (o = clientConfig.getExtra().get("enable-maven-resolver")) == null ? false : Boolean.parseBoolean(o.toString());
        this.config = registryConfig;
    }

    public ExtensionCatalog.Mutable resolveNonPlatformExtensions(String quarkusVersion) throws RegistryResolutionException {
        if (this.config.getNonPlatformExtensions() == null || this.config.getNonPlatformExtensions().isDisabled()) {
            return null;
        }
        this.log.debug("%s resolveNonPlatformExtensions %s", new Object[]{this.config.getId(), quarkusVersion});
        Path json = TestRegistryClientBuilder.getRegistryNonPlatformCatalogPath(this.registryDir, quarkusVersion);
        if (Files.exists(json, new LinkOption[0])) {
            return this.deserializeExtensionCatalog(json);
        }
        return null;
    }

    public ExtensionCatalog.Mutable resolvePlatformExtensions(ArtifactCoords platformCoords) throws RegistryResolutionException {
        ArtifactCoords coords = PlatformArtifacts.ensureCatalogArtifact((ArtifactCoords)platformCoords);
        this.log.debug("%s resolvePlatformExtensions %s", new Object[]{this.config.getId(), coords});
        Path p = TestRegistryClientBuilder.getRegistryMemberCatalogPath(this.registryDir, PlatformArtifacts.ensureBomArtifact((ArtifactCoords)coords));
        if (!Files.exists(p, new LinkOption[0])) {
            if (this.enableMavenResolver) {
                try {
                    p = this.resolver.resolve((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion())).getArtifact().getFile().toPath();
                }
                catch (BootstrapMavenException e) {
                    throw new RegistryResolutionException("Failed to resolve " + coords, (Throwable)e);
                }
            } else {
                return null;
            }
        }
        return this.deserializeExtensionCatalog(p);
    }

    private ExtensionCatalog.Mutable deserializeExtensionCatalog(Path p) throws RegistryResolutionException {
        try {
            return ExtensionCatalog.mutableFromFile((Path)p);
        }
        catch (IOException e) {
            throw new RegistryResolutionException("Failed to deserialize " + p, (Throwable)e);
        }
    }

    public PlatformCatalog.Mutable resolvePlatforms(String quarkusVersion) throws RegistryResolutionException {
        Path json = TestRegistryClientBuilder.getRegistryPlatformsCatalogPath(this.registryDir, quarkusVersion);
        this.log.debug("%s resolvePlatforms %s", new Object[]{this.config.getId(), json});
        if (!Files.exists(json, new LinkOption[0])) {
            return null;
        }
        try {
            return PlatformCatalog.mutableFromFile((Path)json);
        }
        catch (IOException e) {
            throw new RegistryResolutionException("Failed to deserialize " + json, (Throwable)e);
        }
    }

    public RegistryConfig resolveRegistryConfig() throws RegistryResolutionException {
        return this.config;
    }

    public void clearCache() {
        this.log.debug("% clearCache not supported", new Object[]{this.config.getId()});
    }

    public static RegistryConfig getDefaultConfig() {
        return RegistryConfig.builder().setId("test.quarkus.registry").setExtra("client-factory-url", (Object)TestRegistryClient.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm()).build();
    }
}

