/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing.registry.client;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.devtools.testing.registry.client.TestRegistryClient;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.client.RegistryClientFactory;
import io.quarkus.registry.client.spi.RegistryClientEnvironment;
import io.quarkus.registry.config.RegistryConfig;

public class TestRegistryClientFactory
implements RegistryClientFactory {
    private static TestRegistryClientFactory instance;
    private final RegistryClientEnvironment env;

    public static TestRegistryClientFactory getInstance(RegistryClientEnvironment env) {
        if (instance != null) {
            return instance;
        }
        if (Thread.currentThread().getContextClassLoader() instanceof QuarkusClassLoader) {
            ((QuarkusClassLoader)Thread.currentThread().getContextClassLoader()).addCloseTask(() -> {
                instance = null;
            });
        }
        instance = new TestRegistryClientFactory(env);
        return instance;
    }

    private TestRegistryClientFactory(RegistryClientEnvironment env) {
        this.env = env;
    }

    public RegistryClient buildRegistryClient(RegistryConfig config) throws RegistryResolutionException {
        return new TestRegistryClient(this.env, config);
    }

    public static void reset() {
        instance = null;
    }
}

