/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.ldap;

import io.quarkus.elytron.security.ldap.DelegatingLdapContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.manager.action.SetContextClassLoaderAction;

public class QuarkusDirContextFactory
implements DirContextFactory {
    private static final String CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String SECURITY_AUTHENTICATION = "simple";
    private static final String DEFAULT_CONNECT_TIMEOUT = "5000";
    private static final String DEFAULT_READ_TIMEOUT = "60000";
    private static final String LDAPS_SCHEME = "ldaps";
    private final String providerUrl;
    private final String securityPrincipal;
    private final String securityCredential;
    private final ClassLoader targetClassLoader;

    public QuarkusDirContextFactory(String providerUrl, String securityPrincipal, String securityCredential) {
        this.providerUrl = providerUrl;
        this.securityPrincipal = securityPrincipal;
        this.securityCredential = securityCredential;
        this.targetClassLoader = this.getClass().getClassLoader();
    }

    public DirContext obtainDirContext(DirContextFactory.ReferralMode mode) throws NamingException {
        char[] charPassword = null;
        if (this.securityCredential != null) {
            charPassword = this.securityCredential.toCharArray();
        }
        return this.createDirContext(this.securityPrincipal, charPassword, mode);
    }

    public DirContext obtainDirContext(CallbackHandler handler, DirContextFactory.ReferralMode mode) throws NamingException {
        NameCallback nameCallback = new NameCallback("Principal Name");
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        try {
            handler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain credential", e);
        }
        String securityPrincipal = nameCallback.getName();
        if (securityPrincipal == null) {
            throw new RuntimeException("Could not obtain principal");
        }
        char[] securityCredential = passwordCallback.getPassword();
        if (securityCredential == null) {
            throw new RuntimeException("Could not obtain credential");
        }
        return this.createDirContext(securityPrincipal, securityCredential, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext createDirContext(String securityPrincipal, char[] securityCredential, DirContextFactory.ReferralMode mode) throws NamingException {
        ClassLoader oldClassLoader = this.setClassLoaderTo(this.targetClassLoader);
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
            env.put("java.naming.provider.url", this.providerUrl);
            env.put("java.naming.security.authentication", SECURITY_AUTHENTICATION);
            if (securityPrincipal != null) {
                env.put("java.naming.security.principal", securityPrincipal);
            }
            if (securityCredential != null) {
                env.put("java.naming.security.credentials", securityCredential);
            }
            env.put("java.naming.referral", mode == null ? DirContextFactory.ReferralMode.IGNORE.getValue() : mode.getValue());
            env.put(CONNECT_TIMEOUT, DEFAULT_CONNECT_TIMEOUT);
            env.put(READ_TIMEOUT, DEFAULT_READ_TIMEOUT);
            if (!NamingManager.hasInitialContextFactoryBuilder()) {
                NamingManager.setInitialContextFactoryBuilder(new QuarkusInitialContextFactoryBuilder());
            }
            InitialLdapContext initialContext = new InitialLdapContext(env, null);
            DelegatingLdapContext delegatingLdapContext = new DelegatingLdapContext(initialContext, this::returnContext, null);
            return delegatingLdapContext;
        }
        finally {
            this.setClassLoaderTo(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnContext(DirContext context) {
        if (context == null) {
            return;
        }
        if (context instanceof InitialDirContext) {
            ClassLoader oldClassLoader = this.setClassLoaderTo(this.targetClassLoader);
            try {
                context.close();
            }
            catch (NamingException namingException) {
            }
            finally {
                this.setClassLoaderTo(oldClassLoader);
            }
        }
    }

    private ClassLoader setClassLoaderTo(ClassLoader targetClassLoader) {
        return (ClassLoader)QuarkusDirContextFactory.doPrivileged(new SetContextClassLoaderAction(targetClassLoader));
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private static final class QuarkusInitialContextFactoryBuilder
    implements InitialContextFactoryBuilder {
        private QuarkusInitialContextFactoryBuilder() {
        }

        @Override
        public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
            String className = (String)environment.get("java.naming.factory.initial");
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return (InitialContextFactory)Class.forName(className, true, cl).newInstance();
            }
            catch (Exception e) {
                NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
                ne.setRootCause(e);
                throw ne;
            }
        }
    }
}

