/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.devui;

import io.quarkus.agroal.spi.JdbcInitialSQLGeneratorBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.devui.FlywayDevUIRecorder;
import io.quarkus.flyway.runtime.devui.FlywayJsonRpcService;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;

public class FlywayDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    CardPageBuildItem create(FlywayDevUIRecorder recorder, FlywayBuildTimeConfig buildTimeConfig, List<JdbcInitialSQLGeneratorBuildItem> generatorBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        HashMap<String, Supplier> initialSqlSuppliers = new HashMap<String, Supplier>();
        for (JdbcInitialSQLGeneratorBuildItem buildItem : generatorBuildItem) {
            initialSqlSuppliers.put(buildItem.getDatabaseName(), buildItem.getSqlSupplier());
        }
        String artifactId = curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getArtifactId();
        recorder.setInitialSqlSuppliers(initialSqlSuppliers, artifactId);
        CardPageBuildItem card = new CardPageBuildItem();
        card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().componentLink("qwc-flyway-datasources.js").dynamicLabelJsonRPCMethodName("getNumberOfDatasources")).icon("font-awesome-solid:database"));
        return card;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem registerJsonRpcBackend() {
        return new JsonRPCProvidersBuildItem(FlywayJsonRpcService.class);
    }
}

