/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.query;

import io.quarkus.funqy.runtime.query.BaseObjectReader;
import io.quarkus.funqy.runtime.query.QueryObjectMapper;
import io.quarkus.funqy.runtime.query.QueryPropertySetter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class QueryObjectReader
extends BaseObjectReader {
    Map<String, BaseObjectReader.ValueSetter> properties = new HashMap<String, BaseObjectReader.ValueSetter>();
    Class clz;

    @Override
    public Object create() {
        try {
            return this.clz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    QueryObjectReader(Class clz, QueryObjectMapper mapper) {
        this.clz = clz;
        for (final Method m : clz.getMethods()) {
            if (!QueryObjectReader.isSetter(m)) continue;
            Class<?> paramType = m.getParameterTypes()[0];
            Type paramGenericType = m.getGenericParameterTypes()[0];
            final Function<String, Object> extractor = mapper.extractor(paramType);
            QueryPropertySetter propertySetter = null;
            if (extractor == null) {
                propertySetter = mapper.setterFor(paramType, paramGenericType);
            }
            String name = m.getName().length() > 4 ? Character.toLowerCase(m.getName().charAt(3)) + m.getName().substring(4) : m.getName().substring(3).toLowerCase();
            final QueryPropertySetter finalPropertySetter = propertySetter;
            BaseObjectReader.ValueSetter setter = new BaseObjectReader.ValueSetter(){

                @Override
                public void setValue(Object target, String propName, Object value) {
                    try {
                        m.invoke(target, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Function<String, Object> getExtractor() {
                    return extractor;
                }

                @Override
                public QueryPropertySetter getSetter() {
                    return finalPropertySetter;
                }
            };
            this.properties.put(name, setter);
        }
    }

    static boolean isSetter(Method m) {
        return !Modifier.isStatic(m.getModifiers()) && m.getName().startsWith("set") && m.getName().length() > "set".length() && m.getParameterCount() == 1;
    }

    @Override
    BaseObjectReader.ValueSetter getValueSetter(String propName) {
        return this.properties.get(propName);
    }
}

