/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment.devui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import grpc.health.v1.HealthGrpc;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.grpc.deployment.DelegatingGrpcBeanBuildItem;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.runtime.devmode.CollectStreams;
import io.quarkus.grpc.runtime.devmode.DelegatingGrpcBeansStorage;
import io.quarkus.grpc.runtime.devmode.GrpcServices;
import io.quarkus.grpc.runtime.devmode.StreamCollectorInterceptor;
import io.quarkus.grpc.runtime.devui.GrpcJsonRPCService;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.inject.Singleton;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Flow;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class GrpcDevUIProcessor {
    private static final Logger log = Logger.getLogger(GrpcDevUIProcessor.class);

    @BuildStep(onlyIf={IsDevelopment.class})
    public AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.builder().addBeanClass(GrpcServices.class).addBeanClasses(new Class[]{StreamCollectorInterceptor.class, CollectStreams.class}).build();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void prepareDelegatingBeanStorage(List<DelegatingGrpcBeanBuildItem> delegatingBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        String className = "io.quarkus.grpc.internal.DelegatingGrpcBeansStorageImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(className).classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeans)).superClass(DelegatingGrpcBeansStorage.class).build();){
            classCreator.addAnnotation(Singleton.class.getName());
            MethodCreator constructor = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)className, (String[])new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(DelegatingGrpcBeansStorage.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            for (DelegatingGrpcBeanBuildItem delegatingBean : delegatingBeans) {
                constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(DelegatingGrpcBeansStorage.class, (String)"addDelegatingMapping", Void.TYPE, (Class[])new Class[]{String.class, String.class}), constructor.getThis(), new ResultHandle[]{constructor.load(delegatingBean.userDefinedBean.name().toString()), constructor.load(delegatingBean.generatedBean.name().toString())});
            }
            constructor.returnValue(null);
        }
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{className}));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void collectMessagePrototypes(CombinedIndexBuildItem index, BuildProducer<ServiceStartBuildItem> service) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InvalidProtocolBufferException {
        HashMap<CallSite, String> messagePrototypes = new HashMap<CallSite, String>();
        Collection<Class<?>> grpcServices = this.getGrpcServices(index.getIndex());
        for (Class<?> grpcServiceClass : grpcServices) {
            Method method = grpcServiceClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
            ServiceDescriptor serviceDescriptor = (ServiceDescriptor)method.invoke(null, new Object[0]);
            for (io.grpc.MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
                MethodDescriptor.Marshaller requestMarshaller = methodDescriptor.getRequestMarshaller();
                if (!(requestMarshaller instanceof MethodDescriptor.PrototypeMarshaller)) continue;
                MethodDescriptor.PrototypeMarshaller protoMarshaller = (MethodDescriptor.PrototypeMarshaller)requestMarshaller;
                Object prototype = protoMarshaller.getMessagePrototype();
                messagePrototypes.put((CallSite)((Object)(methodDescriptor.getFullMethodName() + "_REQUEST")), JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)prototype));
            }
        }
        DevConsoleManager.setGlobal((String)"io.quarkus.grpc.messagePrototypes", messagePrototypes);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    AnnotationsTransformerBuildItem transformUserDefinedServices(CombinedIndexBuildItem combinedIndexBuildItem) {
        final HashSet<DotName> servicesToTransform = new HashSet<DotName>();
        IndexView index = combinedIndexBuildItem.getIndex();
        for (AnnotationInstance annotation : index.getAnnotations(GrpcDotNames.GRPC_SERVICE)) {
            ClassInfo serviceClass;
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || this.getRawTypesInHierarchy(serviceClass = annotation.target().asClass(), index).contains(GrpcDotNames.MUTINY_SERVICE)) continue;
            ClassInfo abstractBindableService = this.findAbstractBindableService(serviceClass, index);
            if (abstractBindableService != null) {
                ClassInfo enclosingClass;
                ClassInfo classInfo = enclosingClass = serviceClass.enclosingClass() != null ? index.getClassByName(serviceClass.enclosingClass()) : null;
                if (enclosingClass != null && this.getRawTypesInHierarchy(enclosingClass, index).contains(GrpcDotNames.MUTINY_GRPC)) continue;
            }
            servicesToTransform.add(annotation.target().asClass().name());
        }
        if (servicesToTransform.isEmpty()) {
            return null;
        }
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (servicesToTransform.contains(clazz.name())) {
                    context.transform().add(CollectStreams.class, new AnnotationValue[0]).done();
                }
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem pages(CombinedIndexBuildItem index) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InvalidProtocolBufferException {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:gears")).componentLink("qwc-grpc-services.js"));
        Map<String, GrpcServiceClassInfo> m = this.createGrpcServiceClassInfos(this.getGrpcServices(index.getIndex()));
        DevConsoleManager.register((String)"grpc-action", params -> {
            try {
                return this.grpcAction((Map<String, String>)params, m);
            }
            catch (InvalidProtocolBufferException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        });
        return cardPageBuildItem;
    }

    private Set<DotName> getRawTypesInHierarchy(ClassInfo clazz, IndexView index) {
        HashSet<DotName> rawTypes = new HashSet<DotName>();
        this.addRawTypes(clazz, index, rawTypes);
        return rawTypes;
    }

    private void addRawTypes(ClassInfo clazz, IndexView index, Set<DotName> rawTypes) {
        ClassInfo superClazz;
        rawTypes.add(clazz.name());
        for (DotName interfaceName : clazz.interfaceNames()) {
            rawTypes.add(interfaceName);
            ClassInfo interfaceClazz = index.getClassByName(interfaceName);
            if (interfaceClazz == null) continue;
            this.addRawTypes(interfaceClazz, index, rawTypes);
        }
        if (clazz.superName() != null && !clazz.superName().equals((Object)DotNames.OBJECT) && (superClazz = index.getClassByName(clazz.superName())) != null) {
            this.addRawTypes(superClazz, index, rawTypes);
        }
    }

    private ClassInfo findAbstractBindableService(ClassInfo clazz, IndexView index) {
        ClassInfo superClazz;
        if (clazz.interfaceNames().contains(GrpcDotNames.BINDABLE_SERVICE)) {
            return clazz;
        }
        if (clazz.superName() != null && !clazz.superName().equals((Object)DotNames.OBJECT) && (superClazz = index.getClassByName(clazz.superName())) != null) {
            return this.findAbstractBindableService(superClazz, index);
        }
        return null;
    }

    private Flow.Publisher<String> grpcAction(Map<String, String> params, Map<String, GrpcServiceClassInfo> grpcClientStubs) throws InvalidProtocolBufferException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String serviceName = params.get("serviceName");
        String methodName = params.get("methodName");
        String methodType = params.get("methodType");
        String content = params.get("content");
        String host = params.get("host");
        int port = Integer.valueOf(params.get("port"));
        BroadcastProcessor streamEvent = BroadcastProcessor.create();
        GrpcServiceClassInfo info = grpcClientStubs.get(serviceName);
        Object grpcStub = this.createStub(info.grpcServiceClass, host, port);
        ServiceDescriptor serviceDescriptor = info.serviceDescriptor;
        io.grpc.MethodDescriptor methodDescriptor = this.getMethodDescriptor(serviceDescriptor, methodName);
        MethodDescriptor.Marshaller requestMarshaller = methodDescriptor.getRequestMarshaller();
        MethodDescriptor.PrototypeMarshaller protoMarshaller = (MethodDescriptor.PrototypeMarshaller)requestMarshaller;
        Class<?> requestType = protoMarshaller.getMessagePrototype().getClass();
        Method newBuilderMethod = requestType.getDeclaredMethod("newBuilder", new Class[0]);
        Message.Builder builder = (Message.Builder)newBuilderMethod.invoke(null, new Object[0]);
        JsonFormat.parser().merge(content, builder);
        Message message = builder.build();
        TestObserver responseObserver = new TestObserver((BroadcastProcessor<String>)streamEvent);
        Method stubMethod = this.getStubMethod(grpcStub, methodDescriptor.getBareMethodName());
        stubMethod.invoke(grpcStub, message, responseObserver);
        return streamEvent.convert().toPublisher();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCServiceForCache() {
        return new JsonRPCProvidersBuildItem(GrpcJsonRPCService.class);
    }

    private Map<String, GrpcServiceClassInfo> createGrpcServiceClassInfos(Collection<Class<?>> grpcServices) {
        HashMap<String, GrpcServiceClassInfo> m = new HashMap<String, GrpcServiceClassInfo>();
        for (Class<?> grpcServiceClass : grpcServices) {
            ServiceDescriptor serviceDescriptor = this.createServiceDescriptor(grpcServiceClass);
            GrpcServiceClassInfo s = new GrpcServiceClassInfo(serviceDescriptor, grpcServiceClass);
            m.put(serviceDescriptor.getName(), s);
        }
        return m;
    }

    private ServiceDescriptor createServiceDescriptor(Class<?> grpcServiceClass) {
        try {
            Method method = grpcServiceClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
            return (ServiceDescriptor)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.warnf("Could not create stub for %s - " + e.getMessage(), grpcServiceClass);
            return null;
        }
    }

    private Object createStub(Class<?> grpcServiceClass, String host, int port) {
        try {
            Method stubFactoryMethod = grpcServiceClass.getDeclaredMethod("newStub", Channel.class);
            return stubFactoryMethod.invoke(null, this.getChannel(host, port));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warnf("Could not create stub for %s - " + e.getMessage(), grpcServiceClass);
            return null;
        }
    }

    private Channel getChannel(String host, int port) {
        return NettyChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
    }

    private Method getStubMethod(Object grpcStub, String bareMethodName) {
        String realMethodName = this.decapitalize(bareMethodName);
        for (Method method : grpcStub.getClass().getDeclaredMethods()) {
            if (!method.getName().equals(realMethodName)) continue;
            return method;
        }
        return null;
    }

    private io.grpc.MethodDescriptor getMethodDescriptor(ServiceDescriptor serviceDescriptor, String methodName) {
        Object methodDescriptor = null;
        for (io.grpc.MethodDescriptor method : serviceDescriptor.getMethods()) {
            if (method.getBareMethodName() == null || !method.getBareMethodName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    private String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private Collection<Class<?>> getGrpcServices(IndexView index) throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HashSet<String> serviceClassNames = new HashSet<String>();
        for (ClassInfo mutinyGrpc : index.getAllKnownImplementors(GrpcDotNames.MUTINY_GRPC)) {
            DotName originalImplName = DotName.createSimple((String)mutinyGrpc.name().toString().replace("Mutiny", ""));
            ClassInfo originalImpl = index.getClassByName(originalImplName);
            if (originalImpl == null) {
                throw new IllegalStateException("The original implementation class of a gRPC service not found:" + originalImplName);
            }
            MethodInfo getServiceDescriptor = originalImpl.method("getServiceDescriptor", new Type[0]);
            if (getServiceDescriptor == null || !Modifier.isStatic(getServiceDescriptor.flags()) || !getServiceDescriptor.returnType().name().toString().equals(ServiceDescriptor.class.getName())) continue;
            serviceClassNames.add(getServiceDescriptor.declaringClass().name().toString());
        }
        ArrayList serviceClasses = new ArrayList();
        for (String className : serviceClassNames) {
            serviceClasses.add(tccl.loadClass(className));
        }
        serviceClasses.add(HealthGrpc.class);
        return serviceClasses;
    }

    static final class GrpcServiceClassInfo {
        public ServiceDescriptor serviceDescriptor;
        public Class<?> grpcServiceClass;

        public GrpcServiceClassInfo(ServiceDescriptor serviceDescriptor, Class<?> grpcServiceClass) {
            this.serviceDescriptor = serviceDescriptor;
            this.grpcServiceClass = grpcServiceClass;
        }
    }

    private class TestObserver<Object>
    implements StreamObserver<Object> {
        private BroadcastProcessor<String> broadcaster;

        public TestObserver(BroadcastProcessor<String> broadcaster) {
            this.broadcaster = broadcaster;
        }

        public void onNext(Object value) {
            try {
                String body = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)value);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode json = mapper.readTree(body);
                this.broadcaster.onNext((Object)json.toPrettyString());
            }
            catch (JsonProcessingException | InvalidProtocolBufferException e) {
                this.broadcaster.onError(e);
            }
        }

        public void onError(Throwable t) {
            this.broadcaster.onError(t);
        }

        public void onCompleted() {
            this.broadcaster.onComplete();
        }
    }
}

