/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.grpc.Channel;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.InjectionPointTransformerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.grpc.MutinyClient;
import io.quarkus.grpc.RegisterClientInterceptor;
import io.quarkus.grpc.deployment.GrpcClientBuildItem;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.deployment.GrpcInterceptors;
import io.quarkus.grpc.deployment.ResourceRegistrationUtils;
import io.quarkus.grpc.runtime.ClientInterceptorStorage;
import io.quarkus.grpc.runtime.GrpcClientInterceptorContainer;
import io.quarkus.grpc.runtime.GrpcClientRecorder;
import io.quarkus.grpc.runtime.config.GrpcClientBuildTimeConfig;
import io.quarkus.grpc.runtime.stork.GrpcStorkRecorder;
import io.quarkus.grpc.runtime.stork.StorkMeasuringGrpcInterceptor;
import io.quarkus.grpc.runtime.stork.VertxStorkMeasuringGrpcInterceptor;
import io.quarkus.grpc.runtime.supports.Channels;
import io.quarkus.grpc.runtime.supports.GrpcClientConfigProvider;
import io.quarkus.grpc.runtime.supports.IOThreadClientInterceptor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class GrpcClientProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcClientProcessor.class.getName());
    private static final String SSL_PREFIX = "quarkus\\.grpc\\.clients\\..*.ssl\\.";
    private static final Pattern KEY_PATTERN = Pattern.compile("quarkus\\.grpc\\.clients\\..*.ssl\\.key");
    private static final Pattern CERTIFICATE_PATTERN = Pattern.compile("quarkus\\.grpc\\.clients\\..*.ssl\\.certificate");
    private static final Pattern TRUST_STORE_PATTERN = Pattern.compile("quarkus\\.grpc\\.clients\\..*.ssl\\.trust-store");

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcClient.class, RegisterClientInterceptor.class}));
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{GrpcClientConfigProvider.class, GrpcClientInterceptorContainer.class, IOThreadClientInterceptor.class}).build());
    }

    @BuildStep
    void registerStorkInterceptor(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{StorkMeasuringGrpcInterceptor.class}));
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{VertxStorkMeasuringGrpcInterceptor.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setUpStork(GrpcStorkRecorder storkRecorder, GrpcClientBuildTimeConfig config) {
        storkRecorder.init(config.storkProactiveConnections);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @BuildStep
    void discoverInjectedClients(BeanDiscoveryFinishedBuildItem beanDiscovery, BuildProducer<GrpcClientBuildItem> clients, BuildProducer<FeatureBuildItem> features, CombinedIndexBuildItem index) {
        HashMap<String, GrpcClientBuildItem> items = new HashMap<String, GrpcClientBuildItem>();
        HashMap<DotName, DotName> generatedClients = new HashMap<DotName, DotName>();
        for (ClassInfo generatedClient : index.getIndex().getKnownDirectImplementors(GrpcDotNames.MUTINY_CLIENT)) {
            DotName serviceInterface = null;
            for (DotName name : generatedClient.interfaceNames()) {
                if (name.equals((Object)GrpcDotNames.MUTINY_CLIENT)) continue;
                serviceInterface = name;
                break;
            }
            if (serviceInterface == null) {
                throw new IllegalStateException("Unable to derive the service interface for the generated Mutiny client: " + generatedClient);
            }
            generatedClients.put(serviceInterface, generatedClient.name());
        }
        for (InjectionPointInfo injectionPoint : beanDiscovery.getInjectionPoints()) {
            GrpcClientBuildItem item;
            String clientName;
            AnnotationInstance clientAnnotation = injectionPoint.getRequiredQualifier(GrpcDotNames.GRPC_CLIENT);
            if (clientAnnotation == null) continue;
            Set<String> registeredInterceptors = this.getRegisteredInterceptors(injectionPoint);
            AnnotationValue clientNameValue = clientAnnotation.value();
            if (clientNameValue == null || clientNameValue.asString().equals("<<element name>>")) {
                if (clientAnnotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                    clientName = clientAnnotation.target().asField().name();
                } else {
                    if (clientAnnotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) throw new IllegalStateException(clientAnnotation + " may not be declared at " + clientAnnotation.target());
                    MethodParameterInfo param = clientAnnotation.target().asMethodParameter();
                    clientName = param.method().parameterName((int)param.position());
                    if (clientName == null) {
                        throw new DeploymentException("Unable to determine the client name from the parameter at position " + param.position() + " in method " + param.method().declaringClass().name() + "#" + param.method().name() + "() - compile the class with debug info enabled (-g) or parameter names recorded (-parameters), or use GrpcClient#value() to specify the service name");
                    }
                }
            } else {
                clientName = clientNameValue.asString();
            }
            if (clientName.trim().isEmpty()) {
                throw new DeploymentException("Invalid @GrpcClient `" + injectionPoint.getTargetInfo() + "` - client name cannot be empty");
            }
            if (items.containsKey(clientName)) {
                item = (GrpcClientBuildItem)((Object)items.get(clientName));
            } else {
                item = new GrpcClientBuildItem(clientName);
                items.put(clientName, item);
            }
            Type injectionType = injectionPoint.getRequiredType();
            if (injectionType.name().equals((Object)GrpcDotNames.CHANNEL)) {
                item.addClient(new GrpcClientBuildItem.ClientInfo(GrpcDotNames.CHANNEL, GrpcClientBuildItem.ClientType.CHANNEL, registeredInterceptors));
                continue;
            }
            Set<DotName> rawTypes = GrpcClientProcessor.getRawTypeClosure(index.getComputingIndex().getClassByName(injectionType.name()), index.getComputingIndex());
            if (rawTypes.contains(GrpcDotNames.ABSTRACT_BLOCKING_STUB)) {
                item.addClient(new GrpcClientBuildItem.ClientInfo(injectionType.name(), GrpcClientBuildItem.ClientType.BLOCKING_STUB, registeredInterceptors), true);
                continue;
            }
            if (rawTypes.contains(GrpcDotNames.MUTINY_STUB)) {
                item.addClient(new GrpcClientBuildItem.ClientInfo(injectionType.name(), GrpcClientBuildItem.ClientType.MUTINY_STUB, registeredInterceptors), true);
                continue;
            }
            if (!rawTypes.contains(GrpcDotNames.MUTINY_SERVICE)) throw this.invalidInjectionPoint(injectionPoint);
            DotName generatedClient = (DotName)generatedClients.get(injectionType.name());
            if (generatedClient == null) {
                throw this.invalidInjectionPoint(injectionPoint);
            }
            item.addClient(new GrpcClientBuildItem.ClientInfo(injectionType.name(), GrpcClientBuildItem.ClientType.MUTINY_CLIENT, generatedClient, registeredInterceptors), true);
        }
        if (items.isEmpty()) return;
        for (GrpcClientBuildItem item : items.values()) {
            clients.produce((BuildItem)item);
            LOGGER.debugf("Detected client associated with the '%s' configuration prefix", (Object)item.getClientName());
        }
        features.produce((BuildItem)new FeatureBuildItem(Feature.GRPC_CLIENT));
    }

    @BuildStep
    public void generateGrpcClientProducers(List<GrpcClientBuildItem> clients, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        for (final GrpcClientBuildItem client : clients) {
            for (final GrpcClientBuildItem.ClientInfo clientInfo : client.getClients()) {
                if (clientInfo.type == GrpcClientBuildItem.ClientType.CHANNEL) {
                    SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)GrpcDotNames.CHANNEL).addQualifier().annotation(GrpcDotNames.GRPC_CLIENT).addValue("value", (Object)client.getClientName()).done()).scope(Singleton.class)).unremovable()).forceApplicationClass()).creator((Consumer)new Consumer<MethodCreator>(){

                        @Override
                        public void accept(MethodCreator mc) {
                            GrpcClientProcessor.this.generateChannelProducer(mc, client.getClientName(), clientInfo);
                        }
                    })).destroyer(Channels.ChannelDestroyer.class);
                    if (!clientInfo.interceptors.isEmpty()) {
                        for (String interceptorClass : clientInfo.interceptors) {
                            configurator.addQualifier(AnnotationInstance.create((DotName)GrpcDotNames.REGISTER_CLIENT_INTERCEPTOR, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)DotName.createSimple((String)interceptorClass), (Type.Kind)Type.Kind.CLASS))}));
                        }
                    }
                    syntheticBeans.produce((BuildItem)configurator.done());
                    continue;
                }
                final String clientName = client.getClientName();
                SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)clientInfo.className).addQualifier().annotation(GrpcDotNames.GRPC_CLIENT).addValue("value", (Object)clientName).done()).scope(clientInfo.type == GrpcClientBuildItem.ClientType.MUTINY_CLIENT ? ApplicationScoped.class : Singleton.class)).unremovable()).forceApplicationClass()).addType(MutinyClient.class)).creator((Consumer)new Consumer<MethodCreator>(){

                    @Override
                    public void accept(MethodCreator mc) {
                        GrpcClientProcessor.this.generateClientProducer(mc, clientName, clientInfo);
                    }
                });
                if (!clientInfo.interceptors.isEmpty()) {
                    for (String interceptorClass : clientInfo.interceptors) {
                        configurator.addQualifier(AnnotationInstance.create((DotName)GrpcDotNames.REGISTER_CLIENT_INTERCEPTOR, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)DotName.createSimple((String)interceptorClass), (Type.Kind)Type.Kind.CLASS))}));
                    }
                }
                syntheticBeans.produce((BuildItem)configurator.done());
            }
        }
    }

    @BuildStep
    void registerSslResources(BuildProducer<NativeImageResourceBuildItem> resourceBuildItem) {
        Config config = ConfigProvider.getConfig();
        ResourceRegistrationUtils.registerResourcesForProperties(config, resourceBuildItem, TRUST_STORE_PATTERN, CERTIFICATE_PATTERN, KEY_PATTERN);
    }

    @BuildStep
    void runtimeInitialize(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.grpc.internal.RetriableStream"));
    }

    @BuildStep
    public void validateInjectedServiceInterfaces(CombinedIndexBuildItem index, BuildProducer<UnremovableBeanBuildItem> dummy) {
        HashSet<DotName> serviceInterfaces = new HashSet<DotName>();
        for (ClassInfo serviceInterface : index.getIndex().getKnownDirectImplementors(GrpcDotNames.MUTINY_SERVICE)) {
            serviceInterfaces.add(serviceInterface.name());
        }
        for (AnnotationInstance injectAnnotation : index.getIndex().getAnnotations(DotNames.INJECT)) {
            if (injectAnnotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                FieldInfo field = injectAnnotation.target().asField();
                if (!serviceInterfaces.contains(field.type().name()) || field.annotations().size() != 1) continue;
                throw new IllegalStateException("A gRPC service injection is missing the @GrpcClient qualifier: " + field.declaringClass().name() + "#" + field.name());
            }
            if (injectAnnotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo method = injectAnnotation.target().asMethod();
            short position = 0;
            for (Type param : method.parameterTypes()) {
                position = (short)(position + 1);
                if (!serviceInterfaces.contains(param.name())) continue;
                HashSet<AnnotationInstance> annotations = new HashSet<AnnotationInstance>();
                for (AnnotationInstance annotation : method.annotations()) {
                    if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != position) continue;
                    annotations.add(annotation);
                }
                if (annotations.size() <= 1) continue;
                throw new IllegalStateException("A gRPC service injection is missing the @GrpcClient qualifier: " + method.declaringClass().name() + "#" + method.name() + "()");
            }
        }
    }

    @BuildStep
    InjectionPointTransformerBuildItem transformInjectionPoints() {
        return new InjectionPointTransformerBuildItem(new InjectionPointsTransformer(){

            public void transform(InjectionPointsTransformer.TransformationContext ctx) {
                AnnotationInstance clientAnnotation = Annotations.find((Collection)ctx.getQualifiers(), (DotName)GrpcDotNames.GRPC_CLIENT);
                if (clientAnnotation != null && clientAnnotation.value() == null) {
                    String clientName = null;
                    AnnotationTarget annotationTarget = ctx.getAnnotationTarget();
                    if (ctx.getAnnotationTarget().kind() == AnnotationTarget.Kind.FIELD) {
                        clientName = clientAnnotation.target().asField().name();
                    } else if (annotationTarget.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                        MethodParameterInfo param = clientAnnotation.target().asMethodParameter();
                        clientName = param.method().parameterName((int)param.position());
                    }
                    if (clientName != null) {
                        ((InjectionPointsTransformer.Transformation)((InjectionPointsTransformer.Transformation)ctx.transform().remove(GrpcDotNames::isGrpcClient)).add(AnnotationInstance.builder((DotName)GrpcDotNames.GRPC_CLIENT).value(clientName).build())).done();
                    }
                }
            }

            public boolean appliesTo(Type requiredType) {
                return true;
            }
        });
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    SyntheticBeanBuildItem clientInterceptorStorage(GrpcClientRecorder recorder, RecorderContext recorderContext, BeanArchiveIndexBuildItem beanArchiveIndex) {
        IndexView index = beanArchiveIndex.getIndex();
        GrpcInterceptors interceptors = GrpcInterceptors.gatherInterceptors(index, GrpcDotNames.CLIENT_INTERCEPTOR);
        HashSet<String> superfluousInterceptors = new HashSet<String>(interceptors.nonGlobalInterceptors);
        for (String string : GrpcInterceptors.MICROMETER_INTERCEPTORS) {
            superfluousInterceptors.remove(string);
        }
        ArrayList<AnnotationInstance> found = new ArrayList<AnnotationInstance>(index.getAnnotations(GrpcDotNames.REGISTER_CLIENT_INTERCEPTOR));
        for (AnnotationInstance annotationInstance : index.getAnnotations(GrpcDotNames.REGISTER_CLIENT_INTERCEPTOR_LIST)) {
            for (AnnotationInstance nested : annotationInstance.value().asNestedArray()) {
                found.add(AnnotationInstance.create((DotName)nested.name(), (AnnotationTarget)annotationInstance.target(), (List)nested.values()));
            }
        }
        for (AnnotationInstance annotationInstance : found) {
            String interceptorClassName = annotationInstance.value().asString();
            superfluousInterceptors.remove(interceptorClassName);
        }
        HashSet<Class> hashSet = new HashSet<Class>();
        for (String perClientInterceptor : interceptors.nonGlobalInterceptors) {
            hashSet.add(recorderContext.classProxy(perClientInterceptor));
        }
        HashSet<Class> hashSet2 = new HashSet<Class>();
        for (String globalInterceptor : interceptors.globalInterceptors) {
            hashSet2.add(recorderContext.classProxy(globalInterceptor));
        }
        superfluousInterceptors.remove(StorkMeasuringGrpcInterceptor.class.getName());
        superfluousInterceptors.remove(VertxStorkMeasuringGrpcInterceptor.class.getName());
        if (!superfluousInterceptors.isEmpty()) {
            LOGGER.warnf("At least one unused gRPC client interceptor found: %s. If there are meant to be used globally, annotate them with @GlobalInterceptor.", (Object)String.join((CharSequence)", ", superfluousInterceptors));
        }
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ClientInterceptorStorage.class).unremovable()).runtimeValue(recorder.initClientInterceptorStorage(hashSet, hashSet2)).setRuntimeInit().done();
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableClientInterceptors() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{GrpcDotNames.CLIENT_INTERCEPTOR});
    }

    Set<String> getRegisteredInterceptors(InjectionPointInfo injectionPoint) {
        Set qualifiers = injectionPoint.getRequiredQualifiers();
        if (qualifiers.size() <= 1) {
            return Collections.emptySet();
        }
        HashSet<String> interceptors = new HashSet<String>();
        for (AnnotationInstance qualifier : qualifiers) {
            if (!qualifier.name().equals((Object)GrpcDotNames.REGISTER_CLIENT_INTERCEPTOR)) continue;
            interceptors.add(qualifier.value().asClass().name().toString());
        }
        return interceptors;
    }

    private DeploymentException invalidInjectionPoint(InjectionPointInfo injectionPoint) {
        return new DeploymentException(injectionPoint.getRequiredType() + " cannot be injected into " + injectionPoint.getTargetInfo() + " - only Mutiny service interfaces, blocking stubs, reactive stubs based on Mutiny and io.grpc.Channel can be injected via @GrpcClient");
    }

    private void generateChannelProducer(MethodCreator mc, String clientName, GrpcClientBuildItem.ClientInfo client) {
        ResultHandle name = mc.load(clientName);
        ResultHandle interceptorsArray = mc.newArray(String.class, client.interceptors.size());
        int idx = 0;
        for (String interceptor : client.interceptors) {
            mc.writeArrayValue(interceptorsArray, idx++, mc.load(interceptor));
        }
        ResultHandle interceptorsSet = mc.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Set.class, (String)"of", Set.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{interceptorsArray});
        ResultHandle result = mc.invokeStaticMethod(GrpcDotNames.CREATE_CHANNEL_METHOD, new ResultHandle[]{name, interceptorsSet});
        mc.returnValue(result);
        mc.close();
    }

    private static Set<DotName> getRawTypeClosure(ClassInfo classInfo, IndexView index) {
        HashSet<DotName> types = new HashSet<DotName>();
        types.add(classInfo.name());
        for (DotName name : classInfo.interfaceNames()) {
            ClassInfo interfaceClassInfo = index.getClassByName(name);
            if (interfaceClassInfo != null) {
                types.addAll(GrpcClientProcessor.getRawTypeClosure(interfaceClassInfo, index));
                continue;
            }
            types.add(name);
        }
        DotName superName = classInfo.superName();
        if (superName != null && !DotNames.OBJECT.equals((Object)superName)) {
            ClassInfo superClassInfo = index.getClassByName(superName);
            if (superClassInfo != null) {
                types.addAll(GrpcClientProcessor.getRawTypeClosure(superClassInfo, index));
            } else {
                types.add(superName);
            }
        }
        return types;
    }

    private void generateClientProducer(MethodCreator mc, String clientName, GrpcClientBuildItem.ClientInfo clientInfo) {
        ResultHandle client;
        ResultHandle name = mc.load(clientName);
        ResultHandle interceptorsArray = mc.newArray(String.class, clientInfo.interceptors.size());
        int idx = 0;
        for (String interceptor : clientInfo.interceptors) {
            mc.writeArrayValue(interceptorsArray, idx++, mc.load(interceptor));
        }
        ResultHandle interceptorsSet = mc.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Set.class, (String)"of", Set.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{interceptorsArray});
        ResultHandle channel = mc.invokeStaticMethod(GrpcDotNames.RETRIEVE_CHANNEL_METHOD, new ResultHandle[]{name, interceptorsSet});
        if (clientInfo.type == GrpcClientBuildItem.ClientType.MUTINY_CLIENT) {
            ResultHandle stubConfigurator = mc.invokeStaticMethod(GrpcDotNames.GET_STUB_CONFIGURATOR, new ResultHandle[0]);
            client = mc.newInstance(MethodDescriptor.ofConstructor((Object)clientInfo.implName.toString(), (Object[])new Object[]{String.class.getName(), Channel.class.getName(), BiFunction.class}), new ResultHandle[]{name, channel, stubConfigurator});
        } else {
            MethodDescriptor factoryMethod = MethodDescriptor.ofMethod((String)this.convertToServiceName(clientInfo.className), (String)clientInfo.type.getFactoryMethodName(), (String)clientInfo.className.toString(), (String[])new String[]{Channel.class.getName()});
            client = mc.invokeStaticMethod(factoryMethod, new ResultHandle[]{channel});
            client = mc.invokeStaticMethod(GrpcDotNames.CONFIGURE_STUB, new ResultHandle[]{name, client});
            if (clientInfo.type.isBlocking()) {
                client = mc.invokeStaticMethod(GrpcDotNames.ADD_BLOCKING_CLIENT_INTERCEPTOR, new ResultHandle[]{client});
            }
        }
        mc.returnValue(client);
        mc.close();
    }

    private String convertToServiceName(DotName stubName) {
        if (stubName.isInner()) {
            return stubName.prefix().toString();
        }
        return stubName.toString();
    }
}

