/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.quarkus.grpc.deployment.GrpcDotNames;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

final class GrpcInterceptors {
    static final List<String> MICROMETER_INTERCEPTORS = List.of("io.micrometer.core.instrument.binder.grpc.MetricCollectingClientInterceptor", "io.micrometer.core.instrument.binder.grpc.MetricCollectingServerInterceptor");
    final Set<String> globalInterceptors;
    final Set<String> nonGlobalInterceptors;

    GrpcInterceptors(Set<String> globalInterceptors, Set<String> nonGlobalInterceptors) {
        this.globalInterceptors = globalInterceptors;
        this.nonGlobalInterceptors = nonGlobalInterceptors;
    }

    static GrpcInterceptors gatherInterceptors(IndexView index, DotName interceptorInterface) {
        Set<DotName> allGlobalInterceptors = GrpcInterceptors.allGlobalInterceptors(index, interceptorInterface);
        HashSet<String> globalInterceptors = new HashSet<String>();
        HashSet<String> nonGlobalInterceptors = new HashSet<String>();
        Collection interceptorImplClasses = index.getAllKnownImplementors(interceptorInterface);
        for (ClassInfo interceptorImplClass : interceptorImplClasses) {
            if (Modifier.isAbstract(interceptorImplClass.flags()) || Modifier.isInterface(interceptorImplClass.flags())) continue;
            if (allGlobalInterceptors.contains(interceptorImplClass.name())) {
                globalInterceptors.add(interceptorImplClass.name().toString());
                continue;
            }
            nonGlobalInterceptors.add(interceptorImplClass.name().toString());
        }
        return new GrpcInterceptors(globalInterceptors, nonGlobalInterceptors);
    }

    private static Set<DotName> allGlobalInterceptors(IndexView index, DotName interceptorInterface) {
        HashSet<DotName> result = new HashSet<DotName>();
        for (AnnotationInstance instance : index.getAnnotations(GrpcDotNames.GLOBAL_INTERCEPTOR)) {
            DotName className = GrpcInterceptors.className(instance.target());
            if (!GrpcInterceptors.isAssignableFrom(index, className, interceptorInterface)) continue;
            result.add(className);
        }
        return result;
    }

    private static DotName className(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            return target.asClass().name();
        }
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return target.asMethod().returnType().name();
        }
        return null;
    }

    private static boolean isAssignableFrom(IndexView index, DotName className, DotName interceptorInterface) {
        if (className == null) {
            return false;
        }
        ClassInfo classInfo = index.getClassByName(className);
        List interfaceNames = classInfo.interfaceNames();
        for (DotName in : interfaceNames) {
            if (in.equals((Object)interceptorInterface)) {
                return true;
            }
            boolean result = GrpcInterceptors.isAssignableFrom(index, in, interceptorInterface);
            if (!result) continue;
            return true;
        }
        return GrpcInterceptors.isAssignableFrom(index, classInfo.superName(), interceptorInterface);
    }
}

