/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.embedded.runtime;

import io.quarkus.infinispan.embedded.runtime.InfinispanEmbeddedRuntimeConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;

@ApplicationScoped
public class InfinispanEmbeddedProducer {
    private volatile InfinispanEmbeddedRuntimeConfig config;

    public void setRuntimeConfig(InfinispanEmbeddedRuntimeConfig config) {
        this.config = config;
    }

    @Singleton
    @Produces
    EmbeddedCacheManager manager() {
        if (this.config.xmlConfig.isPresent()) {
            String configurationFile = this.config.xmlConfig.get();
            try {
                InputStream configurationStream = FileLookupFactory.newInstance().lookupFileStrict(configurationFile, Thread.currentThread().getContextClassLoader());
                ConfigurationBuilderHolder configHolder = new ParserRegistry().parse(configurationStream, null);
                this.verifyTransactionConfiguration(configHolder.getDefaultConfigurationBuilder(), "default");
                for (Map.Entry entry : configHolder.getNamedConfigurationBuilders().entrySet()) {
                    this.verifyTransactionConfiguration((ConfigurationBuilder)entry.getValue(), (String)entry.getKey());
                }
                return new DefaultCacheManager(configHolder, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new DefaultCacheManager();
    }

    private void verifyTransactionConfiguration(ConfigurationBuilder configurationBuilder, String cacheName) {
        TransactionConfigurationBuilder transactionConfigurationBuilder = configurationBuilder.transaction();
        if (transactionConfigurationBuilder.transactionMode() != null && transactionConfigurationBuilder.transactionMode().isTransactional()) {
            AttributeSet attributes = transactionConfigurationBuilder.attributes();
            Attribute managerLookup = attributes.attribute(TransactionConfiguration.TRANSACTION_MANAGER_LOOKUP);
            if (managerLookup.isModified() && !(managerLookup.get() instanceof JBossStandaloneJTAManagerLookup)) {
                throw new CacheConfigurationException("Only JBossStandaloneJTAManagerLookup transaction manager lookup is supported. Cache " + cacheName + " is misconfigured!");
            }
            managerLookup.set((Object)new JBossStandaloneJTAManagerLookup());
        }
    }
}

