/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.metrics.NoopMetricsFactory;
import io.jaegertracing.spi.MetricsFactory;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.quarkus.jaeger.runtime.JaegerConfig;
import io.quarkus.jaeger.runtime.QuarkusJaegerMicrometerFactory;
import io.quarkus.jaeger.runtime.QuarkusJaegerMpMetricsFactory;
import io.quarkus.jaeger.runtime.QuarkusJaegerTracer;
import io.quarkus.jaeger.runtime.ZipkinConfig;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import org.jboss.logging.Logger;

@Recorder
public class JaegerDeploymentRecorder {
    private static final Logger log = Logger.getLogger(JaegerDeploymentRecorder.class);
    private static final Optional<String> UNKNOWN_SERVICE_NAME = Optional.of("quarkus/unknown");
    private static final QuarkusJaegerTracer quarkusTracer = new QuarkusJaegerTracer();
    public static String jaegerVersion;

    public void setJaegerVersion(String version) {
        jaegerVersion = version;
    }

    public void registerTracerWithoutMetrics(JaegerConfig jaeger, ApplicationConfig appConfig, ZipkinConfig zipkinConfig) {
        this.registerTracer(jaeger, appConfig, (MetricsFactory)new NoopMetricsFactory(), zipkinConfig);
    }

    public void registerTracerWithMpMetrics(JaegerConfig jaeger, ApplicationConfig appConfig, ZipkinConfig zipkinConfig) {
        this.registerTracer(jaeger, appConfig, new QuarkusJaegerMpMetricsFactory(), zipkinConfig);
    }

    public void registerTracerWithMicrometerMetrics(JaegerConfig jaeger, ApplicationConfig appConfig, ZipkinConfig zipkinConfig) {
        this.registerTracer(jaeger, appConfig, new QuarkusJaegerMicrometerFactory(), zipkinConfig);
    }

    private synchronized void registerTracer(JaegerConfig jaeger, ApplicationConfig appConfig, MetricsFactory metricsFactory, ZipkinConfig zipkinConfig) {
        if (!jaeger.serviceName.isPresent()) {
            jaeger.serviceName = appConfig.name.isPresent() ? appConfig.name : UNKNOWN_SERVICE_NAME;
        }
        this.initTracerConfig(jaeger, zipkinConfig);
        quarkusTracer.setMetricsFactory(metricsFactory);
        quarkusTracer.reset();
        if (!GlobalTracer.isRegistered() && !jaeger.disableTracerRegistration.booleanValue()) {
            log.debugf("Registering tracer to GlobalTracer %s", (Object)quarkusTracer);
            GlobalTracer.register((Tracer)quarkusTracer);
        }
    }

    private void initTracerConfig(JaegerConfig jaeger, ZipkinConfig zipkinConfig) {
        this.initTracerProperty("JAEGER_ENDPOINT", jaeger.endpoint, (T uri) -> uri.toString());
        if (jaeger.endpoint.isPresent()) {
            quarkusTracer.setEndpoint(jaeger.endpoint.get().toString());
        }
        this.initTracerProperty("JAEGER_AUTH_TOKEN", jaeger.authToken, (T token) -> token);
        this.initTracerProperty("JAEGER_USER", jaeger.user, (T user) -> user);
        this.initTracerProperty("JAEGER_PASSWORD", jaeger.password, (T pw) -> pw);
        this.initTracerProperty("JAEGER_AGENT_HOST", jaeger.agentHostPort, (T address) -> address.getHostString());
        this.initTracerProperty("JAEGER_AGENT_PORT", jaeger.agentHostPort, (T address) -> String.valueOf(address.getPort()));
        this.initTracerProperty("JAEGER_REPORTER_LOG_SPANS", jaeger.reporterLogSpans, (T log) -> log.toString());
        this.initTracerProperty("JAEGER_REPORTER_MAX_QUEUE_SIZE", jaeger.reporterMaxQueueSize, (Integer size) -> size.toString());
        this.initTracerProperty("JAEGER_REPORTER_FLUSH_INTERVAL", jaeger.reporterFlushInterval, (T duration) -> String.valueOf(duration.toMillis()));
        this.initTracerProperty("JAEGER_SAMPLER_TYPE", jaeger.samplerType, (T type) -> type);
        this.initTracerProperty("JAEGER_SAMPLER_PARAM", jaeger.samplerParam, (T param) -> NumberFormat.getInstance().format(param));
        this.initTracerProperty("JAEGER_SAMPLER_MANAGER_HOST_PORT", jaeger.samplerManagerHostPort, (T hostPort) -> String.format("%s:%d", hostPort.getHostString(), hostPort.getPort()));
        this.initTracerProperty("JAEGER_SERVICE_NAME", jaeger.serviceName, (T name) -> name);
        this.initTracerProperty("JAEGER_TAGS", jaeger.tags, (T tags) -> tags.toString());
        this.initTracerProperty("JAEGER_PROPAGATION", jaeger.propagation, (T format) -> format.toString());
        this.initTracerProperty("JAEGER_SENDER_FACTORY", jaeger.senderFactory, (T sender) -> sender);
        quarkusTracer.setLogTraceContext(jaeger.logTraceContext);
        quarkusTracer.setZipkinCompatibilityMode(zipkinConfig.compatibilityMode);
    }

    private <T> void initTracerProperty(String property, Optional<T> value, Function<T, String> accessor) {
        if (value.isPresent()) {
            System.setProperty(property, accessor.apply(value.get()));
        }
    }

    private void initTracerProperty(String property, OptionalInt value, Function<Integer, String> accessor) {
        if (value.isPresent()) {
            System.setProperty(property, accessor.apply(value.getAsInt()));
        }
    }

    public static Class<?> getClassForName(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        log.debugf("getClass: TCCL: %s ## %s : %s", (Object)Thread.currentThread().getContextClassLoader(), (Object)className, (Object)(clazz != null ? 1 : 0));
        return clazz;
    }
}

