/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.All;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.test.InjectMock;
import io.quarkus.test.component.ConfigBeanCreator;
import io.quarkus.test.component.ConfigPropertyBeanCreator;
import io.quarkus.test.component.MockBeanConfigurator;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.MockBeanCreator;
import io.quarkus.test.component.QuarkusComponentTest;
import io.quarkus.test.component.QuarkusComponentTestClassLoader;
import io.quarkus.test.component.TestConfigProperty;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;

@Experimental(value="This feature is experimental and the API may change in the future")
public class QuarkusComponentTestExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor,
TestInstancePreDestroyCallback,
ConfigSource {
    private static final Logger LOG = Logger.getLogger(QuarkusComponentTestExtension.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{QuarkusComponentTestExtension.class});
    private static final String KEY_OLD_TCCL = "oldTccl";
    private static final String KEY_OLD_CONFIG_PROVIDER_RESOLVER = "oldConfigProviderResolver";
    private static final String KEY_GENERATED_RESOURCES = "generatedResources";
    private static final String KEY_INJECTED_FIELDS = "injectedFields";
    private static final String KEY_CONFIG = "config";
    private static final String TARGET_TEST_CLASSES = "target/test-classes";
    private final Map<String, String> configProperties;
    private final List<Class<?>> additionalComponentClasses;
    private final List<MockBeanConfiguratorImpl<?>> mockConfigurators;
    private final AtomicBoolean useDefaultConfigProperties = new AtomicBoolean();
    private final AtomicBoolean addNestedClassesAsComponents = new AtomicBoolean(true);

    public QuarkusComponentTestExtension() {
        this.additionalComponentClasses = List.of();
        this.configProperties = new HashMap<String, String>();
        this.mockConfigurators = new ArrayList();
    }

    public QuarkusComponentTestExtension(Class<?> ... additionalComponentClasses) {
        this.additionalComponentClasses = List.of(additionalComponentClasses);
        this.configProperties = new HashMap<String, String>();
        this.mockConfigurators = new ArrayList();
    }

    public <T> MockBeanConfigurator<T> mock(Class<T> beanClass) {
        return new MockBeanConfiguratorImpl(this, beanClass);
    }

    public QuarkusComponentTestExtension configProperty(String key, String value) {
        this.configProperties.put(key, value);
        return this;
    }

    public QuarkusComponentTestExtension useDefaultConfigProperties() {
        this.useDefaultConfigProperties.set(true);
        return this;
    }

    public QuarkusComponentTestExtension ignoreNestedClasses() {
        this.addNestedClassesAsComponents.set(false);
        return this;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        context.getRoot().getStore(NAMESPACE).put((Object)KEY_INJECTED_FIELDS, this.injectFields(context.getRequiredTestClass(), testInstance));
        LOG.debugf("postProcessTestInstance: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void preDestroyTestInstance(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        for (FieldInjector fieldInjector : (List)context.getRoot().getStore(NAMESPACE).get((Object)KEY_INJECTED_FIELDS, List.class)) {
            fieldInjector.unset(context.getRequiredTestInstance());
        }
        LOG.debugf("preDestroyTestInstance: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    /*
     * WARNING - void declaration
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        void var11_16;
        TestConfigProperty[] testConfigProperties;
        long start = System.nanoTime();
        Class testClass = context.getRequiredTestClass();
        HashSet componentClasses = new HashSet(this.additionalComponentClasses);
        QuarkusComponentTest testAnnotation = testClass.getAnnotation(QuarkusComponentTest.class);
        if (testAnnotation != null) {
            Collections.addAll(componentClasses, testAnnotation.value());
            if (testAnnotation.useDefaultConfigProperties()) {
                this.useDefaultConfigProperties.set(true);
            }
            this.addNestedClassesAsComponents.set(testAnnotation.addNestedClassesAsComponents());
        }
        for (Class current = testClass; current != null; current = current.getSuperclass()) {
            for (AnnotatedElement annotatedElement : current.getDeclaredFields()) {
                if (!((AccessibleObject)annotatedElement).isAnnotationPresent(Inject.class) || this.resolvesToBuiltinBean(((Field)annotatedElement).getType())) continue;
                componentClasses.add(((Field)annotatedElement).getType());
            }
        }
        if (this.addNestedClassesAsComponents.get()) {
            for (AnnotatedElement annotatedElement : testClass.getDeclaredClasses()) {
                if (!Modifier.isStatic(((Class)annotatedElement).getModifiers())) continue;
                componentClasses.add((Class<?>)annotatedElement);
            }
        }
        TestConfigProperty[] testConfigPropertyArray = testConfigProperties = (TestConfigProperty[])testClass.getAnnotationsByType(TestConfigProperty.class);
        int n = testConfigPropertyArray.length;
        boolean bl = false;
        while (var11_16 < n) {
            TestConfigProperty testConfigProperty = testConfigPropertyArray[var11_16];
            this.configProperties.put(testConfigProperty.key(), testConfigProperty.value());
            ++var11_16;
        }
        ClassLoader oldTccl = this.initArcContainer(context, componentClasses);
        context.getRoot().getStore(NAMESPACE).put((Object)KEY_OLD_TCCL, (Object)oldTccl);
        ConfigProviderResolver oldConfigProviderResolver = ConfigProviderResolver.instance();
        context.getRoot().getStore(NAMESPACE).put((Object)KEY_OLD_CONFIG_PROVIDER_RESOLVER, (Object)oldConfigProviderResolver);
        SmallRyeConfigProviderResolver smallRyeConfigProviderResolver = new SmallRyeConfigProviderResolver();
        ConfigProviderResolver.setInstance((ConfigProviderResolver)smallRyeConfigProviderResolver);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        SmallRyeConfig config = new SmallRyeConfigBuilder().forClassLoader(tccl).addDefaultInterceptors().addDefaultSources().withSources((ConfigSourceProvider)new ApplicationPropertiesConfigSourceLoader.InFileSystem()).withSources((ConfigSourceProvider)new ApplicationPropertiesConfigSourceLoader.InClassPath()).withSources(new ConfigSource[]{this}).build();
        smallRyeConfigProviderResolver.registerConfig((Config)config, tccl);
        context.getRoot().getStore(NAMESPACE).put((Object)KEY_CONFIG, (Object)config);
        ConfigBeanCreator.setClassLoader(tccl);
        LOG.debugf("beforeAll: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        ClassLoader oldTccl = (ClassLoader)context.getRoot().getStore(NAMESPACE).get((Object)KEY_OLD_TCCL, ClassLoader.class);
        Thread.currentThread().setContextClassLoader(oldTccl);
        try {
            Arc.shutdown();
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured during ArC shutdown: " + e));
        }
        MockBeanCreator.clear();
        ConfigBeanCreator.clear();
        SmallRyeConfig config = (SmallRyeConfig)context.getRoot().getStore(NAMESPACE).get((Object)KEY_CONFIG, SmallRyeConfig.class);
        ConfigProviderResolver.instance().releaseConfig((Config)config);
        ConfigProviderResolver.setInstance((ConfigProviderResolver)((ConfigProviderResolver)context.getRoot().getStore(NAMESPACE).get((Object)KEY_OLD_CONFIG_PROVIDER_RESOLVER, ConfigProviderResolver.class)));
        Set generatedResources = (Set)context.getRoot().getStore(NAMESPACE).get((Object)KEY_GENERATED_RESOURCES, Set.class);
        for (Path path : generatedResources) {
            try {
                LOG.debugf("Delete generated %s", (Object)path);
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                LOG.errorf("Unable to delete the generated resource %s: ", (Object)path, (Object)e.getMessage());
            }
        }
        LOG.debugf("afterAll: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        ArcContainer container = Arc.container();
        container.requestContext().activate();
        LOG.debugf("beforeEach: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        ArcContainer container = Arc.container();
        container.requestContext().terminate();
        LOG.debugf("afterEach: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public Set<String> getPropertyNames() {
        return this.configProperties.keySet();
    }

    public String getValue(String propertyName) {
        return this.configProperties.get(propertyName);
    }

    public String getName() {
        return QuarkusComponentTestExtension.class.getName();
    }

    public int getOrdinal() {
        return 275;
    }

    void registerMockBean(MockBeanConfiguratorImpl<?> mock) {
        this.mockConfigurators.add(mock);
    }

    private BeanRegistrar registrarForMock(final MockBeanConfiguratorImpl<?> mock) {
        return new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext context) {
                BeanConfigurator configurator = context.configure(mock.beanClass);
                configurator.scope(mock.scope);
                mock.jandexTypes().forEach(arg_0 -> ((BeanConfigurator)configurator).addType(arg_0));
                mock.jandexQualifiers().forEach(arg_0 -> ((BeanConfigurator)configurator).addQualifier(arg_0));
                if (mock.name != null) {
                    configurator.name(mock.name);
                }
                configurator.alternative(mock.alternative);
                if (mock.priority != null) {
                    configurator.priority(mock.priority.intValue());
                }
                if (mock.defaultBean) {
                    configurator.defaultBean();
                }
                String key = UUID.randomUUID().toString();
                MockBeanCreator.registerCreate(key, (Function)QuarkusComponentTestExtension.cast(mock.create));
                ((BeanConfigurator)((BeanConfigurator)configurator.creator(MockBeanCreator.class)).param("createKey", key)).done();
            }
        };
    }

    private static Annotation[] getQualifiers(Field field, BeanManager beanManager) {
        Annotation[] annotations;
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        for (Annotation fieldAnnotation : annotations = field.getDeclaredAnnotations()) {
            if (!beanManager.isQualifier(fieldAnnotation.annotationType())) continue;
            ret.add(fieldAnnotation);
        }
        return ret.toArray(new Annotation[0]);
    }

    private static Set<AnnotationInstance> getQualifiers(Field field, Collection<DotName> qualifiers) {
        Annotation[] fieldAnnotations;
        HashSet<AnnotationInstance> ret = new HashSet<AnnotationInstance>();
        for (Annotation annotation : fieldAnnotations = field.getDeclaredAnnotations()) {
            if (!qualifiers.contains(DotName.createSimple(annotation.annotationType()))) continue;
            ret.add(Annotations.jandexAnnotation((Annotation)annotation));
        }
        return ret;
    }

    private ClassLoader initArcContainer(ExtensionContext context, Collection<Class<?>> componentClasses) {
        IndexView index;
        final Class testClass = context.getRequiredTestClass();
        ArrayList<Field> testClassInjectionPoints = new ArrayList<Field>();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            testClassInjectionPoints.add(field);
        }
        if (componentClasses.isEmpty()) {
            throw new IllegalStateException("No component classes to test");
        }
        try {
            Arc.shutdown();
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occured during ArC shutdown: " + e);
        }
        try {
            Indexer indexer = new Indexer();
            for (Class<?> componentClass : componentClasses) {
                this.indexComponentClass(indexer, componentClass);
            }
            indexer.indexClass(ConfigProperty.class);
            index = BeanArchives.buildImmutableBeanArchiveIndex((IndexView[])new IndexView[]{indexer.complete()});
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create index", e);
        }
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        final IndexView computingIndex = BeanArchives.buildComputingBeanArchiveIndex((ClassLoader)oldTccl, new ConcurrentHashMap(), (IndexView)index);
        try {
            ArrayList qualifiers = new ArrayList();
            AtomicReference<BeanResolver> beanResolver = new AtomicReference<BeanResolver>();
            BeanProcessor.Builder builder = BeanProcessor.builder().setName(testClass.getName().replace('.', '_')).addRemovalExclusion(b -> {
                if (b.getTarget().isPresent() && ((AnnotationTarget)b.getTarget().get()).hasDeclaredAnnotation(Unremovable.class)) {
                    return true;
                }
                for (Field injectionPoint : testClassInjectionPoints) {
                    if (!((BeanResolver)beanResolver.get()).matches(b, Types.jandexType((Type)injectionPoint.getGenericType()), QuarkusComponentTestExtension.getQualifiers(injectionPoint, qualifiers))) continue;
                    return true;
                }
                return false;
            }).setImmutableBeanArchiveIndex(index).setComputingBeanArchiveIndex(computingIndex).setRemoveUnusedBeans(true);
            final HashSet generatedResources = new HashSet();
            File generatedSourcesDirectory = new File("target/generated-arc-sources");
            final File componentsProviderFile = new File(generatedSourcesDirectory + "/" + this.nameToPath(testClass.getPackage().getName()), ComponentsProvider.class.getSimpleName());
            if (testClass.getClassLoader() instanceof QuarkusClassLoader) {
                final HashMap classes = new HashMap();
                builder.setOutput(new ResourceOutput(){

                    public void writeResource(ResourceOutput.Resource resource) throws IOException {
                        switch (resource.getType()) {
                            case JAVA_CLASS: {
                                classes.put(resource.getName() + ".class", resource.getData());
                                ((QuarkusClassLoader)testClass.getClassLoader()).reset(classes, Map.of());
                                break;
                            }
                            case SERVICE_PROVIDER: {
                                if (!resource.getName().endsWith(ComponentsProvider.class.getName())) break;
                                componentsProviderFile.getParentFile().mkdirs();
                                try (FileOutputStream out = new FileOutputStream(componentsProviderFile);){
                                    out.write(resource.getData());
                                    break;
                                }
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                });
            } else {
                String testPath = testClass.getClassLoader().getResource(testClass.getName().replace(".", "/") + ".class").getFile();
                int n = testPath.indexOf(TARGET_TEST_CLASSES);
                if (n == -1) {
                    throw new IllegalStateException("Invalid test path: " + (String)testPath);
                }
                String testClassesRootPath = testPath.substring(0, n);
                final File testOutputDirectory = new File(testClassesRootPath + TARGET_TEST_CLASSES);
                builder.setOutput(new ResourceOutput(){

                    public void writeResource(ResourceOutput.Resource resource) throws IOException {
                        switch (resource.getType()) {
                            case JAVA_CLASS: {
                                generatedResources.add(resource.writeTo(testOutputDirectory).toPath());
                                break;
                            }
                            case SERVICE_PROVIDER: {
                                if (!resource.getName().endsWith(ComponentsProvider.class.getName())) break;
                                componentsProviderFile.getParentFile().mkdirs();
                                try (FileOutputStream out = new FileOutputStream(componentsProviderFile);){
                                    out.write(resource.getData());
                                    break;
                                }
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                });
            }
            context.getRoot().getStore(NAMESPACE).put((Object)KEY_GENERATED_RESOURCES, generatedResources);
            builder.addAnnotationTransformer(((AnnotationsTransformer.FieldTransformerBuilder)((AnnotationsTransformer.FieldTransformerBuilder)AnnotationsTransformer.appliedToField().whenContainsAny(qualifiers)).whenContainsNone(new DotName[]{DotName.createSimple(Inject.class)})).thenTransform(t -> t.add(Inject.class, new AnnotationValue[0])));
            builder.addBeanRegistrar(new BeanRegistrar(){

                public void register(BeanRegistrar.RegistrationContext context) {
                    long start = System.nanoTime();
                    List beans = context.beans().collect();
                    BeanDeployment beanDeployment = (BeanDeployment)context.get(BuildExtension.Key.DEPLOYMENT);
                    HashSet<InjectionPointInfo.TypeAndQualifiers> unsatisfiedInjectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
                    boolean configInjectionPoint = false;
                    HashSet<InjectionPointInfo.TypeAndQualifiers> configPropertyInjectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
                    DotName configDotName = DotName.createSimple(Config.class);
                    DotName configPropertyDotName = DotName.createSimple(ConfigProperty.class);
                    for (InjectionPointInfo injectionPoint : context.getInjectionPoints()) {
                        BuiltinBean builtin = BuiltinBean.resolve((InjectionPointInfo)injectionPoint);
                        if (builtin != null && builtin != BuiltinBean.INSTANCE && builtin != BuiltinBean.LIST) continue;
                        if (injectionPoint.getRequiredType().name().equals((Object)configDotName) && injectionPoint.hasDefaultedQualifier()) {
                            configInjectionPoint = true;
                            continue;
                        }
                        if (injectionPoint.getRequiredQualifier(configPropertyDotName) != null) {
                            configPropertyInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(injectionPoint.getRequiredType(), injectionPoint.getRequiredQualifiers()));
                            continue;
                        }
                        org.jboss.jandex.Type requiredType = injectionPoint.getRequiredType();
                        HashSet<AnnotationInstance> qualifiers = injectionPoint.getRequiredQualifiers();
                        if (builtin == BuiltinBean.LIST) {
                            requiredType = (org.jboss.jandex.Type)requiredType.asParameterizedType().arguments().get(0);
                            qualifiers = new HashSet<AnnotationInstance>(qualifiers);
                            qualifiers.removeIf(q -> q.name().equals((Object)DotNames.ALL));
                        }
                        if (QuarkusComponentTestExtension.this.isSatisfied(requiredType, (Set<AnnotationInstance>)qualifiers, injectionPoint, beans, beanDeployment)) continue;
                        if (requiredType.kind() == Type.Kind.PRIMITIVE || requiredType.kind() == Type.Kind.ARRAY) {
                            throw new IllegalStateException("Found an unmockable unsatisfied injection point: " + injectionPoint.getTargetInfo());
                        }
                        unsatisfiedInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(requiredType, qualifiers));
                        LOG.debugf("Unsatisfied injection point found: %s", (Object)injectionPoint.getTargetInfo());
                    }
                    for (InjectionPointInfo.TypeAndQualifiers unsatisfied : unsatisfiedInjectionPoints) {
                        ClassInfo implementationClass = computingIndex.getClassByName(unsatisfied.type.name());
                        BeanConfigurator configurator = (BeanConfigurator)((BeanConfigurator)context.configure(implementationClass.name()).scope(Singleton.class)).addType(unsatisfied.type);
                        unsatisfied.qualifiers.forEach(arg_0 -> ((BeanConfigurator)configurator).addQualifier(arg_0));
                        ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)configurator.param("implementationClass", implementationClass)).creator(MockBeanCreator.class)).defaultBean()).identifier("dummy")).done();
                    }
                    if (configInjectionPoint) {
                        ((BeanConfigurator)((BeanConfigurator)context.configure(Config.class).addType(Config.class)).creator(ConfigBeanCreator.class)).done();
                    }
                    if (!configPropertyInjectionPoints.isEmpty()) {
                        BeanConfigurator configPropertyConfigurator = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)context.configure(Object.class).identifier("configProperty")).addQualifier(ConfigProperty.class)).param("useDefaultConfigProperties", QuarkusComponentTestExtension.this.useDefaultConfigProperties.get())).addInjectionPoint((org.jboss.jandex.Type)ClassType.create(InjectionPoint.class), new AnnotationInstance[0])).creator(ConfigPropertyBeanCreator.class);
                        for (InjectionPointInfo.TypeAndQualifiers configPropertyInjectionPoint : configPropertyInjectionPoints) {
                            configPropertyConfigurator.addType(configPropertyInjectionPoint.type);
                        }
                        configPropertyConfigurator.done();
                    }
                    LOG.debugf("Test injection points analyzed in %s ms [found: %s, mocked: %s]", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), (long)context.getInjectionPoints().size(), (long)unsatisfiedInjectionPoints.size());
                }
            });
            for (MockBeanConfiguratorImpl mockBeanConfiguratorImpl : this.mockConfigurators) {
                builder.addBeanRegistrar(this.registrarForMock(mockBeanConfiguratorImpl));
            }
            BeanProcessor beanProcessor = builder.build();
            try {
                Consumer<BytecodeTransformer> consumer = new Consumer<BytecodeTransformer>(){

                    @Override
                    public void accept(BytecodeTransformer transformer) {
                        throw new UnsupportedOperationException();
                    }
                };
                ContextRegistrar.RegistrationContext registrationContext = beanProcessor.registerCustomContexts();
                qualifiers.addAll(((Map)registrationContext.get(BuildExtension.Key.QUALIFIERS)).keySet());
                beanResolver.set(((BeanDeployment)registrationContext.get(BuildExtension.Key.DEPLOYMENT)).getBeanResolver());
                beanProcessor.registerScopes();
                beanProcessor.registerBeans();
                beanProcessor.getBeanDeployment().initBeanByTypeMap();
                beanProcessor.registerSyntheticObservers();
                beanProcessor.initialize((Consumer)consumer, Collections.emptyList());
                BeanDeploymentValidator.ValidationContext validationContext = beanProcessor.validate((Consumer)consumer);
                beanProcessor.processValidationErrors(validationContext);
                ExecutorService executor = Executors.newCachedThreadPool();
                beanProcessor.generateResources(null, new HashSet(), (Consumer)consumer, true, executor);
                executor.shutdown();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Error generating resources", iOException);
            }
            QuarkusComponentTestClassLoader quarkusComponentTestClassLoader = new QuarkusComponentTestClassLoader(oldTccl, componentsProviderFile, null);
            Thread.currentThread().setContextClassLoader(quarkusComponentTestClassLoader);
            Arc.initialize();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return oldTccl;
    }

    private void indexComponentClass(Indexer indexer, Class<?> componentClass) {
        try {
            while (componentClass != null) {
                indexer.indexClass(componentClass);
                for (Annotation annotation : componentClass.getAnnotations()) {
                    indexer.indexClass(annotation.annotationType());
                }
                for (Field field : componentClass.getDeclaredFields()) {
                    this.indexAnnotatedElement(indexer, field);
                }
                for (Method method : componentClass.getDeclaredMethods()) {
                    this.indexAnnotatedElement(indexer, method);
                    for (Parameter param : method.getParameters()) {
                        this.indexAnnotatedElement(indexer, param);
                    }
                }
                for (Class<?> iface : componentClass.getInterfaces()) {
                    this.indexComponentClass(indexer, iface);
                }
                componentClass = componentClass.getSuperclass();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to index:" + componentClass, e);
        }
    }

    private void indexAnnotatedElement(Indexer indexer, AnnotatedElement element) throws IOException {
        for (Annotation annotation : element.getAnnotations()) {
            indexer.indexClass(annotation.annotationType());
        }
    }

    private boolean isSatisfied(org.jboss.jandex.Type requiredType, Set<AnnotationInstance> qualifiers, InjectionPointInfo injectionPoint, Iterable<BeanInfo> beans, BeanDeployment beanDeployment) {
        for (BeanInfo beanInfo : beans) {
            if (!Beans.matches((BeanInfo)beanInfo, (org.jboss.jandex.Type)requiredType, qualifiers)) continue;
            LOG.debugf("Injection point %s satisfied by %s", (Object)injectionPoint.getTargetInfo(), (Object)beanInfo.toString());
            return true;
        }
        for (MockBeanConfiguratorImpl mockBeanConfiguratorImpl : this.mockConfigurators) {
            if (!mockBeanConfiguratorImpl.matches(beanDeployment.getBeanResolver(), requiredType, qualifiers)) continue;
            LOG.debugf("Injection point %s satisfied by %s", (Object)injectionPoint.getTargetInfo(), (Object)mockBeanConfiguratorImpl);
            return true;
        }
        return false;
    }

    private String nameToPath(String packName) {
        return packName.replace('.', '/');
    }

    static <T> T cast(Object obj) {
        return (T)obj;
    }

    private List<FieldInjector> injectFields(Class<?> testClass, Object testInstance) throws Exception {
        Class<? extends Annotation> deprecatedInjectMock = this.loadDeprecatedInjectMock();
        List<Class> injectAnnotations = deprecatedInjectMock != null ? List.of(Inject.class, InjectMock.class, deprecatedInjectMock) : List.of(Inject.class, InjectMock.class);
        ArrayList<FieldInjector> injectedFields = new ArrayList<FieldInjector>();
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            block1: for (Field field : current.getDeclaredFields()) {
                for (Class annotation : injectAnnotations) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    injectedFields.add(new FieldInjector(field, testInstance));
                    continue block1;
                }
            }
            current = current.getSuperclass();
        }
        return injectedFields;
    }

    private Class<? extends Annotation> loadDeprecatedInjectMock() {
        try {
            return Class.forName("io.quarkus.test.junit.mockito.InjectMock");
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static boolean isListRequiredType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return List.class.equals((Object)parameterizedType.getRawType());
        }
        return false;
    }

    private static boolean isTypeArgumentInstanceHandle(Type type) {
        Type typeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (typeArgument instanceof ParameterizedType) {
            return ((ParameterizedType)typeArgument).getRawType().equals(InstanceHandle.class);
        }
        return false;
    }

    private boolean resolvesToBuiltinBean(Class<?> rawType) {
        return Instance.class.isAssignableFrom(rawType) || Event.class.equals(rawType) || BeanManager.class.equals(rawType);
    }

    static class FieldInjector {
        private final Field field;
        private final List<InstanceHandle<?>> unsetHandles;

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public FieldInjector(Field field, Object testInstance) throws Exception {
            super();
            this.field = field;
            container = Arc.container();
            beanManager = container.beanManager();
            requiredType = field.getGenericType();
            qualifiers = QuarkusComponentTestExtension.getQualifiers(field, beanManager);
            if (qualifiers.length <= 0) ** GOTO lbl18
            if (!Arrays.stream(qualifiers).anyMatch((Predicate<Annotation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/annotation/Annotation;)Z)((All.Literal)All.Literal.INSTANCE))) ** GOTO lbl18
            if (QuarkusComponentTestExtension.isListRequiredType(requiredType)) {
                handles = container.listAll(requiredType, qualifiers);
                injectedInstance /* !! */  = QuarkusComponentTestExtension.isTypeArgumentInstanceHandle(requiredType) != false ? handles : handles.stream().map((Function<InstanceHandle, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(), (Lio/quarkus/arc/InstanceHandle;)Ljava/lang/Object;)()).collect(Collectors.toUnmodifiableList());
                this.unsetHandles = (List)QuarkusComponentTestExtension.cast(handles);
            } else {
                throw new IllegalStateException("Invalid injection point type: " + field);
lbl18:
                // 2 sources

                handle = container.instance(requiredType, qualifiers);
                if (field.isAnnotationPresent(Inject.class)) {
                    if (handle.getBean().getKind() == InjectableBean.Kind.SYNTHETIC) {
                        throw new IllegalStateException(String.format("The injected field %s expects a real component; but obtained: %s", new Object[]{field, handle.getBean()}));
                    }
                } else if (handle.getBean().getKind() != InjectableBean.Kind.SYNTHETIC) {
                    throw new IllegalStateException(String.format("The injected field %s expects a mocked bean; but obtained: %s", new Object[]{field, handle.getBean()}));
                }
                injectedInstance /* !! */  = handle.get();
                this.unsetHandles = List.of(handle);
            }
            field.setAccessible(true);
            field.set(testInstance, injectedInstance /* !! */ );
        }

        void unset(Object testInstance) throws Exception {
            for (InstanceHandle<?> handle : this.unsetHandles) {
                if (handle.getBean() == null || !handle.getBean().getScope().equals(Dependent.class)) continue;
                try {
                    handle.destroy();
                }
                catch (Exception e) {
                    LOG.errorf((Throwable)e, "Unable to destroy the injected %s", (Object)handle.getBean());
                }
            }
            this.field.setAccessible(true);
            this.field.set(testInstance, null);
        }
    }
}

