/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime;

import io.quarkus.kafka.streams.runtime.HotReplacementInterceptor;
import io.quarkus.runtime.LaunchMode;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.streams.StreamsConfig;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class KafkaStreamsPropertiesUtil {
    private static final String STREAMS_OPTION_PREFIX = "kafka-streams.";
    private static final String QUARKUS_STREAMS_OPTION_PREFIX = "quarkus.kafka-streams.";

    private static boolean isKafkaStreamsProperty(String prefix, String property) {
        return property.startsWith(prefix);
    }

    private static void includeKafkaStreamsProperty(Config config, Properties kafkaStreamsProperties, String prefix, String property) {
        Optional value = config.getOptionalValue(property, String.class);
        if (value.isPresent()) {
            kafkaStreamsProperties.setProperty(property.substring(prefix.length()), (String)value.get());
        }
    }

    private static void addHotReplacementInterceptor(Properties kafkaStreamsProperties) {
        Object interceptorConfig = HotReplacementInterceptor.class.getName();
        Object originalInterceptorConfig = kafkaStreamsProperties.get(StreamsConfig.consumerPrefix((String)"interceptor.classes"));
        if (originalInterceptorConfig != null) {
            interceptorConfig = (String)interceptorConfig + "," + originalInterceptorConfig;
        }
        kafkaStreamsProperties.put(StreamsConfig.consumerPrefix((String)"interceptor.classes"), interceptorConfig);
    }

    private static Properties kafkaStreamsProperties(String prefix) {
        Properties kafkaStreamsProperties = new Properties();
        Config config = ConfigProvider.getConfig();
        for (String property : config.getPropertyNames()) {
            if (!KafkaStreamsPropertiesUtil.isKafkaStreamsProperty(prefix, property)) continue;
            KafkaStreamsPropertiesUtil.includeKafkaStreamsProperty(config, kafkaStreamsProperties, prefix, property);
        }
        return kafkaStreamsProperties;
    }

    public static Properties appKafkaStreamsProperties() {
        return KafkaStreamsPropertiesUtil.kafkaStreamsProperties(STREAMS_OPTION_PREFIX);
    }

    public static Properties quarkusKafkaStreamsProperties() {
        return KafkaStreamsPropertiesUtil.kafkaStreamsProperties(QUARKUS_STREAMS_OPTION_PREFIX);
    }

    public static Properties buildKafkaStreamsProperties(LaunchMode launchMode) {
        Properties kafkaStreamsProperties = KafkaStreamsPropertiesUtil.appKafkaStreamsProperties();
        if (launchMode == LaunchMode.DEVELOPMENT) {
            KafkaStreamsPropertiesUtil.addHotReplacementInterceptor(kafkaStreamsProperties);
        }
        return kafkaStreamsProperties;
    }
}

