/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.quarkus.kubernetes.deployment.ContainerConfig;
import io.quarkus.kubernetes.deployment.MountConverter;
import io.quarkus.kubernetes.deployment.PortConverter;
import io.quarkus.kubernetes.deployment.ProbeConverter;
import java.util.Map;

public class ContainerConverter {
    public static Container convert(Map.Entry<String, ContainerConfig> e) {
        return ((ContainerBuilder)ContainerConverter.convert(e.getValue()).withName(e.getKey())).build();
    }

    private static ContainerBuilder convert(ContainerConfig c) {
        ContainerBuilder b = new ContainerBuilder();
        c.image.ifPresent(arg_0 -> ((ContainerBuilder)b).withImage(arg_0));
        c.workingDir.ifPresent(arg_0 -> ((ContainerBuilder)b).withWorkingDir(arg_0));
        c.command.ifPresent(w -> b.withCommand(w.toArray(new String[0])));
        c.arguments.ifPresent(w -> b.withArguments(w.toArray(new String[0])));
        if (c.readinessProbe != null && c.readinessProbe.hasUserSuppliedAction()) {
            b.withReadinessProbe(ProbeConverter.convert(c.readinessProbe));
        }
        if (c.livenessProbe != null && c.livenessProbe.hasUserSuppliedAction()) {
            b.withLivenessProbe(ProbeConverter.convert(c.livenessProbe));
        }
        b.addAllToEnvVars(c.convertToEnvs());
        c.ports.entrySet().forEach(e -> b.addToPorts(new Port[]{PortConverter.convert(e)}));
        c.mounts.entrySet().forEach(e -> b.addToMounts(new Mount[]{MountConverter.convert(e)}));
        return b;
    }
}

