/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.quarkus.kubernetes.deployment.ContainerConfig;
import io.quarkus.kubernetes.deployment.MountConverter;
import io.quarkus.kubernetes.deployment.PortConverter;
import io.quarkus.kubernetes.deployment.ProbeConverter;
import java.util.Map;

public class ContainerConverter {
    public static Container convert(Map.Entry<String, ContainerConfig> e) {
        return ContainerConverter.convert(e.getKey(), e.getValue()).build();
    }

    private static ContainerBuilder convert(String name, ContainerConfig c) {
        ContainerBuilder b = new ContainerBuilder();
        b.withName(name);
        b.withImagePullPolicy(c.imagePullPolicy());
        c.image().ifPresent(arg_0 -> ((ContainerBuilder)b).withImage(arg_0));
        c.workingDir().ifPresent(arg_0 -> ((ContainerBuilder)b).withWorkingDir(arg_0));
        c.command().ifPresent(w -> b.withCommand(w.toArray(new String[0])));
        c.arguments().ifPresent(w -> b.withArguments(w.toArray(new String[0])));
        if (c.readinessProbe() != null && c.readinessProbe().hasUserSuppliedAction()) {
            b.withReadinessProbe(ProbeConverter.convert(name, c.readinessProbe()));
        }
        if (c.livenessProbe() != null && c.livenessProbe().hasUserSuppliedAction()) {
            b.withLivenessProbe(ProbeConverter.convert(name, c.livenessProbe()));
        }
        b.addAllToEnvVars(c.convertToEnvs());
        c.ports().entrySet().forEach(e -> b.addToPorts(new Port[]{PortConverter.convert(e)}));
        c.mounts().entrySet().forEach(e -> b.addToMounts(new Mount[]{MountConverter.convert(e)}));
        if (c.resources().requests().memory().isPresent() || c.resources().requests().cpu().isPresent()) {
            b.withNewRequestResources((String)c.resources().requests().memory().orElse(null), (String)c.resources().requests().cpu().orElse(null));
        }
        if (c.resources().limits().memory().isPresent() || c.resources().limits().cpu().isPresent()) {
            b.withNewLimitResources((String)c.resources().limits().memory().orElse(null), (String)c.resources().limits().cpu().orElse(null));
        }
        return b;
    }
}

