/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.smallrye.config.WithDefault;

public interface DebugConfig {
    public static final String PORT_NAME = "debug";
    public static final String JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
    public static final String AGENTLIB_FORMAT = "-agentlib:jdwp=transport=%s,server=y,suspend=%s,address=%s";

    @WithDefault(value="false")
    public boolean enabled();

    @WithDefault(value="dt_socket")
    public String transport();

    @WithDefault(value="n")
    public String suspend();

    @WithDefault(value="5005")
    public Integer addressPort();

    default public Env buildJavaToolOptionsEnv() {
        return ((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(JAVA_TOOL_OPTIONS)).withValue(String.format(AGENTLIB_FORMAT, this.transport(), this.suspend(), this.addressPort()))).build();
    }

    default public Port buildDebugPort() {
        return ((PortBuilder)((PortBuilder)Port.newBuilder().withName(PORT_NAME)).withContainerPort(this.addressPort())).build();
    }
}

