package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;

/**
 * Represents a resource generated by the quarkus-kubernetes extension
 */
public final class GeneratedKubernetesResourceBuildItem extends MultiBuildItem {

    private final String name;
    private final byte[] content;

    public GeneratedKubernetesResourceBuildItem(String name, byte[] content) {
        this.name = name;
        this.content = content;
    }

    public String getName() {
        return name;
    }

    public byte[] getContent() {
        return content;
    }
}
