/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class Attachment {
    public static final String DISPOSITION_INLINE = "inline";
    public static final String DISPOSITION_ATTACHMENT = "attachment";
    private String name;
    private File file;
    private String description;
    private String disposition;
    private Publisher<Byte> data;
    private String contentType;
    private String contentId;

    public Attachment(String name, File file, String contentType) {
        this.setName(name).setFile(file).setContentType(contentType).setDisposition(DISPOSITION_ATTACHMENT);
    }

    public Attachment(String name, File file, String contentType, String contentId) {
        this.setName(name).setFile(file).setContentType(contentType).setContentId(contentId).setDisposition(DISPOSITION_INLINE);
    }

    public Attachment(String name, byte[] data, String contentType) {
        this.setName(name).setData(data).setContentType(contentType).setDisposition(DISPOSITION_ATTACHMENT);
    }

    public Attachment(String name, Publisher<Byte> data, String contentType) {
        this.setName(name).setData(data).setContentType(contentType).setDisposition(DISPOSITION_ATTACHMENT);
    }

    public Attachment(String name, byte[] data, String contentType, String contentId) {
        this.setName(name).setData(data).setContentType(contentType).setContentId(contentId).setDisposition(DISPOSITION_INLINE);
    }

    public Attachment(String name, Publisher<Byte> data, String contentType, String contentId) {
        this.setName(name).setData(data).setContentType(contentType).setContentId(contentId).setDisposition(DISPOSITION_INLINE);
    }

    public Attachment(String name, byte[] data, String contentType, String description, String disposition) {
        this.setName(name).setData(data).setContentType(contentType).setDescription(description).setDisposition(disposition);
    }

    public Attachment(String name, Publisher<Byte> data, String contentType, String description, String disposition) {
        this.setName(name).setData(data).setContentType(contentType).setDescription(description).setDisposition(disposition);
    }

    public String getName() {
        return this.name;
    }

    public Attachment setName(String name) {
        this.name = name;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public Attachment setFile(File file) {
        this.file = file;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Attachment setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public Attachment setDisposition(String disposition) {
        this.disposition = disposition;
        return this;
    }

    public Publisher<Byte> getData() {
        return this.data;
    }

    public Attachment setData(final byte[] data) {
        if (data == null || data.length == 0) {
            this.data = ReactiveStreams.empty().buildRs();
            return this;
        }
        Iterable iterable = () -> new Iterator<Byte>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return data.length > this.index;
            }

            @Override
            public Byte next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return data[this.index++];
            }
        };
        this.data = ReactiveStreams.fromIterable(iterable).buildRs();
        return this;
    }

    public Attachment setData(Publisher<Byte> data) {
        if (data == null) {
            this.data = ReactiveStreams.empty().buildRs();
        }
        this.data = data;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Attachment setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentId() {
        return this.contentId;
    }

    public Attachment setContentId(String contentId) {
        this.contentId = contentId != null && (!contentId.startsWith("<") || !contentId.endsWith(">")) ? "<" + contentId + ">" : contentId;
        return this;
    }

    public boolean isInlineAttachment() {
        return DISPOSITION_INLINE.equalsIgnoreCase(this.disposition);
    }
}

