/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.mailer.runtime.MailClientProducer;
import io.quarkus.mailer.runtime.MailConfig;
import io.quarkus.mailer.runtime.ReactiveMailerImpl;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.MailClient;
import io.vertx.ext.mail.StartTLSOptions;
import java.lang.annotation.Annotation;

@Recorder
public class MailConfigRecorder {
    private static volatile MailClient client;

    public RuntimeValue<MailClient> configureTheClient(RuntimeValue<Vertx> vertx, BeanContainer container, MailConfig config, ShutdownContext shutdown) {
        this.initialize((Vertx)vertx.getValue(), config);
        MailClientProducer producer = (MailClientProducer)container.instance(MailClientProducer.class, new Annotation[0]);
        producer.initialize(client);
        shutdown.addShutdownTask(this::close);
        return new RuntimeValue((Object)client);
    }

    public RuntimeValue<ReactiveMailerImpl> configureTheMailer(BeanContainer container, MailConfig config, LaunchMode launchMode) {
        ReactiveMailerImpl mailer = (ReactiveMailerImpl)container.instance(ReactiveMailerImpl.class, new Annotation[0]);
        mailer.configure(config.from, config.bounceAddress, config.mock.orElse(launchMode.isDevOrTest()));
        return new RuntimeValue((Object)mailer);
    }

    void initialize(Vertx vertx, MailConfig config) {
        io.vertx.ext.mail.MailConfig cfg = this.toVertxMailConfig(config);
        client = MailClient.createNonShared((Vertx)vertx, (io.vertx.ext.mail.MailConfig)cfg);
    }

    private io.vertx.ext.mail.MailConfig toVertxMailConfig(MailConfig config) {
        io.vertx.ext.mail.MailConfig cfg = new io.vertx.ext.mail.MailConfig();
        config.authMethods.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setAuthMethods(arg_0));
        cfg.setDisableEsmtp(config.disableEsmtp);
        cfg.setHostname(config.host);
        cfg.setKeepAlive(config.keepAlive);
        config.keyStore.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setKeyStore(arg_0));
        config.keyStorePassword.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setKeyStorePassword(arg_0));
        config.login.ifPresent(s -> cfg.setLogin(LoginOption.valueOf((String)s.toUpperCase())));
        config.maxPoolSize.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setMaxPoolSize(arg_0));
        config.ownHostName.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setOwnHostname(arg_0));
        config.username.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setUsername(arg_0));
        config.password.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setPassword(arg_0));
        config.port.ifPresent(arg_0 -> ((io.vertx.ext.mail.MailConfig)cfg).setPort(arg_0));
        cfg.setSsl(config.ssl);
        config.startTLS.ifPresent(s -> cfg.setStarttls(StartTLSOptions.valueOf((String)s.toUpperCase())));
        cfg.setTrustAll(config.trustAll);
        return cfg;
    }

    void close() {
        if (client != null) {
            client.close();
        }
    }
}

