/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.MailTemplate;
import io.quarkus.mailer.ReactiveMailer;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

class MailTemplateInstanceImpl
implements MailTemplate.MailTemplateInstance {
    private final ReactiveMailer mailer;
    private final TemplateInstance templateInstance;
    private final Map<String, Object> data;
    private Mail mail;

    MailTemplateInstanceImpl(ReactiveMailer mailer, TemplateInstance templateInstance) {
        this.mailer = mailer;
        this.templateInstance = templateInstance;
        this.data = new HashMap<String, Object>();
        this.mail = new Mail();
    }

    @Override
    public MailTemplate.MailTemplateInstance mail(Mail mail) {
        this.mail = mail;
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance to(String ... to) {
        this.mail.addTo(to);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance cc(String ... cc) {
        this.mail.addCc(cc);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance bcc(String ... bcc) {
        this.mail.addBcc(bcc);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance subject(String subject) {
        this.mail.setSubject(subject);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance from(String from) {
        this.mail.setFrom(from);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance replyTo(String replyTo) {
        this.mail.setReplyTo(replyTo);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance bounceAddress(String bounceAddress) {
        this.mail.setBounceAddress(bounceAddress);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance data(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    @Override
    public CompletionStage<Void> send() {
        ArrayList<Result> results;
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (this.templateInstance.getAttribute("variants") != null) {
            results = new ArrayList<Result>();
            List variants = (List)this.templateInstance.getAttribute("variants");
            for (Variant variant : variants) {
                if (!variant.mediaType.equals("text/html") && !variant.mediaType.equals("text/plain")) continue;
                results.add(new Result(variant, this.templateInstance.setAttribute("selectedVariant", (Object)variant).data(this.data).renderAsync().toCompletableFuture()));
            }
            if (results.isEmpty()) {
                throw new IllegalStateException("No suitable template variant found");
            }
        } else {
            throw new IllegalStateException("No template variant found");
        }
        CompletableFuture<Void> all = CompletableFuture.allOf((CompletableFuture[])results.stream().map(Result::getValue).toArray(CompletableFuture[]::new));
        all.whenComplete((r1, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                try {
                    for (Result res : results) {
                        if (res.variant.mediaType.equals("text/html")) {
                            this.mail.setHtml(res.value.get());
                            continue;
                        }
                        if (!res.variant.mediaType.equals("text/plain")) continue;
                        this.mail.setText(res.value.get());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    result.completeExceptionally(e);
                }
                this.mailer.send(this.mail).whenComplete((r, t) -> {
                    if (t != null) {
                        result.completeExceptionally((Throwable)t);
                    } else {
                        result.complete(null);
                    }
                });
            }
        });
        return result;
    }

    static class Result {
        final Variant variant;
        final CompletableFuture<String> value;

        public Result(Variant variant, CompletableFuture<String> result) {
            this.variant = variant;
            this.value = result;
        }

        CompletableFuture<String> getValue() {
            return this.value;
        }
    }
}

