/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Attachment;
import io.quarkus.mailer.Mail;
import io.quarkus.mailer.ReactiveMailer;
import io.quarkus.mailer.runtime.MockMailboxImpl;
import io.vertx.axle.core.Vertx;
import io.vertx.axle.core.file.AsyncFile;
import io.vertx.axle.ext.mail.MailClient;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.OpenOptions;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.MailMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class ReactiveMailerImpl
implements ReactiveMailer {
    private static final Logger LOGGER = Logger.getLogger((String)"quarkus-mailer");
    @Inject
    MailClient client;
    @Inject
    Vertx vertx;
    @Inject
    MockMailboxImpl mockMailbox;
    private volatile String from;
    private volatile String bounceAddress;
    private volatile boolean mock;

    @Override
    public CompletionStage<Void> send(Mail ... mails) {
        if (mails == null) {
            throw new IllegalArgumentException("The `mails` parameter must not be `null`");
        }
        return ReactiveMailerImpl.allOf(Arrays.stream(mails).map(mail -> this.toMailMessage((Mail)mail).thenCompose(mailMessage -> this.send((Mail)mail, (MailMessage)mailMessage))).collect(Collectors.toList()));
    }

    private CompletionStage<Void> send(Mail mail, MailMessage message) {
        if (this.mock) {
            LOGGER.infof("Sending email %s from %s to %s, text body: \n%s\nhtml body: \n%s", new Object[]{message.getSubject(), message.getFrom(), message.getTo(), message.getText(), message.getHtml()});
            return this.mockMailbox.send(mail);
        }
        return this.client.sendMail(message).thenAccept(x -> {});
    }

    private CompletionStage<MailMessage> toMailMessage(Mail mail) {
        MailMessage message = new MailMessage();
        if (mail.getBounceAddress() != null) {
            message.setBounceAddress(mail.getBounceAddress());
        } else {
            message.setBounceAddress(this.bounceAddress);
        }
        if (mail.getFrom() != null) {
            message.setFrom(mail.getFrom());
        } else {
            message.setFrom(this.from);
        }
        message.setTo(mail.getTo());
        message.setCc(mail.getCc());
        message.setBcc(mail.getBcc());
        message.setSubject(mail.getSubject());
        message.setText(mail.getText());
        message.setHtml(mail.getHtml());
        message.setHeaders(this.toMultimap(mail.getHeaders()));
        if (mail.getReplyTo() != null) {
            message.addHeader("Reply-To", mail.getReplyTo());
        }
        ArrayList stages = new ArrayList();
        CopyOnWriteArrayList attachments = new CopyOnWriteArrayList();
        CopyOnWriteArrayList inline = new CopyOnWriteArrayList();
        for (Attachment attachment : mail.getAttachments()) {
            if (attachment.isInlineAttachment()) {
                stages.add(this.toMailAttachment(attachment).thenAccept(inline::add));
                continue;
            }
            stages.add(this.toMailAttachment(attachment).thenAccept(attachments::add));
        }
        return ReactiveMailerImpl.allOf(stages).thenApply(x -> {
            message.setAttachment(attachments);
            message.setInlineAttachment(inline);
            return message;
        });
    }

    private MultiMap toMultimap(Map<String, List<String>> headers) {
        MultiMap mm = MultiMap.caseInsensitiveMultiMap();
        headers.forEach((arg_0, arg_1) -> ((MultiMap)mm).add(arg_0, arg_1));
        return mm;
    }

    private CompletionStage<MailAttachment> toMailAttachment(Attachment attachment) {
        MailAttachment attach = new MailAttachment();
        attach.setName(attachment.getName());
        attach.setContentId(attachment.getContentId());
        attach.setDescription(attachment.getDescription());
        attach.setDisposition(attachment.getDisposition());
        attach.setContentType(attachment.getContentType());
        if (attachment.getFile() == null && attachment.getData() == null || attachment.getFile() != null && attachment.getData() != null) {
            throw new IllegalArgumentException("An attachment must contain either a file or a raw data");
        }
        return ReactiveMailerImpl.getAttachmentStream(this.vertx, attachment).thenApply(arg_0 -> ((MailAttachment)attach).setData(arg_0));
    }

    public static CompletionStage<Buffer> getAttachmentStream(Vertx vertx, Attachment attachment) {
        if (attachment.getFile() != null) {
            CompletionStage open = vertx.fileSystem().open(attachment.getFile().getAbsolutePath(), new OpenOptions().setRead(true).setCreate(false));
            return ReactiveStreams.fromCompletionStage((CompletionStage)open).flatMap(af -> af.toPublisherBuilder().map(io.vertx.axle.core.buffer.Buffer::getDelegate).onTerminate(() -> ((AsyncFile)af).close())).collect(Buffer::buffer, Buffer::appendBuffer).run();
        }
        if (attachment.getData() != null) {
            Publisher<Byte> data = attachment.getData();
            return ReactiveStreams.fromPublisher(data).collect(Buffer::buffer, Buffer::appendByte).run();
        }
        CompletableFuture<Buffer> future = new CompletableFuture<Buffer>();
        future.completeExceptionally(new IllegalArgumentException("Attachment has no data"));
        return future;
    }

    private static CompletionStage<Void> allOf(List<CompletionStage<?>> stages) {
        CompletableFuture[] array = (CompletableFuture[])stages.stream().map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(array);
    }

    void configure(Optional<String> from, Optional<String> bounceAddress, boolean mock) {
        this.from = from.orElse(null);
        this.bounceAddress = bounceAddress.orElse(null);
        this.mock = mock;
    }
}

