/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class ChangeStreamOptions {
    private FullDocument fullDocument;
    private BsonDocument resumeToken;
    private BsonTimestamp startAtOperationTime;
    private long maxAwaitTime;
    private Collation collation;
    private TimeUnit maxAwaitTimeUnit;

    public ChangeStreamOptions fullDocument(FullDocument fullDocument) {
        this.fullDocument = fullDocument;
        return this;
    }

    public ChangeStreamOptions resumeAfter(BsonDocument resumeToken) {
        this.resumeToken = resumeToken;
        return this;
    }

    public ChangeStreamOptions startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = startAtOperationTime;
        return this;
    }

    public ChangeStreamOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.maxAwaitTime = maxAwaitTime;
        this.maxAwaitTimeUnit = timeUnit;
        return this;
    }

    public ChangeStreamOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public <T> ChangeStreamPublisher<T> apply(ChangeStreamPublisher<T> stream) {
        ChangeStreamPublisher publisher = stream;
        if (this.collation != null) {
            publisher = publisher.collation(this.collation);
        }
        if (this.maxAwaitTime > 0L) {
            publisher = publisher.maxAwaitTime(this.maxAwaitTime, this.maxAwaitTimeUnit);
        }
        if (this.fullDocument != null) {
            publisher = publisher.fullDocument(this.fullDocument);
        }
        if (this.resumeToken != null) {
            publisher = publisher.resumeAfter(this.resumeToken);
        }
        if (this.startAtOperationTime != null) {
            publisher = publisher.startAtOperationTime(this.startAtOperationTime);
        }
        return publisher;
    }
}

