/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime.graal;

import com.mongodb.MongoClientException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SocketStreamFactory;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.internal.connection.SocketStream;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

@TargetClass(value=SocketStreamFactory.class)
final class SocketStreamFactorySubstitution {
    @Alias
    private SocketSettings settings;
    @Alias
    private SslSettings sslSettings;
    @Alias
    private SocketFactory socketFactory;
    @Alias
    private BufferProvider bufferProvider;

    SocketStreamFactorySubstitution() {
    }

    @Substitute
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream = this.socketFactory != null ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.socketFactory, this.bufferProvider) : (this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.settings, this.sslSettings, (SocketFactory)this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider));
        return stream;
    }

    @Alias
    private SSLContext getSslContext() {
        try {
            return this.sslSettings.getContext() == null ? SSLContext.getDefault() : this.sslSettings.getContext();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", (Throwable)e);
        }
    }
}

