/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime.interceptor;

import io.quarkus.narayana.jta.runtime.interceptor.TransactionalInterceptorBase;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.BlockingOperationNotAllowedException;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;

@Interceptor
@Transactional(value=Transactional.TxType.REQUIRED)
@Priority(value=200)
public class TransactionalInterceptorRequired
extends TransactionalInterceptorBase {
    public TransactionalInterceptorRequired() {
        super(false);
    }

    @Override
    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new BlockingOperationNotAllowedException("Cannot start a JTA transaction from the IO thread.");
        }
        return super.intercept(ic);
    }

    @Override
    protected Object doIntercept(TransactionManager tm, Transaction tx, InvocationContext ic) throws Exception {
        if (tx == null) {
            return this.invokeInOurTx(ic, tm);
        }
        return this.invokeInCallerTx(ic, tx);
    }
}

