/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.neo4j.deployment.Neo4jBuildTimeConfig;
import io.quarkus.neo4j.deployment.Neo4jDriverBuildItem;
import io.quarkus.neo4j.runtime.Neo4jConfiguration;
import io.quarkus.neo4j.runtime.Neo4jDriverProducer;
import io.quarkus.neo4j.runtime.Neo4jDriverRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.function.Consumer;
import org.neo4j.driver.Driver;

class Neo4jDriverProcessor {
    Neo4jDriverProcessor() {
    }

    @BuildStep
    FeatureBuildItem createFeature(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.NEO4J));
        return new FeatureBuildItem(Feature.NEO4J);
    }

    @BuildStep
    AdditionalBeanBuildItem createDriverProducer() {
        return AdditionalBeanBuildItem.unremovableOf(Neo4jDriverProducer.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    Neo4jDriverBuildItem configureDriverProducer(Neo4jDriverRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, Neo4jConfiguration configuration, ShutdownContextBuildItem shutdownContext) {
        RuntimeValue driverHolder = recorder.initializeDriver(configuration, (ShutdownContext)shutdownContext);
        recorder.configureNeo4jProducer(beanContainerBuildItem.getValue(), driverHolder);
        return new Neo4jDriverBuildItem((RuntimeValue<Driver>)driverHolder);
    }

    @BuildStep
    HealthBuildItem addHealthCheck(Neo4jBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.neo4j.runtime.health.Neo4jHealthCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void metrics(Neo4jConfiguration configuration, Neo4jDriverRecorder recorder, BuildProducer<MetricsFactoryConsumerBuildItem> metrics) {
        Consumer metricsFactoryConsumer = recorder.registerMetrics(configuration);
        metrics.produce((BuildItem)new MetricsFactoryConsumerBuildItem(metricsFactoryConsumer));
    }
}

