/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import org.neo4j.driver.Config;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class Neo4jConfiguration {
    static final String DEFAULT_SERVER_URI = "bolt://localhost:7687";
    static final String DEFAULT_USERNAME = "neo4j";
    static final String DEFAULT_PASSWORD = "neo4j";
    @ConfigItem(defaultValue="bolt://localhost:7687")
    public String uri;
    @ConfigItem
    public Authentication authentication;
    @ConfigItem
    public boolean encrypted;
    @ConfigItem
    public TrustSettings trustSettings;
    @ConfigItem
    public Pool pool;

    @ConfigGroup
    static class Pool {
        @ConfigItem
        public boolean metricsEnabled;
        @ConfigItem
        public boolean logLeakedSessions;
        @ConfigItem(defaultValue="100")
        public int maxConnectionPoolSize;
        @ConfigItem(defaultValue="-0.001S")
        public Duration idleTimeBeforeConnectionTest;
        @ConfigItem(defaultValue="1H")
        public Duration maxConnectionLifetime;
        @ConfigItem(defaultValue="1M")
        public Duration connectionAcquisitionTimeout;

        Pool() {
        }

        public String toString() {
            return "Pool{metricsEnabled=" + this.metricsEnabled + ", logLeakedSessions=" + this.logLeakedSessions + ", maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleTimeBeforeConnectionTest=" + this.idleTimeBeforeConnectionTest + ", maxConnectionLifetime=" + this.maxConnectionLifetime + ", connectionAcquisitionTimeout=" + this.connectionAcquisitionTimeout + '}';
        }
    }

    @ConfigGroup
    static class TrustSettings {
        @ConfigItem(defaultValue="TRUST_SYSTEM_CA_SIGNED_CERTIFICATES")
        public Strategy strategy;
        @ConfigItem
        public Optional<Path> certFile = Optional.empty();
        @ConfigItem
        public boolean hostnameVerificationEnabled;

        TrustSettings() {
        }

        Config.TrustStrategy toInternalRepresentation() {
            Config.TrustStrategy internalRepresentation;
            Strategy nonNullStrategy = this.strategy == null ? Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES : this.strategy;
            switch (nonNullStrategy) {
                case TRUST_ALL_CERTIFICATES: {
                    internalRepresentation = Config.TrustStrategy.trustAllCertificates();
                    break;
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    internalRepresentation = Config.TrustStrategy.trustSystemCertificates();
                    break;
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    File certFile = this.certFile.map(Path::toFile).filter(File::isFile).orElseThrow(() -> new RuntimeException("Configured trust strategy requires a certificate file."));
                    internalRepresentation = Config.TrustStrategy.trustCustomCertificateSignedBy((File)certFile);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown trust strategy: " + this.strategy.name());
                }
            }
            if (this.hostnameVerificationEnabled) {
                internalRepresentation.withHostnameVerification();
            } else {
                internalRepresentation.withoutHostnameVerification();
            }
            return internalRepresentation;
        }

        public static enum Strategy {
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }

    @ConfigGroup
    static class Authentication {
        @ConfigItem(defaultValue="neo4j")
        public String username;
        @ConfigItem(defaultValue="neo4j")
        public String password;
        @ConfigItem
        public boolean disabled;

        Authentication() {
        }
    }
}

