/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.neo4j.runtime.Neo4jConfiguration;
import io.quarkus.neo4j.runtime.Neo4jDriverProducer;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.ssl.SslContextConfiguration;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;

@Recorder
public class Neo4jDriverRecorder {
    private static final Logger log = Logger.getLogger(Neo4jDriverRecorder.class);

    public void configureNeo4jProducer(BeanContainer beanContainer, Neo4jConfiguration configuration, ShutdownContext shutdownContext) {
        Driver driver = this.initializeDriver(configuration, shutdownContext);
        Neo4jDriverProducer driverProducer = (Neo4jDriverProducer)beanContainer.instance(Neo4jDriverProducer.class, new Annotation[0]);
        driverProducer.initialize(driver);
    }

    private Driver initializeDriver(Neo4jConfiguration configuration, ShutdownContext shutdownContext) {
        String uri = configuration.uri;
        AuthToken authToken = AuthTokens.none();
        if (!configuration.authentication.disabled) {
            authToken = AuthTokens.basic((String)configuration.authentication.username, (String)configuration.authentication.password);
        }
        Config.ConfigBuilder configBuilder = Neo4jDriverRecorder.createBaseConfig();
        Neo4jDriverRecorder.configureSsl(configBuilder);
        Neo4jDriverRecorder.configurePoolSettings(configBuilder, configuration.pool);
        Driver driver = GraphDatabase.driver((String)uri, (AuthToken)authToken, (Config)configBuilder.build());
        shutdownContext.addShutdownTask(() -> ((Driver)driver).close());
        return driver;
    }

    private static Config.ConfigBuilder createBaseConfig() {
        Logging logging;
        Config.ConfigBuilder configBuilder = Config.builder();
        try {
            logging = Logging.slf4j();
        }
        catch (Exception e) {
            logging = Logging.javaUtilLogging((Level)Level.INFO);
        }
        configBuilder.withLogging(logging);
        return configBuilder;
    }

    private static void configureSsl(Config.ConfigBuilder configBuilder) {
        if (ImageInfo.inImageRuntimeCode() && !SslContextConfiguration.isSslNativeEnabled()) {
            log.warn((Object)"Native SSL is disabled, communication between this client and the Neo4j server won't be encrypted.");
            configBuilder.withoutEncryption();
        }
    }

    private static void configurePoolSettings(Config.ConfigBuilder configBuilder, Neo4jConfiguration.Pool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring Neo4j pool settings with " + pool));
        }
        if (pool.logLeakedSessions) {
            configBuilder.withLeakedSessionsLogging();
        }
        configBuilder.withMaxConnectionPoolSize(pool.maxConnectionPoolSize);
        configBuilder.withConnectionLivenessCheckTimeout(pool.idleTimeBeforeConnectionTest.toMillis(), TimeUnit.MILLISECONDS);
        configBuilder.withMaxConnectionLifetime(pool.maxConnectionLifetime.toMillis(), TimeUnit.MILLISECONDS);
        configBuilder.withConnectionAcquisitionTimeout(pool.connectionAcquisitionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (pool.metricsEnabled) {
            configBuilder.withDriverMetrics();
        } else {
            configBuilder.withoutDriverMetrics();
        }
    }
}

