/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.filter;

import io.quarkus.oidc.client.filter.runtime.OidcClientFilterConfig;
import io.quarkus.oidc.client.runtime.AbstractTokensProducer;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;

@Provider
@Singleton
@Priority(value=1000)
public class OidcClientRequestFilter
extends AbstractTokensProducer
implements ClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(OidcClientRequestFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";
    @Inject
    OidcClientFilterConfig oidcClientFilterConfig;

    public void filter(ClientRequestContext requestContext) throws IOException {
        try {
            String accessToken = this.getAccessToken();
            requestContext.getHeaders().add((Object)"Authorization", (Object)(BEARER_SCHEME_WITH_SPACE + accessToken));
        }
        catch (DisabledOidcClientException ex) {
            requestContext.abortWith(Response.status((int)500).build());
        }
        catch (Exception ex) {
            LOG.debugf("Access token is not available, aborting the request with HTTP 401 error: %s", (Object)ex.getMessage());
            requestContext.abortWith(Response.status((int)401).build());
        }
    }

    private String getAccessToken() {
        return this.awaitTokens().getAccessToken();
    }

    protected Optional<String> clientId() {
        return this.oidcClientFilterConfig.clientName;
    }
}

