/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.runtime;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.jboss.logging.Logger;

@Provider
@Singleton
@Priority(value=1000)
public abstract class AbstractTokenRequestFilter
implements ClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(AbstractTokenRequestFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";

    public void propagateToken(ClientRequestContext requestContext, String token) throws IOException {
        if (token != null) {
            requestContext.getHeaders().add((Object)"Authorization", (Object)(BEARER_SCHEME_WITH_SPACE + token));
        } else {
            LOG.debugf("Injected access token is null, aborting the request with HTTP 401 error", new Object[0]);
            this.abortRequest(requestContext);
        }
    }

    protected boolean verifyTokenInstance(ClientRequestContext requestContext, Instance<?> instance) throws IOException {
        if (!instance.isResolvable()) {
            LOG.debugf("Access token is not injected, aborting the request with HTTP 401 error", new Object[0]);
            this.abortRequest(requestContext);
            return false;
        }
        if (instance.isAmbiguous()) {
            LOG.debugf("More than one access token instance is available, aborting the request with HTTP 401 error", new Object[0]);
            this.abortRequest(requestContext);
            return false;
        }
        return true;
    }

    protected void abortRequest(ClientRequestContext requestContext) {
        requestContext.abortWith(Response.status((int)401).build());
    }
}

