/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.token.propagation.runtime.AbstractTokenRequestFilter;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.vertx.core.Vertx;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.client.ClientRequestContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.eclipse.microprofile.config.ConfigProvider;

public class AccessTokenRequestFilter
extends AbstractTokenRequestFilter {
    private static final String ERROR_MSG = "OIDC Token Propagation requires a safe (isolated) Vert.x sub-context because configuration property 'quarkus.oidc-token-propagation.enabled-during-authentication' has been set to true, but the current context hasn't been flagged as such.";
    private final boolean enabledDuringAuthentication = Boolean.getBoolean("io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX") || Boolean.getBoolean("io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX");
    private final Instance<TokenCredential> accessToken = CDI.current().select(TokenCredential.class, new Annotation[0]);
    OidcClient exchangeTokenClient;
    String exchangeTokenProperty;

    @PostConstruct
    public void initExchangeTokenClient() {
        if (this.isExchangeToken()) {
            OidcClients clients = (OidcClients)Arc.container().instance(OidcClients.class, new Annotation[0]).get();
            String clientName = this.getClientName();
            this.exchangeTokenClient = clientName != null ? clients.getClient(clientName) : clients.getClient();
            OidcClientConfig.Grant.Type exchangeTokenGrantType = (OidcClientConfig.Grant.Type)ConfigProvider.getConfig().getValue("quarkus.oidc-client." + (String)(clientName != null ? clientName + "." : "") + "grant.type", OidcClientConfig.Grant.Type.class);
            if (exchangeTokenGrantType == OidcClientConfig.Grant.Type.EXCHANGE) {
                this.exchangeTokenProperty = "subject_token";
            } else if (exchangeTokenGrantType == OidcClientConfig.Grant.Type.JWT) {
                this.exchangeTokenProperty = "assertion";
            } else {
                throw new ConfigurationException("Token exchange is required but OIDC client is configured to use the " + exchangeTokenGrantType.getGrantType() + " grantType");
            }
        }
    }

    protected boolean isExchangeToken() {
        return (Boolean)ConfigProvider.getConfig().getValue("quarkus.oidc-token-propagation.exchange-token", Boolean.TYPE);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.acquireTokenCredentialFromCtx(requestContext)) {
            this.propagateToken(requestContext, this.exchangeTokenIfNeeded(AccessTokenRequestFilter.getTokenCredentialFromContext().getToken()));
        } else if (this.verifyTokenInstance(requestContext, this.accessToken)) {
            this.propagateToken(requestContext, this.exchangeTokenIfNeeded(((TokenCredential)this.accessToken.get()).getToken()));
        }
    }

    private String exchangeTokenIfNeeded(String token) {
        if (this.exchangeTokenClient != null) {
            return ((Tokens)this.exchangeTokenClient.getTokens(Collections.singletonMap(this.exchangeTokenProperty, token)).await().indefinitely()).getAccessToken();
        }
        return token;
    }

    protected String getClientName() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.oidc-token-propagation.client-name", String.class).orElse(null);
    }

    private boolean acquireTokenCredentialFromCtx(ClientRequestContext requestContext) {
        TokenCredential tokenCredential;
        if (this.enabledDuringAuthentication && (tokenCredential = AccessTokenRequestFilter.getTokenCredentialFromContext()) != null) {
            if (tokenCredential.getToken() == null) {
                this.abortRequest(requestContext);
            } else {
                return true;
            }
        }
        return false;
    }

    private static TokenCredential getTokenCredentialFromContext() {
        VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
        return (TokenCredential)Vertx.currentContext().getLocal((Object)TokenCredential.class.getName());
    }
}

