/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom;

import io.quarkus.bom.PomResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class FsPomResolver
implements PomResolver {
    private final Path projectPom;
    private Artifact artifact;
    private Model model;

    public FsPomResolver(Path projectPom) {
        if (!Files.exists(projectPom, new LinkOption[0])) {
            throw new IllegalArgumentException("Path does not exist " + projectPom);
        }
        this.projectPom = projectPom;
    }

    @Override
    public Path pomPath() {
        return this.projectPom;
    }

    @Override
    public Model readLocalModel(Path pom) throws IOException {
        if (pom.equals(this.projectPom)) {
            return this.model();
        }
        if (Files.isDirectory(pom, new LinkOption[0])) {
            pom = pom.resolve("pom.xml");
        }
        return Files.exists(pom, new LinkOption[0]) ? ModelUtils.readModel((Path)pom) : null;
    }

    @Override
    public Model model() throws IOException {
        return this.model == null ? (this.model = ModelUtils.readModel((Path)this.projectPom)) : this.model;
    }

    @Override
    public String source() {
        return this.projectPom.toString();
    }

    @Override
    public Artifact pomArtifact() {
        if (this.artifact == null) {
            try {
                Model model = this.model();
                this.artifact = new DefaultArtifact(ModelUtils.getGroupId((Model)model), model.getArtifactId(), null, "pom", ModelUtils.getVersion((Model)model));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read model of " + this.projectPom, e);
            }
        }
        return this.artifact;
    }

    @Override
    public boolean isResolved() {
        return true;
    }
}

