/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class FileReportWriter {
    protected final Path reportFile;
    private BufferedWriter writer;
    private int tagDepth;
    private int indentChars = 4;
    private StringBuilder buf;
    private boolean closed;

    public FileReportWriter(String name) {
        this(Paths.get(name, new String[0]));
    }

    public FileReportWriter(Path p) {
        Objects.requireNonNull(p);
        this.reportFile = p;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void indentChars(int indentChars) {
        this.indentChars = indentChars;
    }

    protected BufferedWriter initWriter() throws IOException {
        if (!Files.exists(this.reportFile, new LinkOption[0])) {
            Path parentDir;
            Path path = parentDir = this.reportFile.isAbsolute() ? this.reportFile.getParent() : this.reportFile.normalize().toAbsolutePath().getParent();
            if (parentDir != null) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
        }
        this.writer = Files.newBufferedWriter(this.reportFile, new OpenOption[0]);
        return this.writer;
    }

    protected BufferedWriter writer() throws IOException {
        return this.closed ? null : (this.writer == null ? (this.writer = this.initWriter()) : this.writer);
    }

    protected void writeLine(Object line) throws IOException {
        this.append(line);
        this.newLine();
    }

    protected void newLine() throws IOException {
        this.writer().newLine();
    }

    protected void append(Object line) throws IOException {
        this.writer().write(line.toString());
    }

    protected StringBuilder buf() {
        if (this.buf == null) {
            this.buf = new StringBuilder();
        } else {
            this.buf.setLength(0);
        }
        return this.buf;
    }

    protected void writeTag(String name, Object value) throws IOException {
        this.writeTag(name, null, value);
    }

    protected void writeTag(String name, String style, Object value) throws IOException {
        this.offset();
        StringBuilder buf = this.buf();
        buf.append('<').append(name);
        if (style != null) {
            buf.append(" style=\"").append(style).append("\"");
        }
        buf.append('>').append(value).append("</").append(name).append('>');
        this.writeLine(buf);
    }

    protected void writeAnchor(String url, String text) throws IOException {
        this.offset();
        this.writeLine(this.generateAnchor(url, text));
    }

    protected String generateAnchor(String url, String text) {
        StringBuilder buf = this.buf();
        buf.append("<a href=\"").append(url).append("\">").append(text).append("</a>");
        return buf.toString();
    }

    protected void openTag(String name) throws IOException {
        this.openTag(name, null);
    }

    protected void openTag(String name, String style) throws IOException {
        this.offset();
        StringBuilder buf = this.buf();
        buf.append('<').append(name);
        if (style != null) {
            buf.append(" style=\"").append(style).append("\"");
        }
        buf.append('>');
        this.writeLine(buf.toString());
        ++this.tagDepth;
    }

    protected void closeTag(String name) throws IOException {
        --this.tagDepth;
        this.offset();
        StringBuilder buf = this.buf();
        buf.append("</").append(name).append('>');
        this.writeLine(buf.toString());
    }

    protected void emptyTag(String name) throws IOException {
        this.offset();
        StringBuilder buf = this.buf();
        buf.append("<").append(name).append("/>");
        this.writeLine(buf.toString());
    }

    protected void offsetLine(String line) throws IOException {
        this.offset();
        this.writeLine(line);
    }

    protected void offset() throws IOException {
        StringBuilder buf = this.buf();
        for (int i = 0; i < this.tagDepth * this.indentChars; ++i) {
            buf.append(' ');
        }
        this.append(buf);
    }

    protected void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
        this.closed = true;
    }
}

