/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.DefaultReleaseId;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.bom.decomposer.Util;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import org.apache.maven.model.Model;

public class ReleaseIdFactory {
    public static ReleaseId forModel(Model model) {
        String version = ModelUtils.getVersion((Model)model);
        String scmOrigin = Util.getScmOrigin(model);
        if (scmOrigin != null) {
            String scmTag = Util.getScmTag(model);
            return scmTag.isEmpty() || "HEAD".equals(scmTag) ? ReleaseIdFactory.create(ReleaseOrigin.Factory.scmConnection(scmOrigin), ReleaseVersion.Factory.version(version)) : ReleaseIdFactory.create(ReleaseOrigin.Factory.scmConnection(scmOrigin), ReleaseVersion.Factory.tag(scmTag));
        }
        return ReleaseIdFactory.create(ReleaseOrigin.Factory.ga(ModelUtils.getGroupId((Model)model), model.getArtifactId()), ReleaseVersion.Factory.version(version));
    }

    public static ReleaseId create(ReleaseOrigin origin, ReleaseVersion version) {
        return new DefaultReleaseId(origin, version);
    }

    public static ReleaseId forGav(String groupId, String artifactId, String version) {
        return ReleaseIdFactory.create(ReleaseOrigin.Factory.ga(groupId, artifactId), ReleaseVersion.Factory.version(version));
    }

    public static ReleaseId forGav(String coordsStr) {
        ArtifactCoords coords = ArtifactCoords.fromString((String)coordsStr);
        return ReleaseIdFactory.forGav(coords.getGroupId(), coords.getArtifactId(), coords.getVersion());
    }

    public static ReleaseId forScmAndTag(String scm, String tag) {
        return ReleaseIdFactory.create(ReleaseOrigin.Factory.scmConnection(scm), ReleaseVersion.Factory.tag(tag));
    }
}

