/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import java.util.Objects;

public interface ReleaseVersion {
    public String asString();

    public static class StringReleaseVersion
    implements ReleaseVersion {
        final String type;
        final String value;

        StringReleaseVersion(String type, String value) {
            this.type = Objects.requireNonNull(type);
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public String asString() {
            return this.value;
        }

        public String toString() {
            return this.type + ": " + this.value;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringReleaseVersion other = (StringReleaseVersion)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }
    }

    public static class Factory {
        public static ReleaseVersion tag(String tag) {
            return new StringReleaseVersion("Tag", tag);
        }

        public static ReleaseVersion version(String version) {
            return new StringReleaseVersion("Version", version);
        }
    }
}

