/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.resolver;

import io.quarkus.bom.resolver.ArtifactNotFoundException;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class DefaultArtifactResolver
implements ArtifactResolver {
    private static final String NOT_FOUND_ARTIFACTS = "not-found-artifacts.txt";
    private final MavenArtifactResolver resolver;
    private final Path baseDir;
    private final Path notFoundArtifactsPath;
    private final Set<ArtifactCoords> notFoundArtifacts = new HashSet<ArtifactCoords>(0);

    static DefaultArtifactResolver newInstance(MavenArtifactResolver resolver, Path baseDir) {
        return new DefaultArtifactResolver(resolver, baseDir);
    }

    private DefaultArtifactResolver(MavenArtifactResolver resolver, Path baseDir) {
        this.resolver = Objects.requireNonNull(resolver);
        this.baseDir = baseDir;
        if (baseDir != null) {
            Path cacheDir = baseDir.resolve(".quarkus-bom-generator");
            if (!Files.exists(cacheDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(cacheDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create cache directory " + cacheDir, e);
                }
            }
            this.notFoundArtifactsPath = cacheDir.resolve(NOT_FOUND_ARTIFACTS);
            if (Files.exists(this.notFoundArtifactsPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(this.notFoundArtifactsPath);){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        this.notFoundArtifacts.add(ArtifactCoords.fromString((String)s));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read " + this.notFoundArtifactsPath, e);
                }
            }
        } else {
            this.notFoundArtifactsPath = null;
        }
    }

    @Override
    public Path getBaseDir() {
        return this.baseDir;
    }

    @Override
    public ArtifactResult resolve(Artifact a) {
        ArtifactCoords coords = DefaultArtifactResolver.toCoords(a);
        if (this.isRecordedAsNonExisting(coords)) {
            throw this.recordedAsNonExistingError(coords);
        }
        try {
            return this.resolver.resolve(a);
        }
        catch (BootstrapMavenException e) {
            if (DefaultArtifactResolver.isArtifactNotFoundError(e)) {
                this.persistNotFoundArtifacts(coords);
            }
            throw new ArtifactNotFoundException("Failed to resolve " + a, (Throwable)e);
        }
    }

    @Override
    public ArtifactResult resolveOrNull(Artifact a) {
        ArtifactCoords coords = DefaultArtifactResolver.toCoords(a);
        if (this.isRecordedAsNonExisting(coords)) {
            return null;
        }
        try {
            return this.resolver.resolve(a);
        }
        catch (BootstrapMavenException e) {
            if (DefaultArtifactResolver.isArtifactNotFoundError(e)) {
                this.persistNotFoundArtifacts(coords);
            }
            return null;
        }
    }

    @Override
    public MavenArtifactResolver underlyingResolver() {
        return this.resolver;
    }

    @Override
    public ArtifactDescriptorResult describe(Artifact a) {
        LocalWorkspace workspace;
        ArtifactDescriptorResult result;
        ArtifactCoords coords = DefaultArtifactResolver.toCoords(a);
        if (this.isRecordedAsNonExisting(coords)) {
            throw this.recordedAsNonExistingError(coords);
        }
        try {
            result = this.resolver.resolveDescriptor(a);
        }
        catch (BootstrapMavenException e) {
            throw new ArtifactNotFoundException("Failed to describe " + a, (Throwable)e);
        }
        boolean pomExists = a.getFile() == null ? (new File(this.resolver.getSession().getLocalRepository().getBasedir(), this.resolver.getSession().getLocalRepositoryManager().getPathForLocalArtifact(a)).exists() ? true : (workspace = this.resolver.getMavenContext().getWorkspace()) != null && workspace.getProject(a.getGroupId(), a.getArtifactId()) != null) : a.getFile().exists();
        if (!pomExists) {
            this.persistNotFoundArtifacts(coords);
            throw new ArtifactNotFoundException(a + " was found in neither the Maven local repository nor in the project's workspace");
        }
        return result;
    }

    private void persistNotFoundArtifacts(ArtifactCoords coords) {
        if (this.notFoundArtifactsPath == null) {
            return;
        }
        this.notFoundArtifacts.add(coords);
        try (BufferedWriter writer = Files.newBufferedWriter(this.notFoundArtifactsPath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            writer.append(coords.toString());
            writer.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to persist not found artifact list to " + this.notFoundArtifactsPath, e);
        }
    }

    private boolean isRecordedAsNonExisting(ArtifactCoords coords) {
        return this.notFoundArtifacts.contains(coords);
    }

    private static boolean isArtifactNotFoundError(Throwable t) {
        return (t = t.getCause()) instanceof ArtifactResolutionException && (t = t.getCause()) instanceof org.eclipse.aether.transfer.ArtifactNotFoundException;
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private ArtifactNotFoundException recordedAsNonExistingError(ArtifactCoords coords) {
        return new ArtifactNotFoundException("Artifact " + coords + " was previously recorded as non-existing");
    }
}

