/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import java.io.File;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="invoke-platform-project", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.NONE)
public class BuildPlatformProjectMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${basedir}/generated-platform-project")
    File outputDir;
    @Parameter(defaultValue="${maven.home}")
    String mavenHome;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession mavenSession;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="quarkus.invoke-platform-project.skip", defaultValue="false")
    boolean skip;
    @Component
    private Invoker invoker;

    public void execute() throws MojoExecutionException, MojoFailureException {
        InvocationResult result;
        String reactorFailureBehavior;
        File userSettings;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping generated platform project invoker");
            return;
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(this.outputDir, "pom.xml"));
        request.setGoals(this.mavenSession.getRequest().getGoals());
        request.setShowErrors(this.mavenSession.getRequest().isShowErrors());
        request.setShellEnvironmentInherited(true);
        request.setBatchMode(true);
        request.setLocalRepositoryDirectory(this.mavenSession.getRequest().getLocalRepositoryPath());
        File globalSettings = this.mavenSession.getRequest().getGlobalSettingsFile();
        if (globalSettings != null && globalSettings.exists()) {
            request.setGlobalSettingsFile(globalSettings);
        }
        if ((userSettings = this.mavenSession.getRequest().getUserSettingsFile()) != null && userSettings.exists()) {
            request.setUserSettingsFile(userSettings);
        }
        if ((reactorFailureBehavior = this.mavenSession.getReactorFailureBehavior()) != null) {
            request.setReactorFailureBehavior(InvocationRequest.ReactorFailureBehavior.valueOfByLongOption((String)reactorFailureBehavior.toLowerCase().replace('_', '-')));
        }
        request.setProfiles(this.mavenSession.getRequest().getActiveProfiles());
        request.setProperties(this.mavenSession.getRequest().getUserProperties());
        String registryUrl = this.project.getProperties().getProperty("quarkus.registry.url");
        Properties props = request.getProperties();
        if (registryUrl != null && !props.containsKey("quarkus.registry.url")) {
            props.setProperty("quarkus.registry.url", registryUrl);
        }
        try {
            result = this.invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to build the platform project", (Exception)((Object)e));
        }
        if (result.getExitCode() != 0) {
            if (result.getExecutionException() != null) {
                throw new MojoExecutionException("Failed to build the platform project", (Exception)result.getExecutionException());
            }
            throw new MojoExecutionException("Failed to build the platform project, please consult the errors logged above.");
        }
    }
}

