/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomHtmlReportGenerator;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.maven.GenerateMavenRepoZip;
import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bom.decomposer.maven.platformgen.AttachedMavenPluginConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformBomGeneratorConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformDescriptorGeneratorConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformReleaseConfig;
import io.quarkus.bom.decomposer.maven.util.Utils;
import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.HtmlBomDiffReportGenerator;
import io.quarkus.bom.platform.PlatformBomComposer;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomUtils;
import io.quarkus.bom.platform.PlatformCatalogResolver;
import io.quarkus.bom.platform.PlatformMember;
import io.quarkus.bom.platform.PlatformMemberConfig;
import io.quarkus.bom.platform.PlatformMemberTestConfig;
import io.quarkus.bom.platform.RedHatExtensionDependencyCheck;
import io.quarkus.bom.platform.ReportIndexPageGenerator;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nu.studer.java.util.OrderedProperties;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="generate-platform-project", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE)
public class GeneratePlatformProjectMojo
extends AbstractMojo {
    private static final String LAST_BOM_UPDATE = "last-bom-update";
    private static final String MEMBER_LAST_BOM_UPDATE_PROP = "member.last-bom-update";
    private static final String PLATFORM_KEY_PROP = "platform.key";
    private static final String PLATFORM_STREAM_PROP = "platform.stream";
    private static final String PLATFORM_RELEASE_PROP = "platform.release";
    @Component
    private RepositorySystem repoSystem;
    @Component
    private RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(required=true, defaultValue="${basedir}/generated-platform-project")
    File outputDir;
    @Parameter(required=true, defaultValue="${project.build.directory}/reports")
    File reportsDir;
    @Parameter(required=true)
    PlatformConfig platformConfig;
    private PlatformReleaseConfig platformReleaseConfig;
    @Parameter(required=true, defaultValue="${project.build.directory}/updated-pom.xml")
    File updatedPom;
    Artifact universalBom;
    MavenArtifactResolver nonWorkspaceResolver;
    MavenArtifactResolver mavenResolver;
    ArtifactResolver artifactResolver;
    PlatformCatalogResolver catalogs;
    final Map<ArtifactKey, PlatformMemberImpl> members = new LinkedHashMap<ArtifactKey, PlatformMemberImpl>();
    private PlatformMemberImpl quarkusCore;
    private DecomposedBom universalGeneratedBom;
    private Path universalPlatformBomXml;
    private PluginDescriptor pluginDescr;
    private List<String> pomLines;
    @Parameter(property="recordUpdatedBoms")
    private boolean recordUpdatedBoms;
    private Set<ArtifactKey> universalBomDepKeys = new HashSet<ArtifactKey>();
    private TransformerFactory transformerFactory;
    private Map<String, String> pomPropsByValues = new HashMap<String, String>();
    private Profile generatedBomReleaseProfile;

    private boolean isClean() {
        List<String> goals;
        if (this.session.getGoals().isEmpty()) {
            if (this.project.getDefaultGoal() == null) {
                return false;
            }
            goals = Arrays.asList(this.project.getDefaultGoal().split("\\s+"));
        } else {
            goals = this.session.getGoals();
        }
        return goals.contains("clean");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isClean()) {
            this.getLog().info((CharSequence)("Deleting " + this.outputDir));
            IoUtils.recursiveDelete((Path)this.outputDir.toPath());
        }
        this.quarkusCore = new PlatformMemberImpl(this.platformConfig.getCore());
        this.members.put(this.quarkusCore.key(), this.quarkusCore);
        for (PlatformMemberConfig memberConfig : this.platformConfig.getMembers()) {
            if (!memberConfig.isEnabled()) continue;
            PlatformMemberImpl member = new PlatformMemberImpl(memberConfig);
            this.members.put(member.key(), member);
        }
        Model pom = Utils.newModel();
        String rootArtifactIdBase = GeneratePlatformProjectMojo.getArtifactIdBase(this.project.getModel());
        pom.setArtifactId(rootArtifactIdBase + "-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.artifactIdToName(rootArtifactIdBase) + " - Parent");
        File pomXml = new File(this.outputDir, "pom.xml");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(this.project.getGroupId());
        parent.setArtifactId(this.project.getArtifactId());
        parent.setVersion(this.project.getVersion());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(this.project.getFile().getParentFile().toPath()).toString());
        pom.setParent(parent);
        pom.getProperties().setProperty(PLATFORM_KEY_PROP, this.releaseConfig().getPlatformKey());
        pom.getProperties().setProperty(PLATFORM_STREAM_PROP, this.releaseConfig().getStream());
        pom.getProperties().setProperty(PLATFORM_RELEASE_PROP, this.releaseConfig().getVersion());
        Build build = new Build();
        pom.setBuild(build);
        PluginManagement pm = new PluginManagement();
        pom.getBuild().setPluginManagement(pm);
        Plugin plugin = new Plugin();
        pm.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        plugin.setVersion(this.getTestArtifactVersion(this.pluginDescriptor().getGroupId(), this.pluginDescriptor().getVersion()));
        plugin.setExtensions(true);
        this.generateUniversalPlatformModule(pom);
        for (PlatformMemberImpl member : this.members.values()) {
            this.generateMemberModule(member, pom);
        }
        for (PlatformMemberImpl member : this.members.values()) {
            this.generatePlatformDescriptorModule(member.descriptorCoords(), member.baseModel, true, this.quarkusCore.originalBomCoords().equals(member.originalBomCoords()), this.platformConfig.getAttachedMavenPlugin(), member);
            this.generatePlatformPropertiesModule(member, true);
            GeneratePlatformProjectMojo.persistPom(member.baseModel);
        }
        if (this.platformConfig.getAttachedMavenPlugin() != null) {
            this.generateMavenPluginModule(pom);
        }
        if (this.platformConfig.getGenerateMavenRepoZip() != null) {
            this.generateMavenRepoZipModule(pom);
        }
        this.addReleaseProfile(pom);
        GeneratePlatformProjectMojo.persistPom(pom);
        this.recordUpdatedBoms();
        if (this.platformConfig.isGenerateBomReports() || this.platformConfig.getGenerateBomReportsZip() != null) {
            Path reportsOutputDir = this.reportsDir.toPath();
            try (ReportIndexPageGenerator index = new ReportIndexPageGenerator(reportsOutputDir.resolve("index.html"));){
                Path releasesReport = reportsOutputDir.resolve("main").resolve("generated-releases.html");
                GeneratePlatformProjectMojo.generateReleasesReport(this.universalGeneratedBom, releasesReport);
                index.universalBom(this.universalPlatformBomXml.toUri().toURL(), this.universalGeneratedBom, releasesReport);
                for (PlatformMemberImpl member : this.members.values()) {
                    if (member.originalBomCoords() == null) continue;
                    GeneratePlatformProjectMojo.generateBomReports(member.originalBom, member.generatedBom, reportsOutputDir.resolve(member.config().getName().toLowerCase()), index, member.generatedPomFile, this.artifactResolver());
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to generate platform member BOM reports", e);
            }
            if (this.platformConfig.getGenerateBomReportsZip() != null) {
                Path zip = Paths.get(this.platformConfig.getGenerateBomReportsZip(), new String[0]);
                if (!zip.isAbsolute()) {
                    zip = reportsOutputDir.getParent().resolve(zip);
                }
                try {
                    Files.createDirectories(zip.getParent(), new FileAttribute[0]);
                    ZipUtils.zip((Path)reportsOutputDir, (Path)zip);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to ZIP platform member BOM reports", e);
                }
            }
        }
    }

    private static void generateReleasesReport(DecomposedBom originalBom, Path outputFile) throws BomDecomposerException {
        originalBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)outputFile).skipOriginsWithSingleRelease().build());
    }

    private static void generateBomReports(DecomposedBom originalBom, DecomposedBom generatedBom, Path outputDir, ReportIndexPageGenerator index, Path platformBomXml, ArtifactResolver resolver) throws BomDecomposerException {
        BomDiff.Config config = BomDiff.config();
        config.resolver(resolver);
        if (originalBom.bomResolver() != null && originalBom.bomResolver().isResolved()) {
            config.compare(originalBom.bomResolver().pomPath());
        } else {
            config.compare(originalBom.bomArtifact());
        }
        BomDiff bomDiff = config.to(platformBomXml);
        Path diffFile = outputDir.resolve("diff.html");
        HtmlBomDiffReportGenerator.config((Path)diffFile).report(bomDiff);
        Path generatedReleasesFile = outputDir.resolve("generated-releases.html");
        GeneratePlatformProjectMojo.generateReleasesReport(generatedBom, generatedReleasesFile);
        Path originalReleasesFile = outputDir.resolve("original-releases.html");
        GeneratePlatformProjectMojo.generateReleasesReport(originalBom, originalReleasesFile);
        index.bomReport(bomDiff.mainUrl(), bomDiff.toUrl(), generatedBom, originalReleasesFile, generatedReleasesFile, diffFile);
    }

    private void addReleaseProfile(Model pom) {
        Profile releaseProfile = this.getGeneratedBomReleaseProfile();
        if (releaseProfile != null) {
            pom.addProfile(releaseProfile);
        }
    }

    private void recordUpdatedBoms() throws MojoExecutionException {
        if (!this.recordUpdatedBoms) {
            return;
        }
        int configIndex = this.pomLineContaining("platformConfig", 0);
        if (configIndex < 0) {
            throw new MojoExecutionException("Failed to locate <platformConfig> configuration in " + this.project.getFile());
        }
        int coreIndex = this.pomLineContaining("<core>", configIndex);
        if (coreIndex < 0) {
            throw new MojoExecutionException("Failed to locate <core> configuration in " + this.project.getFile());
        }
        this.updatePreviousMemberRelease(this.quarkusCore, coreIndex);
        int membersIndex = this.pomLineContaining("<members>", configIndex);
        if (membersIndex < 0) {
            throw new MojoExecutionException("Failed to locate <members> configuration in " + this.project.getFile());
        }
        for (PlatformMemberImpl member : this.members.values()) {
            if (member.config().getName().equals(this.quarkusCore.config().getName())) continue;
            this.updatePreviousMemberRelease(member, membersIndex);
        }
        if (this.pomLines != null) {
            File outputDir = this.updatedPom.getParentFile();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            try {
                Files.write(this.updatedPom.toPath(), this.pomLines, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to persist changes to " + this.project.getFile(), (Exception)e);
            }
            try {
                IoUtils.copy((Path)this.updatedPom.toPath(), (Path)this.project.getFile().toPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to replace " + this.project.getFile() + " with " + this.updatedPom, (Exception)e);
            }
            this.project.setPomFile(this.updatedPom);
        }
    }

    private void updatePreviousMemberRelease(PlatformMemberImpl member, int membersIndex) throws MojoExecutionException {
        if (!member.bomChanged) {
            return;
        }
        int memberIndex = this.pomLineContaining("<name>" + member.config().getName() + "</name>", membersIndex);
        if (memberIndex < 0) {
            throw new MojoExecutionException("Failed to locate member configuration with <name>" + member.config().getName() + "</name>");
        }
        int releaseIndex = this.pomLineContaining("<release>", memberIndex);
        if (releaseIndex < 0) {
            throw new MojoExecutionException("Failed to locate <release> configuration for member with <name>" + member.config().getName() + "</name>");
        }
        int releaseEnd = this.pomLineContaining("</release>", releaseIndex);
        if (releaseEnd < 0) {
            throw new MojoExecutionException("Failed to locate the closing </release> for member with <name>" + member.config().getName() + "</name>");
        }
        String l = this.pomLines().get(releaseIndex);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < l.length() && Character.isWhitespace(l.charAt(i)); ++i) {
            buf.append(l.charAt(i));
        }
        buf.append("    <lastDetectedBomUpdate>").append(member.generatedBomCoords().getGroupId()).append(":").append(member.generatedBomCoords().getArtifactId()).append(":").append(member.generatedBomCoords().getVersion()).append("</lastDetectedBomUpdate>");
        int prevIndex = this.pomLineContaining("<lastDetectedBomUpdate>", releaseIndex, releaseEnd);
        if (prevIndex < 0) {
            this.pomLines().add(releaseIndex + 1, buf.toString());
        } else {
            this.pomLines().set(prevIndex, buf.toString());
        }
    }

    private void generateMavenPluginModule(Model parentPom) throws MojoExecutionException {
        ArtifactCoords targetCoords = ArtifactCoords.fromString((String)this.platformConfig.getAttachedMavenPlugin().getTargetPluginCoords());
        String moduleName = targetCoords.getArtifactId();
        parentPom.addModule(moduleName);
        ArtifactCoords originalCoords = ArtifactCoords.fromString((String)this.platformConfig.getAttachedMavenPlugin().getOriginalPluginCoords());
        if (this.platformConfig.getAttachedMavenPlugin().isImportSources()) {
            this.importOriginalPluginSources(parentPom, moduleName, originalCoords, targetCoords);
        } else {
            this.republishOriginalPluginBinary(parentPom, moduleName, targetCoords, originalCoords);
        }
    }

    private void importOriginalPluginSources(Model parentPom, String moduleName, ArtifactCoords originalCoords, ArtifactCoords targetCoords) throws MojoExecutionException {
        List originalDeps;
        Model pom;
        Path sourcesJar;
        try {
            sourcesJar = this.nonWorkspaceResolver().resolve((Artifact)new DefaultArtifact(originalCoords.getGroupId(), originalCoords.getArtifactId(), "sources", "jar", originalCoords.getVersion())).getArtifact().getFile().toPath();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve the sources JAR of " + originalCoords, e);
        }
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        Path baseDir = pomXml.getParentFile().toPath();
        Path javaSources = baseDir.resolve("src").resolve("main").resolve("java");
        Path resourcesDir = javaSources.getParent().resolve("resources");
        try {
            ZipUtils.unzip((Path)sourcesJar, (Path)javaSources);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to unzip " + sourcesJar + " to " + javaSources, (Exception)e);
        }
        try {
            Files.list(javaSources).forEach(p -> {
                if (p.getFileName().toString().equals("io")) {
                    return;
                }
                try {
                    IoUtils.copy((Path)p, (Path)resourcesDir.resolve(p.getFileName()));
                    IoUtils.recursiveDelete((Path)p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            Path metainfDir = resourcesDir.resolve("META-INF");
            Path mavenDir = metainfDir.resolve("maven");
            IoUtils.copy((Path)mavenDir.resolve(originalCoords.getGroupId()).resolve(originalCoords.getArtifactId()).resolve("pom.xml"), (Path)baseDir.resolve("pom.xml"));
            IoUtils.recursiveDelete((Path)mavenDir);
            IoUtils.recursiveDelete((Path)metainfDir.resolve("INDEX.LIST"));
            IoUtils.recursiveDelete((Path)metainfDir.resolve("MANIFEST.MF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to import original plugin sources", (Exception)e);
        }
        try {
            Files.walkFileTree(javaSources, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals("HelpMojo.java")) {
                        try {
                            Files.delete(file);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process " + javaSources, (Exception)e);
        }
        try {
            pom = ModelUtils.readModel((Path)pomXml.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + pomXml, (Exception)e);
        }
        pom.setPomFile(pomXml);
        pom.setGroupId(targetCoords.getGroupId());
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName(targetCoords.getArtifactId()));
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        DependencyManagement dm = pom.getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            pom.setDependencyManagement(dm);
        }
        Artifact quarkusBom = this.quarkusCore.generatedBomCoords();
        Dependency quarkusBomImport = new Dependency();
        quarkusBomImport.setGroupId(quarkusBom.getGroupId());
        quarkusBomImport.setArtifactId(quarkusBom.getArtifactId());
        quarkusBomImport.setType("pom");
        quarkusBomImport.setVersion(quarkusBom.getVersion());
        quarkusBomImport.setScope("import");
        dm.addDependency(quarkusBomImport);
        try {
            originalDeps = this.nonWorkspaceResolver().resolveDescriptor((Artifact)new DefaultArtifact(originalCoords.getGroupId(), originalCoords.getArtifactId(), "jar", originalCoords.getVersion())).getDependencies();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve the artifact descriptor of " + originalCoords, e);
        }
        HashMap<ArtifactKey, String> originalDepVersions = new HashMap<ArtifactKey, String>(originalDeps.size());
        for (org.eclipse.aether.graph.Dependency d : originalDeps) {
            Artifact a = d.getArtifact();
            originalDepVersions.put(new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension()), a.getVersion());
        }
        List managedDeps = this.quarkusCore.generatedBomModel.getDependencyManagement().getDependencies();
        HashMap<ArtifactKey, String> managedDepVersions = new HashMap<ArtifactKey, String>(managedDeps.size());
        for (Object d : managedDeps) {
            managedDepVersions.put(this.getKey((Dependency)d), d.getVersion());
        }
        List pluginDeps = pom.getDependencies();
        pom.setDependencies(new ArrayList(pluginDeps.size()));
        for (Dependency d : pluginDeps) {
            String originalVersion;
            ArtifactKey key;
            if ("test".equals(d.getScope())) continue;
            if (d.getVersion() == null) {
                key = this.getKey(d);
                if (!managedDepVersions.containsKey(key)) {
                    originalVersion = (String)originalDepVersions.get(key);
                    if (originalVersion == null) {
                        throw new IllegalStateException("Failed to determine version for dependency " + d + " of the Maven plugin " + originalCoords);
                    }
                    d.setVersion(this.getTestArtifactVersion(originalCoords.getGroupId(), originalVersion));
                }
            } else if (d.getVersion().startsWith("${")) {
                key = this.getKey(d);
                originalVersion = (String)originalDepVersions.get(key);
                if (originalVersion == null) {
                    throw new IllegalStateException("Failed to determine version for dependency " + d + " of the Maven plugin " + originalCoords);
                }
                if (originalVersion.equals(managedDepVersions.get(key))) {
                    d.setVersion(null);
                } else {
                    d.setVersion(this.getTestArtifactVersion(originalCoords.getGroupId(), originalVersion));
                }
            }
            pom.addDependency(d);
        }
        Properties originalProps = pom.getProperties();
        if (!originalProps.isEmpty()) {
            pom.setProperties(new Properties());
            for (Map.Entry<Object, Object> originalProp : originalProps.entrySet()) {
                String propName = originalProp.getKey().toString();
                if (this.getTestArtifactGroupIdForProperty(propName) != null) continue;
                pom.getProperties().setProperty(propName, originalProp.getValue().toString());
            }
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private ArtifactKey getKey(Dependency d) {
        return new ArtifactKey(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType());
    }

    private static File getPomFile(Model parentPom, String moduleName) {
        return new File(new File(parentPom.getProjectDirectory(), moduleName), "pom.xml");
    }

    private void republishOriginalPluginBinary(Model parentPom, String moduleName, ArtifactCoords targetCoords, ArtifactCoords originalCoords) throws MojoExecutionException {
        Model pom = Utils.newModel();
        if (!targetCoords.getGroupId().equals(this.project.getGroupId())) {
            pom.setGroupId(targetCoords.getGroupId());
        }
        pom.setArtifactId(moduleName);
        if (!targetCoords.getVersion().equals(this.project.getVersion())) {
            pom.setVersion(targetCoords.getVersion());
        }
        pom.setPackaging("maven-plugin");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName(targetCoords.getArtifactId()));
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        DependencyManagement dm = pom.getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            pom.setDependencyManagement(dm);
        }
        Artifact quarkusBom = this.quarkusCore.generatedBomCoords();
        Dependency quarkusBomImport = new Dependency();
        quarkusBomImport.setGroupId(quarkusBom.getGroupId());
        quarkusBomImport.setArtifactId(quarkusBom.getArtifactId());
        quarkusBomImport.setType("pom");
        quarkusBomImport.setVersion(quarkusBom.getVersion());
        quarkusBomImport.setScope("import");
        dm.addDependency(quarkusBomImport);
        Build build = new Build();
        pom.setBuild(build);
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("generate-resources");
        exec.addGoal("attach-maven-plugin");
        Xpp3Dom config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        Xpp3Dom e = new Xpp3Dom("originalPluginCoords");
        e.setValue(this.platformConfig.getAttachedMavenPlugin().getOriginalPluginCoords());
        config.addChild(e);
        e = new Xpp3Dom("targetPluginCoords");
        e.setValue(this.platformConfig.getAttachedMavenPlugin().getTargetPluginCoords());
        config.addChild(e);
        plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId("com.coderplus.maven.plugins");
        plugin.setArtifactId("copy-rename-maven-plugin");
        plugin.setVersion("1.0");
        exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setId("copy-plugin-help");
        exec.setPhase("process-classes");
        exec.addGoal("copy");
        config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        Xpp3Dom el = new Xpp3Dom("sourceFile");
        el.setValue("${project.build.outputDirectory}/META-INF/maven/" + targetCoords.getGroupId() + "/" + targetCoords.getArtifactId() + "/plugin-help.xml");
        config.addChild(el);
        el = new Xpp3Dom("destinationFile");
        el.setValue("${project.build.outputDirectory}/META-INF/maven/" + originalCoords.getGroupId() + "/" + originalCoords.getArtifactId() + "/plugin-help.xml");
        config.addChild(el);
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void generateMavenRepoZipModule(Model parentPom) throws MojoExecutionException {
        Xpp3Dom g;
        Xpp3Dom d;
        Model pom = Utils.newModel();
        String artifactId = "maven-repo-zip-generator";
        pom.setArtifactId("maven-repo-zip-generator");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName("maven-repo-zip-generator"));
        parentPom.addModule("maven-repo-zip-generator");
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, "maven-repo-zip-generator");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        Utils.skipInstallAndDeploy(pom);
        Plugin plugin = new Plugin();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        plugin.setVersion(this.pluginDescriptor().getVersion());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("generate-maven-repo-zip");
        GenerateMavenRepoZip generateMavenRepoZip = this.platformConfig.getGenerateMavenRepoZip();
        Xpp3Dom e = new Xpp3Dom("generateMavenRepoZip");
        Xpp3Dom bom = new Xpp3Dom("bom");
        if (generateMavenRepoZip.getBom() == null) {
            Artifact universalBom = this.getUniversalBomArtifact();
            bom.setValue(universalBom.getGroupId() + ":" + universalBom.getArtifactId() + "::pom:" + universalBom.getVersion());
        } else {
            bom.setValue(generateMavenRepoZip.getBom());
        }
        e.addChild(bom);
        if (generateMavenRepoZip.getRepositoryDir() != null) {
            d = new Xpp3Dom("repositoryDir");
            d.setValue(generateMavenRepoZip.getRepositoryDir());
            e.addChild(d);
        }
        if (generateMavenRepoZip.getZipLocation() != null) {
            d = new Xpp3Dom("zipLocation");
            d.setValue(generateMavenRepoZip.getZipLocation());
            e.addChild(d);
        }
        if (!generateMavenRepoZip.getExcludedGroupIds().isEmpty()) {
            d = new Xpp3Dom("excludedGroupIds");
            for (String string : generateMavenRepoZip.getExcludedGroupIds()) {
                g = new Xpp3Dom("groupId");
                g.setValue(string);
                d.addChild(g);
            }
            e.addChild(d);
        }
        if (!generateMavenRepoZip.getExcludedArtifacts().isEmpty()) {
            d = new Xpp3Dom("excludedArtifacts");
            for (String string : generateMavenRepoZip.getExcludedArtifacts()) {
                g = new Xpp3Dom("key");
                g.setValue(string);
                d.addChild(g);
            }
            e.addChild(d);
        }
        if (!generateMavenRepoZip.getExtraArtifacts().isEmpty()) {
            Xpp3Dom extras = new Xpp3Dom("extraArtifacts");
            for (String string : generateMavenRepoZip.getExtraArtifacts()) {
                g = new Xpp3Dom("artifact");
                g.setValue(string);
                extras.addChild(g);
            }
            for (PlatformMember platformMember : this.members.values()) {
                if (platformMember.config().isHidden() || !platformMember.config().isEnabled()) continue;
                this.addExtraArtifact(extras, platformMember.descriptorCoords().toString());
                this.addExtraArtifact(extras, platformMember.propertiesCoords().toString());
            }
            e.addChild(extras);
        }
        if (generateMavenRepoZip.getIncludedVersionsPattern() != null) {
            d = new Xpp3Dom("includedVersionsPattern");
            d.setValue(generateMavenRepoZip.getIncludedVersionsPattern());
            e.addChild(d);
        }
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        configuration.addChild(e);
        exec.setConfiguration((Object)configuration);
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void generateMemberModule(PlatformMemberImpl member, Model parentPom) throws MojoExecutionException {
        String moduleName = GeneratePlatformProjectMojo.getArtifactIdBase(member.generatedBomCoords().getArtifactId());
        Model pom = Utils.newModel();
        if (!member.generatedBomCoords().getGroupId().equals(this.project.getGroupId())) {
            pom.setGroupId(member.generatedBomCoords().getGroupId());
        }
        pom.setArtifactId(moduleName + "-parent");
        if (!member.generatedBomCoords().getVersion().equals(this.project.getVersion())) {
            pom.setVersion(member.generatedBomCoords().getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + member.config().getName() + " - Parent");
        parentPom.addModule(moduleName);
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        member.baseModel = pom;
        this.generateMemberBom(member);
        if (member.config().hasTests()) {
            this.generateMemberIntegrationTestsModule(member);
        }
        if (member.config().isHidden()) {
            Utils.skipInstallAndDeploy(pom);
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void generateMemberBom(PlatformMemberImpl member) throws MojoExecutionException {
        Model baseModel = this.project.getModel().clone();
        baseModel.setName(GeneratePlatformProjectMojo.getNameBase(member.baseModel) + " Quarkus Platform BOM");
        String moduleName = "bom";
        member.baseModel.addModule("bom");
        Path platformBomXml = member.baseModel.getProjectDirectory().toPath().resolve("bom").resolve("pom.xml");
        member.generatedBomModel = PlatformBomUtils.toPlatformModel((DecomposedBom)member.generatedBom, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        this.addReleaseProfile(member.generatedBomModel);
        if (member.config().isHidden()) {
            Utils.skipInstallAndDeploy(member.generatedBomModel);
        }
        try {
            Files.createDirectories(platformBomXml.getParent(), new FileAttribute[0]);
            ModelUtils.persistModel((Path)platformBomXml, (Model)member.generatedBomModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist generated BOM to " + platformBomXml, (Exception)e);
        }
        member.generatedPomFile = platformBomXml;
        if (this.recordUpdatedBoms) {
            Artifact prevBomCoords = member.previousLastUpdatedBom();
            if (prevBomCoords == null) {
                member.bomChanged = true;
            } else if (!member.config().getRelease().getNext().equals(member.config().getRelease().getLastDetectedBomUpdate())) {
                List prevDeps;
                try {
                    prevDeps = this.nonWorkspaceResolver.resolveDescriptor(prevBomCoords).getManagedDependencies();
                }
                catch (BootstrapMavenException e) {
                    throw new MojoExecutionException("Failed to resolve " + prevBomCoords, (Exception)((Object)e));
                }
                if (prevDeps.isEmpty()) {
                    member.bomChanged = true;
                } else {
                    HashSet<ArtifactCoords> prevArtifacts = new HashSet<ArtifactCoords>(prevDeps.size());
                    for (int i = 0; i < prevDeps.size(); ++i) {
                        org.eclipse.aether.graph.Dependency d = (org.eclipse.aether.graph.Dependency)prevDeps.get(i);
                        Artifact a = d.getArtifact();
                        if (GeneratePlatformProjectMojo.isIrrelevantConstraint(a)) continue;
                        prevArtifacts.add(GeneratePlatformProjectMojo.toCoords(a));
                    }
                    HashSet<ArtifactCoords> currentArtifacts = new HashSet<ArtifactCoords>(prevArtifacts.size());
                    for (ProjectRelease r : member.generatedBom.releases()) {
                        for (ProjectDependency d : r.dependencies()) {
                            Artifact a = d.artifact();
                            if (GeneratePlatformProjectMojo.isIrrelevantConstraint(a)) continue;
                            currentArtifacts.add(GeneratePlatformProjectMojo.toCoords(a));
                        }
                    }
                    member.bomChanged = !prevArtifacts.equals(currentArtifacts);
                }
            }
        }
    }

    private Profile getGeneratedBomReleaseProfile() {
        if (this.generatedBomReleaseProfile == null) {
            Object parentReleaseProfile = null;
            for (Object p : this.project.getModel().getProfiles()) {
                if (!p.getId().equals("release")) continue;
                parentReleaseProfile = p;
                break;
            }
            if (parentReleaseProfile == null) {
                this.getLog().warn((CharSequence)"Failed to locate profile with id 'release'");
                return null;
            }
            Plugin gpgPlugin = null;
            for (Plugin plugin : parentReleaseProfile.getBuild().getPlugins()) {
                if (!plugin.getArtifactId().equals("maven-gpg-plugin")) continue;
                if (plugin.getVersion() == null) {
                    Plugin managedGpgPlugin = (Plugin)this.project.getPluginManagement().getPluginsAsMap().get("org.apache.maven.plugins:maven-gpg-plugin");
                    if (managedGpgPlugin == null) {
                        this.getLog().warn((CharSequence)"Failed to determine the version for org.apache.maven.plugins:maven-gpg-plugin");
                    }
                    plugin = plugin.clone();
                    plugin.setVersion(managedGpgPlugin.getVersion());
                }
                gpgPlugin = plugin;
                break;
            }
            if (gpgPlugin == null) {
                this.getLog().warn((CharSequence)("Failed to locate the maven-gpg-plugin plugin in the " + parentReleaseProfile.getId() + " profile"));
                return null;
            }
            Profile memberReleaseProfile = new Profile();
            memberReleaseProfile.setId(parentReleaseProfile.getId());
            Build build = new Build();
            memberReleaseProfile.setBuild((BuildBase)build);
            build.addPlugin(gpgPlugin);
            this.generatedBomReleaseProfile = memberReleaseProfile;
        }
        return this.generatedBomReleaseProfile;
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return new ArtifactCoords(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion());
    }

    private static boolean isIrrelevantConstraint(Artifact a) {
        return !a.getExtension().equals("jar") || PlatformArtifacts.isCatalogArtifactId((String)a.getArtifactId()) || a.getArtifactId().endsWith("-quarkus-platform-properties") || "sources".equals(a.getClassifier()) || "javadoc".equals(a.getClassifier());
    }

    private List<String> pomLines() {
        if (this.pomLines != null) {
            return this.pomLines;
        }
        try {
            this.pomLines = Files.readAllLines(this.project.getFile().toPath());
            return this.pomLines;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + this.project.getFile(), e);
        }
    }

    private int pomLineContaining(String text, int fromLine) {
        return this.pomLineContaining(text, fromLine, Integer.MAX_VALUE);
    }

    private int pomLineContaining(String text, int fromLine, int toLine) {
        List<String> lines = this.pomLines();
        int upperLimit = Math.min(lines.size(), toLine);
        while (fromLine < upperLimit && !lines.get(fromLine).contains(text)) {
            ++fromLine;
        }
        return fromLine == upperLimit ? -1 : fromLine;
    }

    private void generateMemberIntegrationTestsModule(PlatformMemberImpl member) throws MojoExecutionException {
        Model parentPom = member.baseModel;
        String moduleName = "integration-tests";
        Model pom = Utils.newModel();
        pom.setArtifactId(GeneratePlatformProjectMojo.getArtifactIdBase(parentPom) + "-integration-tests-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName("integration-tests") + " - Parent");
        parentPom.addModule("integration-tests");
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, "integration-tests");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        DependencyManagement dm = new DependencyManagement();
        pom.setDependencyManagement(dm);
        Dependency managedDep = this.getUniversalBomImport();
        dm.addDependency(managedDep);
        managedDep = new Dependency();
        managedDep.setGroupId("io.quarkus");
        managedDep.setArtifactId("quarkus-integration-test-class-transformer");
        managedDep.setVersion(this.quarkusCore.getVersionProperty());
        dm.addDependency(managedDep);
        managedDep = new Dependency();
        managedDep.setGroupId("io.quarkus");
        managedDep.setArtifactId("quarkus-integration-test-class-transformer-deployment");
        managedDep.setVersion(this.quarkusCore.getVersionProperty());
        dm.addDependency(managedDep);
        LinkedHashMap<ArtifactCoords, PlatformMemberTestConfig> testConfigs = new LinkedHashMap<ArtifactCoords, PlatformMemberTestConfig>();
        for (PlatformMemberTestConfig platformMemberTestConfig : member.config().getTests()) {
            testConfigs.put(ArtifactCoords.fromString((String)platformMemberTestConfig.getArtifact()), platformMemberTestConfig);
        }
        if (member.config().getTestCatalogArtifact() != null) {
            Document testCatalogDoc;
            File file;
            Artifact testCatalogArtifact = GeneratePlatformProjectMojo.toAetherArtifact(member.config().getTestCatalogArtifact());
            try {
                file = this.nonWorkspaceResolver().resolve(testCatalogArtifact).getArtifact().getFile();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to resolve test catalog artifact " + testCatalogArtifact, e);
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                Builder parser = new Builder();
                testCatalogDoc = parser.build((Reader)reader);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Failed to parse " + file, ex);
            }
            for (Element testElement : testCatalogDoc.getRootElement().getChildElements("testArtifact")) {
                String testGroupId = testElement.getFirstChildElement("groupId").getValue();
                if (testGroupId == null) {
                    throw new MojoExecutionException("Test catalog " + file + " contains an artifact with a missing groupId " + testElement);
                }
                String testArtifactId = testElement.getFirstChildElement("artifactId").getValue();
                if (testArtifactId == null) {
                    throw new MojoExecutionException("Test catalog " + file + " contains an artifact with a missing artifactId " + testElement);
                }
                ArtifactCoords testCoords = new ArtifactCoords(testGroupId, testArtifactId, null, "jar", testCatalogArtifact.getVersion());
                PlatformMemberTestConfig testConfig = (PlatformMemberTestConfig)testConfigs.get(testCoords);
                if (testConfig != null) continue;
                testConfig = new PlatformMemberTestConfig();
                testConfig.setArtifact(testCoords.getGroupId() + ":" + testCoords.getArtifactId() + ":" + testCoords.getVersion());
                testConfigs.put(testCoords, testConfig);
            }
        }
        for (Map.Entry entry : testConfigs.entrySet()) {
            PlatformMemberTestConfig testConfig = (PlatformMemberTestConfig)entry.getValue();
            if (member.config().getDefaultTestConfig() != null) {
                testConfig.applyDefaults(member.config().getDefaultTestConfig());
            }
            if (testConfig.isExcluded()) continue;
            this.generateIntegrationTestModule((ArtifactCoords)entry.getKey(), testConfig, pom);
        }
        Utils.skipInstallAndDeploy(pom);
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private Dependency getUniversalBomImport() {
        Dependency bomDep = new Dependency();
        Artifact bom = this.getUniversalBomArtifact();
        bomDep.setGroupId(bom.getGroupId());
        bomDep.setArtifactId(bom.getArtifactId());
        bomDep.setVersion(this.getUniversalBomArtifact().getVersion());
        bomDep.setType("pom");
        bomDep.setScope("import");
        return bomDep;
    }

    private void generateIntegrationTestModule(ArtifactCoords testArtifact, PlatformMemberTestConfig testConfig, Model parentPom) throws MojoExecutionException {
        Object moduleName;
        if (parentPom.getModules().contains(testArtifact.getArtifactId())) {
            String tmp = testArtifact.getArtifactId() + "-" + testArtifact.getVersion();
            if (parentPom.getModules().contains(tmp)) {
                throw new MojoExecutionException("The same test " + testArtifact + " appears to be added twice");
            }
            moduleName = tmp;
            this.getLog().warn((CharSequence)("Using " + (String)moduleName + " as the module name for " + testArtifact + " since " + testArtifact.getArtifactId() + " module name already exists"));
        } else {
            moduleName = testArtifact.getArtifactId();
        }
        parentPom.addModule((String)moduleName);
        Model pom = Utils.newModel();
        pom.setArtifactId((String)moduleName);
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + (String)moduleName);
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, (String)moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        if (!testConfig.getPomProperties().isEmpty()) {
            pom.setProperties(testConfig.getPomProperties());
        }
        if (testConfig.isSkip()) {
            pom.getProperties().setProperty("maven.test.skip", "true");
        }
        String testArtifactVersion = this.getTestArtifactVersion(testArtifact.getGroupId(), testArtifact.getVersion());
        Dependency appArtifactDep = new Dependency();
        appArtifactDep.setGroupId(testArtifact.getGroupId());
        appArtifactDep.setArtifactId(testArtifact.getArtifactId());
        if (!testArtifact.getClassifier().isEmpty()) {
            appArtifactDep.setClassifier(testArtifact.getClassifier());
        }
        appArtifactDep.setType(testArtifact.getType());
        appArtifactDep.setVersion(testArtifactVersion);
        pom.addDependency(appArtifactDep);
        Dependency testArtifactDep = new Dependency();
        testArtifactDep.setGroupId(testArtifact.getGroupId());
        testArtifactDep.setArtifactId(testArtifact.getArtifactId());
        testArtifactDep.setClassifier("tests");
        testArtifactDep.setType("test-jar");
        testArtifactDep.setVersion(testArtifactVersion);
        testArtifactDep.setScope("test");
        pom.addDependency(testArtifactDep);
        this.addDependencies(pom, testConfig.getDependencies(), false);
        this.addDependencies(pom, testConfig.getTestDependencies(), true);
        Xpp3Dom depsToScan = new Xpp3Dom("dependenciesToScan");
        Xpp3Dom testDep = new Xpp3Dom("dependency");
        depsToScan.addChild(testDep);
        testDep.setValue(testArtifact.getGroupId() + ":" + testArtifact.getArtifactId());
        if (!testConfig.isSkipJvm()) {
            Build build = new Build();
            pom.setBuild(build);
            if (testConfig.isMavenFailsafePlugin()) {
                build.addPlugin(this.createFailsafeConfig(testConfig, depsToScan, false));
            } else {
                Plugin plugin = new Plugin();
                build.addPlugin(plugin);
                plugin.setGroupId("org.apache.maven.plugins");
                plugin.setArtifactId("maven-surefire-plugin");
                Xpp3Dom config = new Xpp3Dom("configuration");
                plugin.setConfiguration((Object)config);
                config.addChild(depsToScan);
                Xpp3Dom systemProps = null;
                if (!testConfig.getSystemProperties().isEmpty()) {
                    systemProps = new Xpp3Dom("systemPropertyVariables");
                    config.addChild(systemProps);
                    this.addSystemProperties(systemProps, testConfig.getSystemProperties());
                }
                if (!testConfig.getJvmSystemProperties().isEmpty()) {
                    if (systemProps == null) {
                        systemProps = new Xpp3Dom("systemPropertyVariables");
                        config.addChild(systemProps);
                    }
                    this.addSystemProperties(systemProps, testConfig.getJvmSystemProperties());
                }
                this.addGroupsConfig(testConfig, config, false);
                GeneratePlatformProjectMojo.addIncludesExcludesConfig(testConfig, config, false);
            }
            try {
                for (org.eclipse.aether.graph.Dependency d : this.nonWorkspaceResolver().resolveDescriptor((Artifact)GeneratePlatformProjectMojo.toPomArtifact(testArtifact)).getDependencies()) {
                    if (!d.getScope().equals("test")) continue;
                    Artifact a = d.getArtifact();
                    if ("pom".equals(a.getExtension()) && !d.getExclusions().isEmpty()) {
                        boolean skip = false;
                        for (Exclusion e : d.getExclusions()) {
                            if (!"*".equals(e.getGroupId()) || !"*".equals(e.getArtifactId())) continue;
                            skip = true;
                            break;
                        }
                        if (skip) continue;
                    }
                    Dependency modelDep = new Dependency();
                    modelDep.setGroupId(a.getGroupId());
                    modelDep.setArtifactId(a.getArtifactId());
                    if (!a.getClassifier().isEmpty()) {
                        modelDep.setClassifier(a.getClassifier());
                    }
                    modelDep.setType(a.getExtension());
                    if (!this.universalBomDepKeys.contains(new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension()))) {
                        modelDep.setVersion(this.getTestArtifactVersion(a.getGroupId(), a.getVersion()));
                    }
                    modelDep.setScope(d.getScope());
                    if (d.getOptional() != null) {
                        modelDep.setOptional(d.getOptional().booleanValue());
                    }
                    if (!d.getExclusions().isEmpty()) {
                        for (Exclusion e : d.getExclusions()) {
                            org.apache.maven.model.Exclusion modelEx = new org.apache.maven.model.Exclusion();
                            modelEx.setGroupId(e.getGroupId());
                            modelEx.setArtifactId(e.getArtifactId());
                            modelDep.addExclusion(modelEx);
                        }
                    }
                    pom.addDependency(modelDep);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to describe " + testArtifact, e);
            }
        }
        if (!testConfig.isSkipNative()) {
            Profile profile = new Profile();
            pom.addProfile(profile);
            profile.setId("native-image");
            Activation activation = new Activation();
            profile.setActivation(activation);
            ActivationProperty prop = new ActivationProperty();
            activation.setProperty(prop);
            prop.setName("native");
            profile.addProperty("quarkus.package.type", "native");
            BuildBase buildBase = new BuildBase();
            profile.setBuild(buildBase);
            buildBase.addPlugin(this.createFailsafeConfig(testConfig, depsToScan, true));
            Plugin plugin = new Plugin();
            buildBase.addPlugin(plugin);
            plugin.setGroupId("io.quarkus");
            plugin.setArtifactId("quarkus-maven-plugin");
            plugin.setVersion(this.quarkusCore.getVersionProperty());
            PluginExecution exec = new PluginExecution();
            plugin.addExecution(exec);
            exec.setId("native-image");
            exec.addGoal("build");
            Xpp3Dom config = new Xpp3Dom("configuration");
            exec.setConfiguration((Object)config);
            if (testConfig.isSkip()) {
                Xpp3Dom skip = new Xpp3Dom("skip");
                config.addChild(skip);
                skip.setValue("true");
            }
            Xpp3Dom appArtifact = new Xpp3Dom("appArtifact");
            config.addChild(appArtifact);
            appArtifact.setValue(testArtifact.getGroupId() + ":" + testArtifact.getArtifactId() + ":" + testArtifactVersion);
        }
        Utils.disablePlugin(pom, "maven-jar-plugin", "default-jar");
        Utils.disablePlugin(pom, "maven-source-plugin", "attach-sources");
        if (testConfig.isPackageApplication()) {
            this.addQuarkusBuildConfig(pom, appArtifactDep);
        }
        GeneratePlatformProjectMojo.persistPom(pom);
        if (testConfig.getTransformWith() != null) {
            Path xsl = Paths.get(testConfig.getTransformWith(), new String[0]).toAbsolutePath();
            if (!Files.exists(xsl, new LinkOption[0])) {
                throw new MojoExecutionException("Failed to locate " + xsl);
            }
            File transformedPom = new File(pomXml.getParent(), "transformed-pom.xml");
            StreamSource xslt = new StreamSource(xsl.toFile());
            StreamSource xml = new StreamSource(pomXml);
            StreamResult out = new StreamResult(transformedPom);
            TransformerFactory factory = this.getTransformerFactory();
            try {
                Transformer transformer = factory.newTransformer(xslt);
                transformer.transform(xml, out);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to transform " + pomXml + " with " + xsl, e);
            }
            try {
                Files.move(transformedPom.toPath(), pomXml.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to move " + transformedPom + " to " + pomXml, (Exception)e);
            }
        }
        Path seed = pom.getProjectDirectory().toPath().resolve("src").resolve("main").resolve("resources").resolve("seed");
        try {
            Files.createDirectories(seed.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(seed, new OpenOption[0]);){
                writer.write("seed");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create file " + seed, (Exception)e);
        }
        if (!testConfig.getCopyTasks().isEmpty()) {
            for (PlatformMemberTestConfig.Copy copy : testConfig.getCopyTasks()) {
                Path src = Path.of(copy.getSrc(), new String[0]);
                if (!Files.exists(src, new LinkOption[0])) {
                    throw new MojoExecutionException("Failed to generate test module for " + testConfig.getArtifact() + ": couldn't copy " + copy.getSrc() + " to " + copy.getDestination() + " because " + src + " does not exist");
                }
                try {
                    IoUtils.copy((Path)src, (Path)Path.of(copy.getDestination(), new String[0]));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy " + src + " to " + Path.of(copy.getDestination(), new String[0]), (Exception)e);
                }
            }
        }
    }

    private void addQuarkusBuildConfig(Model pom, Dependency appArtifactDep) {
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.quarkusCore.originalBomCoords().getGroupId());
        plugin.setArtifactId("quarkus-maven-plugin");
        plugin.setVersion(this.quarkusCore.getVersionProperty());
        PluginExecution e = new PluginExecution();
        plugin.addExecution(e);
        e.addGoal("build");
        Xpp3Dom config = new Xpp3Dom("configuration");
        e.setConfiguration((Object)config);
        Xpp3Dom appArtifact = new Xpp3Dom("appArtifact");
        StringBuilder sb = new StringBuilder();
        sb.append(appArtifactDep.getGroupId()).append(':').append(appArtifactDep.getArtifactId()).append(':');
        if (appArtifactDep.getClassifier() != null && !appArtifactDep.getClassifier().isEmpty()) {
            sb.append(appArtifactDep.getClassifier()).append(':').append(appArtifactDep.getType()).append(':');
        }
        sb.append(appArtifactDep.getVersion());
        appArtifact.setValue(sb.toString());
        config.addChild(appArtifact);
    }

    private String getTestArtifactVersion(String artifactGroupId, String version) {
        String versionProp;
        if (this.pomPropsByValues.isEmpty()) {
            this.mapProjectProperties(this.project.getOriginalModel().getProperties());
            for (Profile p : this.project.getActiveProfiles()) {
                this.mapProjectProperties(p.getProperties());
            }
        }
        if ((versionProp = this.pomPropsByValues.get(version)) == null) {
            return version;
        }
        if (versionProp.isEmpty() && (versionProp = this.pomPropsByValues.get(artifactGroupId + ":" + version)) == null) {
            return version;
        }
        return "${" + versionProp + "}";
    }

    private void mapProjectProperties(Properties props) {
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String groupId;
            String name = prop.getKey().toString();
            String value = prop.getValue().toString();
            String previous = this.pomPropsByValues.putIfAbsent(value, name);
            if (previous == null || (groupId = this.getTestArtifactGroupIdForProperty(name)) == null) continue;
            if (previous.isEmpty()) {
                this.pomPropsByValues.putIfAbsent(groupId + ":" + value, name);
                continue;
            }
            String previousGroupId = this.getTestArtifactGroupIdForProperty(previous);
            if (previousGroupId == null) {
                this.pomPropsByValues.putIfAbsent(value, name);
            }
            this.pomPropsByValues.put(value, "");
            this.pomPropsByValues.put(previousGroupId + ":" + value, previous);
            this.pomPropsByValues.putIfAbsent(groupId + ":" + value, name);
        }
    }

    private String getTestArtifactGroupIdForProperty(String versionProperty) {
        for (String s : this.pomLines()) {
            int coordsStart;
            int coordsEnd = s.indexOf(versionProperty);
            if (coordsEnd < 0 || (coordsEnd = s.indexOf("</artifact>", coordsEnd)) < 0 || (coordsStart = s.indexOf("<artifact>")) < 0) continue;
            return ArtifactCoords.fromString((String)s.substring(coordsStart += "<artifact>".length(), coordsEnd)).getGroupId();
        }
        return null;
    }

    private void addDependencies(Model pom, List<String> dependencies, boolean test) {
        if (!dependencies.isEmpty()) {
            for (String depStr : dependencies) {
                ArtifactCoords coords = ArtifactCoords.fromString((String)depStr);
                Dependency dep = new Dependency();
                dep.setGroupId(coords.getGroupId());
                dep.setArtifactId(coords.getArtifactId());
                if (!coords.getClassifier().isEmpty()) {
                    dep.setClassifier(coords.getClassifier());
                }
                if (!coords.getType().equals("jar")) {
                    dep.setType(coords.getType());
                }
                if (!this.universalBomDepKeys.contains(new ArtifactKey(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType()))) {
                    dep.setVersion(coords.getVersion());
                }
                if (test) {
                    dep.setScope("test");
                }
                pom.addDependency(dep);
            }
        }
    }

    private void addGroupsConfig(PlatformMemberTestConfig testConfig, Xpp3Dom config, boolean nativeTest) {
        String groupsStr = testConfig.getGroups();
        if (nativeTest && testConfig.getNativeGroups() != null) {
            groupsStr = testConfig.getNativeGroups();
        }
        if (groupsStr == null) {
            return;
        }
        Xpp3Dom groups = new Xpp3Dom("groups");
        config.addChild(groups);
        groups.setValue(groupsStr);
    }

    private static void addIncludesExcludesConfig(PlatformMemberTestConfig testConfig, Xpp3Dom config, boolean nativeTest) {
        if (nativeTest) {
            if (!testConfig.getNativeIncludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "includes", "include", testConfig.getNativeIncludes());
            }
            if (!testConfig.getNativeExcludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "excludes", "exclude", testConfig.getNativeExcludes());
            }
        } else {
            if (!testConfig.getJvmIncludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "includes", "include", testConfig.getJvmIncludes());
            }
            if (!testConfig.getJvmExcludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "excludes", "exclude", testConfig.getJvmExcludes());
            }
        }
    }

    private static void addElements(Xpp3Dom config, String wrapperName, String elementName, List<String> values) {
        Xpp3Dom includes = new Xpp3Dom(wrapperName);
        config.addChild(includes);
        for (String s : values) {
            Xpp3Dom e = new Xpp3Dom(elementName);
            e.setValue(s);
            includes.addChild(e);
        }
    }

    private TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        if (this.transformerFactory == null) {
            TransformerFactory factory;
            this.transformerFactory = factory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    private Plugin createFailsafeConfig(PlatformMemberTestConfig testConfig, Xpp3Dom depsToScan, boolean nativeTest) {
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-failsafe-plugin");
        Xpp3Dom config = new Xpp3Dom("configuration");
        plugin.setConfiguration((Object)config);
        config.addChild(depsToScan);
        plugin.setConfiguration((Object)config);
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.addGoal("integration-test");
        exec.addGoal("verify");
        config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        if (nativeTest) {
            Xpp3Dom nativeImagePath = new Xpp3Dom("native.image.path");
            GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties").addChild(nativeImagePath);
            nativeImagePath.setValue("${project.build.directory}/${project.build.finalName}-runner");
        }
        if (!testConfig.getSystemProperties().isEmpty()) {
            this.addSystemProperties(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties"), testConfig.getSystemProperties());
        }
        if (nativeTest) {
            if (!testConfig.getNativeSystemProperties().isEmpty()) {
                this.addSystemProperties(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties"), testConfig.getNativeSystemProperties());
            }
        } else if (!testConfig.getJvmSystemProperties().isEmpty()) {
            this.addSystemProperties(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties"), testConfig.getJvmSystemProperties());
        }
        this.addGroupsConfig(testConfig, config, nativeTest);
        GeneratePlatformProjectMojo.addIncludesExcludesConfig(testConfig, config, nativeTest);
        return plugin;
    }

    private static Xpp3Dom getOrCreateChild(Xpp3Dom parent, String child) {
        Xpp3Dom e = parent.getChild(child);
        if (e == null) {
            e = new Xpp3Dom(child);
            parent.addChild(e);
        }
        return e;
    }

    private void addSystemProperties(Xpp3Dom sysProps, Map<String, String> props) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            Xpp3Dom e = new Xpp3Dom(entry.getKey());
            e.setValue(entry.getValue());
            sysProps.addChild(e);
        }
    }

    private void generateUniversalPlatformModule(Model parentPom) throws MojoExecutionException {
        String artifactIdBase;
        Artifact bomArtifact = this.getUniversalBomArtifact();
        String moduleName = artifactIdBase = GeneratePlatformProjectMojo.getArtifactIdBase(bomArtifact.getArtifactId());
        Model pom = Utils.newModel();
        pom.setArtifactId(artifactIdBase + "-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName(moduleName) + " - Parent");
        parentPom.addModule(moduleName);
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        this.generatePlatformDescriptorModule(new ArtifactCoords(bomArtifact.getGroupId(), PlatformArtifacts.ensureCatalogArtifactId((String)bomArtifact.getArtifactId()), bomArtifact.getVersion(), "json", bomArtifact.getVersion()), pom, true, true, null, null);
        GeneratePlatformProjectMojo.persistPom(pom);
        GeneratePlatformProjectMojo.persistPom(parentPom);
        this.generateUniversalPlatformBomModule(pom);
        if (this.platformConfig.getUniversal().isGeneratePlatformProperties()) {
            PlatformMemberConfig tmpConfig = new PlatformMemberConfig();
            tmpConfig.setBom(this.platformConfig.getUniversal().getBom());
            PlatformMemberImpl tmp = new PlatformMemberImpl(tmpConfig);
            tmp.baseModel = pom;
            this.generatePlatformPropertiesModule(tmp, false);
        }
        if (this.platformConfig.getUniversal().isSkipInstall()) {
            Utils.skipInstallAndDeploy(pom);
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    /*
     * WARNING - void declaration
     */
    private void generatePlatformDescriptorModule(ArtifactCoords descriptorCoords, Model parentPom, boolean addPlatformReleaseConfig, boolean copyQuarkusCoreMetadata, AttachedMavenPluginConfig attachedPlugin, PlatformMember member) throws MojoExecutionException {
        String moduleName = "descriptor";
        parentPom.addModule("descriptor");
        Path moduleDir = parentPom.getProjectDirectory().toPath().resolve("descriptor");
        Model pom = Utils.newModel();
        if (!descriptorCoords.getGroupId().equals(ModelUtils.getGroupId((Model)parentPom))) {
            pom.setGroupId(descriptorCoords.getGroupId());
        }
        pom.setArtifactId(descriptorCoords.getArtifactId());
        if (!descriptorCoords.getVersion().equals(ModelUtils.getVersion((Model)parentPom))) {
            pom.setVersion(descriptorCoords.getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform Descriptor");
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(moduleDir.relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        this.addResourcesPlugin(pom, true);
        Build build = pom.getBuild();
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("generate-platform-descriptor");
        Xpp3Dom config = new Xpp3Dom("configuration");
        Xpp3Dom bomArtifactId = new Xpp3Dom("bomArtifactId");
        String bomArtifact = PlatformArtifacts.ensureBomArtifactId((String)descriptorCoords.getArtifactId());
        bomArtifactId.setValue(bomArtifact);
        config.addChild(bomArtifactId);
        Xpp3Dom e = new Xpp3Dom("quarkusCoreVersion");
        e.setValue(this.quarkusCore.getVersionProperty());
        config.addChild(e);
        if (this.platformConfig.hasUpstreamQuarkusCoreVersion()) {
            e = new Xpp3Dom("upstreamQuarkusCoreVersion");
            e.setValue(this.platformConfig.getUpstreamQuarkusCoreVersion());
            config.addChild(e);
        }
        if (addPlatformReleaseConfig) {
            Xpp3Dom stackConfig = new Xpp3Dom("platformRelease");
            config.addChild(stackConfig);
            Xpp3Dom platformKey = new Xpp3Dom("platformKey");
            stackConfig.addChild(platformKey);
            e = new Xpp3Dom("stream");
            e.setValue("${platform.stream}");
            stackConfig.addChild(e);
            e = new Xpp3Dom("version");
            e.setValue("${platform.release}");
            stackConfig.addChild(e);
            Xpp3Dom membersConfig = new Xpp3Dom("members");
            stackConfig.addChild(membersConfig);
            if (descriptorCoords.getGroupId().equals(this.getUniversalBomArtifact().getGroupId()) && descriptorCoords.getArtifactId().equals(PlatformArtifacts.ensureCatalogArtifactId((String)this.getUniversalBomArtifact().getArtifactId()))) {
                platformKey.setValue("${project.groupId}");
                this.addMemberDescriptorConfig(pom, membersConfig, descriptorCoords);
            } else {
                platformKey.setValue("${platform.key}");
                for (PlatformMember platformMember : this.members.values()) {
                    if (platformMember.config().isHidden()) continue;
                    this.addMemberDescriptorConfig(pom, membersConfig, platformMember.stackDescriptorCoords());
                }
            }
        }
        ObjectNode overrides = null;
        if (copyQuarkusCoreMetadata) {
            JsonNode jsonNode;
            JsonNode jsonNode2;
            overrides = CatalogMapperHelper.mapper().createObjectNode();
            Artifact bom = this.quarkusCore.originalBomCoords();
            Path jsonPath = this.artifactResolver().resolve((Artifact)new DefaultArtifact(bom.getGroupId(), bom.getArtifactId() + "-quarkus-platform-descriptor", bom.getVersion(), "json", bom.getVersion())).getArtifact().getFile().toPath();
            try (BufferedReader bufferedReader = Files.newBufferedReader(jsonPath);){
                jsonNode2 = CatalogMapperHelper.mapper().readTree((Reader)bufferedReader);
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Failed to deserialize " + jsonPath, (Exception)iOException);
            }
            JsonNode jsonNode3 = jsonNode2.get("metadata");
            if (jsonNode3 != null) {
                JsonNode jsonNode4;
                JsonNode jsonNode5;
                if (attachedPlugin != null && (jsonNode5 = jsonNode3.get("project")) != null && (jsonNode4 = jsonNode5.get("properties")) != null) {
                    ObjectNode jo = (ObjectNode)jsonNode4;
                    ArtifactCoords pluginCoords = ArtifactCoords.fromString((String)attachedPlugin.getTargetPluginCoords());
                    String pluginGroupId = pluginCoords.getGroupId().equals(ModelUtils.getGroupId((Model)pom)) ? "${project.groupId}" : pluginCoords.getGroupId();
                    jo.replace("maven-plugin-groupId", (JsonNode)jo.textNode(pluginGroupId));
                    jo.replace("maven-plugin-version", (JsonNode)jo.textNode(GeneratePlatformProjectMojo.getDependencyVersion(pom, pluginCoords)));
                }
                overrides.set("metadata", jsonNode3);
            }
            if ((jsonNode = jsonNode2.get("categories")) != null) {
                overrides.set("categories", jsonNode);
            }
        }
        PlatformDescriptorGeneratorConfig descrGen = this.platformConfig.getDescriptorGenerator();
        if (member != null) {
            JsonNode metadata;
            pom.getProperties().setProperty(MEMBER_LAST_BOM_UPDATE_PROP, member.lastUpdatedBom().getGroupId() + ":" + member.lastUpdatedBom().getArtifactId() + ":" + member.lastUpdatedBom().getVersion());
            if (overrides == null) {
                overrides = CatalogMapperHelper.mapper().createObjectNode();
            }
            if ((metadata = overrides.get("metadata")) == null) {
                metadata = overrides.putObject("metadata");
            }
            ObjectNode objectNode = (ObjectNode)metadata;
            objectNode.set(LAST_BOM_UPDATE, (JsonNode)objectNode.textNode("${member.last-bom-update}"));
            List list = member.getExtensionGroupIds();
            if (!list.isEmpty()) {
                Xpp3Dom xpp3Dom = new Xpp3Dom("processGroupIds");
                config.addChild(xpp3Dom);
                for (String groupId : list) {
                    Xpp3Dom processGroupId = new Xpp3Dom("groupId");
                    processGroupId.setValue(groupId);
                    xpp3Dom.addChild(processGroupId);
                }
            }
            this.addExtensionDependencyCheck(member.config().getRedHatExtensionDependencyCheck(), config);
        } else {
            this.addExtensionDependencyCheck(this.platformConfig.getUniversal().getRedHatExtensionDependencyCheck(), config);
        }
        if (descrGen != null && !descrGen.ignoredArtifacts.isEmpty()) {
            Xpp3Dom ignoredArtifacts = new Xpp3Dom("ignoredArtifacts");
            config.addChild(ignoredArtifacts);
            for (String string : descrGen.ignoredArtifacts) {
                Xpp3Dom xpp3Dom = new Xpp3Dom("artifact");
                xpp3Dom.setValue(string);
                ignoredArtifacts.addChild(xpp3Dom);
            }
        }
        StringJoiner metadataOverrideFiles = new StringJoiner(",");
        if (overrides != null) {
            Path path = moduleDir.resolve("src").resolve("main").resolve("resources").resolve("overrides.json");
            try {
                CatalogMapperHelper.serialize((Object)overrides, (Path)path);
            }
            catch (Exception exception) {
                throw new MojoExecutionException("Failed to serialize metadata to " + path, exception);
            }
            Path path2 = moduleDir.resolve("target").resolve("classes").resolve(path.getFileName());
            metadataOverrideFiles.add("${project.basedir}/" + moduleDir.relativize(path2));
        }
        if (descrGen != null && descrGen.overridesFile != null) {
            void var23_61;
            String[] stringArray = descrGen.overridesFile.split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var23_61 < n) {
                String path = stringArray[var23_61];
                metadataOverrideFiles.add("${project.basedir}/" + moduleDir.relativize(Paths.get(path.trim(), new String[0])));
                ++var23_61;
            }
        }
        if (member == null) {
            ArrayList<String> arrayList = new ArrayList<String>(0);
            for (PlatformMember platformMember : this.members.values()) {
                for (String s : platformMember.config().getMetadataOverrideFiles()) {
                    this.addMetadataOverrideFile(metadataOverrideFiles, moduleDir, Paths.get(s, new String[0]));
                }
                arrayList.addAll(platformMember.config().getMetadataOverrideArtifacts());
            }
            this.addMetadataOverrideArtifacts(config, arrayList);
        } else {
            for (String string : member.config().getMetadataOverrideFiles()) {
                this.addMetadataOverrideFile(metadataOverrideFiles, moduleDir, Paths.get(string, new String[0]));
            }
            this.addMetadataOverrideArtifacts(config, member.config().getMetadataOverrideArtifacts());
        }
        if (metadataOverrideFiles.length() > 0) {
            e = new Xpp3Dom("overridesFile");
            e.setValue(metadataOverrideFiles.toString());
            config.addChild(e);
        }
        if (descrGen != null) {
            if (descrGen.skipCategoryCheck) {
                e = new Xpp3Dom("skipCategoryCheck");
                e.setValue("true");
                config.addChild(e);
            }
            if (descrGen.resolveDependencyManagement) {
                e = new Xpp3Dom("resolveDependencyManagement");
                e.setValue("true");
                config.addChild(e);
            }
        }
        plugin.setConfiguration((Object)config);
        Dependency dependency = new Dependency();
        dependency.setGroupId(descriptorCoords.getGroupId());
        dependency.setArtifactId(bomArtifact);
        dependency.setType("pom");
        dependency.setVersion(GeneratePlatformProjectMojo.getDependencyVersion(pom, descriptorCoords));
        pom.addDependency(dependency);
        if (member != null && member.config().isHidden()) {
            Utils.skipInstallAndDeploy(pom);
        }
        Path path = moduleDir.resolve("pom.xml");
        pom.setPomFile(path.toFile());
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void addExtensionDependencyCheck(RedHatExtensionDependencyCheck depCheckConfig, Xpp3Dom config) {
        if (depCheckConfig != null && depCheckConfig.isEnabled() && depCheckConfig.getVersionPattern() != null) {
            Xpp3Dom depCheck = new Xpp3Dom("extensionDependencyCheck");
            config.addChild(depCheck);
            Xpp3Dom e = new Xpp3Dom("versionPattern");
            e.setValue(depCheckConfig.getVersionPattern());
            depCheck.addChild(e);
            if (depCheckConfig.getCheckDepth() != Integer.MAX_VALUE) {
                e = new Xpp3Dom("checkDepth");
                e.setValue(String.valueOf(depCheckConfig.getCheckDepth()));
                depCheck.addChild(e);
            }
        }
    }

    private void addMetadataOverrideArtifacts(Xpp3Dom config, List<String> overrideArtifacts) {
        if (overrideArtifacts.isEmpty()) {
            return;
        }
        Xpp3Dom artifacts = new Xpp3Dom("metadataOverrideArtifacts");
        config.addChild(artifacts);
        for (String s : overrideArtifacts) {
            Xpp3Dom e = new Xpp3Dom("artifact");
            e.setValue(s);
            artifacts.addChild(e);
        }
    }

    private void addMetadataOverrideFile(StringJoiner metadataOverrideFiles, Path moduleDir, Path file) throws MojoExecutionException {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new MojoExecutionException("Configured metadata overrides file " + file + " does not exist");
        }
        metadataOverrideFiles.add("${project.basedir}/" + moduleDir.relativize(file));
    }

    private void addMemberDescriptorConfig(Model pom, Xpp3Dom membersConfig, ArtifactCoords memberCoords) {
        Xpp3Dom e = new Xpp3Dom("member");
        Object value = memberCoords.getGroupId().equals(ModelUtils.getGroupId((Model)pom)) && memberCoords.getVersion().equals(ModelUtils.getVersion((Model)pom)) ? "${project.groupId}:" + memberCoords.getArtifactId() + ":${project.version}:json:${project.version}" : memberCoords.toString();
        e.setValue((String)value);
        membersConfig.addChild(e);
    }

    private void generatePlatformPropertiesModule(PlatformMemberImpl member, boolean addPlatformReleaseConfig) throws MojoExecutionException {
        ArtifactCoords propertiesCoords = member.propertiesCoords();
        Model parentPom = member.baseModel;
        String moduleName = "properties";
        parentPom.addModule("properties");
        Path moduleDir = parentPom.getProjectDirectory().toPath().resolve("properties");
        Model pom = Utils.newModel();
        if (!propertiesCoords.getGroupId().equals(ModelUtils.getGroupId((Model)parentPom))) {
            pom.setGroupId(propertiesCoords.getGroupId());
        }
        pom.setArtifactId(propertiesCoords.getArtifactId());
        if (!propertiesCoords.getVersion().equals(ModelUtils.getVersion((Model)parentPom))) {
            pom.setVersion(propertiesCoords.getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform Properties");
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(moduleDir.relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        DependencyManagement dm = new DependencyManagement();
        pom.setDependencyManagement(dm);
        Dependency bom = new Dependency();
        dm.addDependency(bom);
        bom.setGroupId(propertiesCoords.getGroupId());
        bom.setArtifactId(propertiesCoords.getArtifactId().substring(0, propertiesCoords.getArtifactId().length() - "-quarkus-platform-properties".length()));
        bom.setVersion(GeneratePlatformProjectMojo.getDependencyVersion(pom, propertiesCoords));
        bom.setType("pom");
        bom.setScope("import");
        this.addResourcesPlugin(pom, true);
        Build build = pom.getBuild();
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("platform-properties");
        OrderedProperties props = new OrderedProperties.OrderedPropertiesBuilder().withOrdering(String.CASE_INSENSITIVE_ORDER).withSuppressDateInComment(true).build();
        if (member.config().getBom() != null) {
            List originalDm;
            PlatformMemberImpl srcMember = this.platformConfig.getUniversal().getBom().equals(member.config().getBom()) ? this.quarkusCore : member;
            try {
                originalDm = this.nonWorkspaceResolver().resolveDescriptor(srcMember.originalBomCoords()).getManagedDependencies();
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to resolve " + member.originalBomCoords(), (Exception)((Object)e));
            }
            Properties tmp = new Properties();
            for (org.eclipse.aether.graph.Dependency dependency : originalDm) {
                Artifact a = dependency.getArtifact();
                if (!a.getExtension().equals("properties") || !a.getArtifactId().endsWith("-quarkus-platform-properties") || !a.getArtifactId().startsWith(srcMember.originalBomCoords().getArtifactId()) || !a.getGroupId().equals(srcMember.originalBomCoords().getGroupId()) || !a.getVersion().equals(srcMember.originalBomCoords().getVersion())) continue;
                try (BufferedReader reader = Files.newBufferedReader(this.nonWorkspaceResolver.resolve(a).getArtifact().getFile().toPath());){
                    tmp.load(reader);
                    break;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to resolve " + a, e);
                }
            }
            for (Map.Entry entry : tmp.entrySet()) {
                String name = entry.getKey().toString();
                pom.getProperties().setProperty(name, entry.getValue().toString());
                props.setProperty(name, "${" + name + "}");
            }
        }
        if (addPlatformReleaseConfig) {
            Xpp3Dom config = new Xpp3Dom("configuration");
            Xpp3Dom stackConfig = new Xpp3Dom("platformRelease");
            config.addChild(stackConfig);
            Xpp3Dom e = new Xpp3Dom("platformKey");
            e.setValue("${platform.key}");
            stackConfig.addChild(e);
            e = new Xpp3Dom("stream");
            e.setValue("${platform.stream}");
            stackConfig.addChild(e);
            e = new Xpp3Dom("version");
            e.setValue("${platform.release}");
            stackConfig.addChild(e);
            Xpp3Dom membersConfig = new Xpp3Dom("members");
            stackConfig.addChild(membersConfig);
            Iterator<PlatformMemberImpl> iterator = this.members.values().iterator();
            StringBuilder buf = new StringBuilder();
            while (iterator.hasNext()) {
                PlatformMember m = iterator.next();
                if (m.config().isHidden()) continue;
                if (buf.length() > 0) {
                    buf.append(",");
                }
                e = new Xpp3Dom("member");
                membersConfig.addChild(e);
                e.setValue(m.stackDescriptorCoords().toString());
                ArtifactCoords bomCoords = PlatformArtifacts.ensureBomArtifact((ArtifactCoords)m.stackDescriptorCoords());
                if (bomCoords.getGroupId().equals(this.project.getGroupId()) && bomCoords.getVersion().equals(this.project.getVersion())) {
                    buf.append("${project.groupId}:").append(bomCoords.getArtifactId()).append("::pom:${project.version}");
                    continue;
                }
                buf.append(bomCoords);
            }
            props.setProperty("platform.release-info@${platform.key}$${platform.stream}#${platform.release}", buf.toString());
        }
        if (member.config().isHidden()) {
            Utils.skipInstallAndDeploy(pom);
        }
        Path pomXml = moduleDir.resolve("pom.xml");
        pom.setPomFile(pomXml.toFile());
        GeneratePlatformProjectMojo.persistPom(pom);
        Path dir = pom.getPomFile().toPath().getParent().resolve("src").resolve("main").resolve("resources");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directory " + dir, (Exception)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(dir.resolve("platform-properties.properties"), new OpenOption[0]);){
            props.store((Writer)writer, pom.getName());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist " + dir.resolve("platform-properties.properties"), (Exception)e);
        }
    }

    private void addResourcesPlugin(Model pom, boolean filtering) {
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-resources-plugin");
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("resources");
        if (filtering) {
            Resource r = new Resource();
            r.setDirectory("src/main/resources");
            r.setFiltering(true);
            build.setResources(Collections.singletonList(r));
        }
    }

    private PluginDescriptor pluginDescriptor() {
        return this.pluginDescr == null ? (this.pluginDescr = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor")) : this.pluginDescr;
    }

    private void generateUniversalPlatformBomModule(Model parentPom) throws MojoExecutionException {
        PlatformBomComposer platformBomComposer;
        Artifact bomArtifact = this.getUniversalBomArtifact();
        PlatformBomGeneratorConfig bomGen = this.platformConfig.getBomGenerator();
        PlatformBomConfig.Builder configBuilder = PlatformBomConfig.builder().artifactResolver(this.artifactResolver()).pomResolver(PomSource.of((Artifact)bomArtifact)).includePlatformProperties(this.platformConfig.getUniversal().isGeneratePlatformProperties()).platformBom(bomArtifact).enableNonMemberQuarkiverseExtensions(bomGen.enableNonMemberQuarkiverseExtensions);
        for (PlatformMember platformMember : this.members.values()) {
            configBuilder.addMember(platformMember);
        }
        if (bomGen != null) {
            if (bomGen.enforcedDependencies != null) {
                for (String string : bomGen.enforcedDependencies) {
                    ArtifactCoords coords = ArtifactCoords.fromString((String)string);
                    configBuilder.enforce((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
                }
            }
            if (bomGen.excludedDependencies != null) {
                for (String string : bomGen.excludedDependencies) {
                    configBuilder.exclude(ArtifactKey.fromString((String)string));
                }
            }
            if (bomGen.excludedGroups != null) {
                for (String string : bomGen.excludedGroups) {
                    configBuilder.excludeGroupId(string);
                }
            }
            configBuilder.versionConstraintPreference(bomGen.versionConstraintPreferences);
            configBuilder.notPreferredQuarkusBomConstraint(bomGen.notPreferredQuarkusBomConstraint);
        }
        PlatformBomConfig config = configBuilder.build();
        try {
            platformBomComposer = new PlatformBomComposer(config, (MessageWriter)new MojoMessageWriter(this.getLog()));
        }
        catch (BomDecomposerException e) {
            throw new MojoExecutionException("Failed to generate the platform BOM", (Exception)((Object)e));
        }
        this.universalGeneratedBom = platformBomComposer.platformBom();
        Model baseModel = this.project.getModel().clone();
        baseModel.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform BOM");
        String moduleName = "bom";
        parentPom.addModule("bom");
        this.universalPlatformBomXml = parentPom.getProjectDirectory().toPath().resolve("bom").resolve("pom.xml");
        Model pom = PlatformBomUtils.toPlatformModel((DecomposedBom)this.universalGeneratedBom, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        this.addReleaseProfile(pom);
        try {
            Files.createDirectories(this.universalPlatformBomXml.getParent(), new FileAttribute[0]);
            ModelUtils.persistModel((Path)this.universalPlatformBomXml, (Model)pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist generated BOM to " + this.universalPlatformBomXml, (Exception)e);
        }
        for (ProjectRelease r : this.universalGeneratedBom.releases()) {
            for (ProjectDependency d : r.dependencies()) {
                this.universalBomDepKeys.add(d.key());
            }
        }
    }

    private void addExtraArtifact(Xpp3Dom extras, String coords) {
        Xpp3Dom artifact = new Xpp3Dom("artifact");
        artifact.setValue(coords);
        extras.addChild(artifact);
    }

    private Artifact getUniversalBomArtifact() {
        return this.universalBom == null ? (this.universalBom = GeneratePlatformProjectMojo.toPomArtifact(this.platformConfig.getUniversal().getBom())) : this.universalBom;
    }

    private PlatformCatalogResolver catalogResolver() throws MojoExecutionException {
        return this.catalogs == null ? (this.catalogs = new PlatformCatalogResolver(this.mavenArtifactResolver())) : this.catalogs;
    }

    private MavenArtifactResolver nonWorkspaceResolver() throws MojoExecutionException {
        if (this.nonWorkspaceResolver != null) {
            return this.nonWorkspaceResolver;
        }
        try {
            this.nonWorkspaceResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setWorkspaceDiscovery(false)).build();
            return this.nonWorkspaceResolver;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }

    private PlatformReleaseConfig releaseConfig() {
        if (this.platformReleaseConfig == null) {
            PlatformReleaseConfig tmp;
            PlatformReleaseConfig platformReleaseConfig = tmp = this.platformConfig.getRelease() == null ? new PlatformReleaseConfig() : this.platformConfig.getRelease();
            if (tmp.getPlatformKey() == null) {
                tmp.setPlatformKey(this.project.getGroupId());
            }
            if (tmp.getStream() == null) {
                String projectVersion = this.project.getVersion();
                int microDot = projectVersion.lastIndexOf(46);
                while (microDot > 0 && !Character.isDigit(projectVersion.charAt(microDot + 1))) {
                    microDot = projectVersion.lastIndexOf(46, microDot - 1);
                }
                tmp.setStream(microDot < 0 ? projectVersion : projectVersion.substring(0, microDot));
            }
            if (tmp.getVersion() == null) {
                tmp.setVersion(this.project.getVersion());
            }
            this.platformReleaseConfig = tmp;
        }
        return this.platformReleaseConfig;
    }

    private void resetResolver() {
        this.mavenResolver = null;
        this.artifactResolver = null;
    }

    private ArtifactResolver artifactResolver() throws MojoExecutionException {
        if (this.mavenResolver == null) {
            this.artifactResolver = null;
        }
        return this.artifactResolver == null ? (this.artifactResolver = ArtifactResolverProvider.get((MavenArtifactResolver)this.mavenArtifactResolver(), null)) : this.artifactResolver;
    }

    private MavenArtifactResolver mavenArtifactResolver() throws MojoExecutionException {
        if (this.mavenResolver != null) {
            return this.mavenResolver;
        }
        try {
            this.mavenResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setCurrentProject(new File(this.outputDir, "pom.xml").toString())).build();
            return this.mavenResolver;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }

    private static String getDependencyVersion(Model pom, ArtifactCoords coords) {
        return ModelUtils.getVersion((Model)pom).equals(coords.getVersion()) ? "${project.version}" : coords.getVersion();
    }

    private static ArtifactKey toKey(Artifact a) {
        return new ArtifactKey(a.getGroupId(), a.getArtifactId());
    }

    private static DefaultArtifact toPomArtifact(String coords) {
        return GeneratePlatformProjectMojo.toPomArtifact(ArtifactCoords.fromString((String)coords));
    }

    private static DefaultArtifact toPomArtifact(ArtifactCoords coords) {
        return new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), null, "pom", coords.getVersion());
    }

    private static Artifact toAetherArtifact(String coords) {
        ArtifactCoords a = ArtifactCoords.fromString((String)coords);
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private static void persistPom(Model pom) throws MojoExecutionException {
        try {
            pom.getPomFile().getParentFile().mkdirs();
            ModelUtils.persistModel((Path)pom.getPomFile().toPath(), (Model)pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate the platform BOM " + pom.getPomFile(), (Exception)e);
        }
    }

    private static String getArtifactIdBase(Model pom) {
        return GeneratePlatformProjectMojo.getArtifactIdBase(pom.getArtifactId());
    }

    private static String getArtifactIdBase(String s) {
        int i = s.lastIndexOf(45);
        return i > 0 ? s.substring(0, i) : s;
    }

    private static String getNameBase(Model pom) {
        String s = pom.getName();
        int i = s.lastIndexOf(45);
        return i > 0 ? s.substring(0, i + 1) : s;
    }

    private static String artifactIdToName(String artifactId) {
        String[] parts = artifactId.split("-");
        StringBuilder buf = new StringBuilder(artifactId.length() + parts.length);
        String part = parts[0];
        buf.append(Character.toUpperCase(part.charAt(0))).append(part, 1, part.length());
        for (int i = 1; i < parts.length; ++i) {
            part = parts[i];
            buf.append(' ').append(Character.toUpperCase(part.charAt(0))).append(part, 1, part.length());
        }
        return buf.toString();
    }

    private class PlatformMemberImpl
    implements PlatformMember {
        final PlatformMemberConfig config;
        private final Artifact originalBomCoords;
        private Artifact generatedBomCoords;
        private ArtifactCoords descriptorCoords;
        private ArtifactCoords propertiesCoords;
        private ArtifactCoords stackDescriptorCoords;
        private ArtifactKey key;
        private Model baseModel;
        private DecomposedBom originalBom;
        private DecomposedBom generatedBom;
        private Model generatedBomModel;
        private Path generatedPomFile;
        private String versionProperty;
        private Artifact prevBomRelease;
        private boolean bomChanged;
        private List<org.eclipse.aether.graph.Dependency> inputConstraints;

        PlatformMemberImpl(PlatformMemberConfig config) {
            this.config = config;
            this.originalBomCoords = config.getBom() == null ? null : GeneratePlatformProjectMojo.toPomArtifact(config.getBom());
        }

        public PlatformMemberConfig config() {
            return this.config;
        }

        public List<String> getExtensionGroupIds() {
            if (!this.config.getExtensionGroupIds().isEmpty()) {
                return this.config.getExtensionGroupIds();
            }
            if (this.originalBomCoords() != null) {
                return List.of(this.originalBomCoords().getGroupId());
            }
            return List.of();
        }

        public List<String> getOwnGroupIds() {
            if (!this.config.getOwnGroupIds().isEmpty()) {
                return this.config.getOwnGroupIds();
            }
            return this.getExtensionGroupIds();
        }

        public Artifact previousLastUpdatedBom() {
            String prev;
            if (this.prevBomRelease == null && (prev = this.config.getRelease().getLastDetectedBomUpdate()) != null) {
                this.prevBomRelease = GeneratePlatformProjectMojo.toPomArtifact(prev);
            }
            return this.prevBomRelease;
        }

        public Artifact lastUpdatedBom() {
            return this.bomChanged || this.previousLastUpdatedBom() == null ? this.generatedBomCoords() : this.previousLastUpdatedBom();
        }

        public Artifact originalBomCoords() {
            return this.originalBomCoords;
        }

        public Artifact generatedBomCoords() {
            if (this.generatedBomCoords == null) {
                this.generatedBomCoords = this.config.getRelease() == null || this.config.getRelease().getNext() == null ? new DefaultArtifact(GeneratePlatformProjectMojo.this.getUniversalBomArtifact().getGroupId(), this.originalBomCoords().getArtifactId(), null, "pom", this.originalBomCoords().getVersion()) : GeneratePlatformProjectMojo.toPomArtifact(this.config.getRelease().getNext());
            }
            return this.generatedBomCoords;
        }

        public ArtifactKey key() {
            if (this.key == null) {
                this.key = this.originalBomCoords() == null ? GeneratePlatformProjectMojo.toKey(this.generatedBomCoords()) : GeneratePlatformProjectMojo.toKey(this.originalBomCoords());
            }
            return this.key;
        }

        public List<org.eclipse.aether.graph.Dependency> inputConstraints() {
            if (this.inputConstraints == null) {
                List dm = this.config.getDependencyManagement().toAetherDependencies();
                if (this.originalBomCoords() == null) {
                    this.inputConstraints = dm;
                } else if (dm.isEmpty()) {
                    this.inputConstraints = Collections.singletonList(new org.eclipse.aether.graph.Dependency(this.originalBomCoords(), "import"));
                } else {
                    if (this.originalBomCoords() != null) {
                        dm.add(new org.eclipse.aether.graph.Dependency(this.originalBomCoords(), "import"));
                    }
                    this.inputConstraints = dm;
                }
            }
            return this.inputConstraints;
        }

        public ArtifactCoords stackDescriptorCoords() {
            if (this.stackDescriptorCoords != null) {
                return this.stackDescriptorCoords;
            }
            String currentCoords = this.config.getRelease().getNext();
            String currentVersion = ArtifactCoords.fromString((String)currentCoords).getVersion();
            this.stackDescriptorCoords = new ArtifactCoords(this.generatedBomCoords().getGroupId(), this.generatedBomCoords().getArtifactId() + "-quarkus-platform-descriptor", currentVersion, "json", currentVersion);
            return this.stackDescriptorCoords;
        }

        public ArtifactCoords descriptorCoords() {
            return this.descriptorCoords == null ? (this.descriptorCoords = new ArtifactCoords(this.generatedBomCoords().getGroupId(), this.generatedBomCoords().getArtifactId() + "-quarkus-platform-descriptor", this.generatedBomCoords().getVersion(), "json", this.generatedBomCoords().getVersion())) : this.descriptorCoords;
        }

        public ArtifactCoords propertiesCoords() {
            return this.propertiesCoords == null ? (this.propertiesCoords = new ArtifactCoords(this.generatedBomCoords().getGroupId(), this.generatedBomCoords().getArtifactId() + "-quarkus-platform-properties", null, "properties", this.generatedBomCoords().getVersion())) : this.propertiesCoords;
        }

        public String getVersionProperty() {
            if (this.versionProperty == null) {
                Artifact quarkusBom = GeneratePlatformProjectMojo.this.quarkusCore.originalBomCoords();
                this.versionProperty = GeneratePlatformProjectMojo.this.getTestArtifactVersion(quarkusBom.getGroupId(), quarkusBom.getVersion());
                if (this.versionProperty.equals(quarkusBom.getVersion())) {
                    String ga = quarkusBom.getGroupId() + ":" + quarkusBom.getArtifactId() + ":";
                    for (String l : GeneratePlatformProjectMojo.this.pomLines()) {
                        if (!l.startsWith(ga)) continue;
                        this.versionProperty = ArtifactCoords.fromString((String)l).getVersion();
                        break;
                    }
                }
            }
            return this.versionProperty;
        }

        public DecomposedBom originalDecomposedBom() {
            return this.originalBom;
        }

        public void setOriginalDecomposedBom(DecomposedBom originalBom) {
            this.originalBom = originalBom;
        }

        public void setAlignedDecomposedBom(DecomposedBom alignedBom) {
            this.generatedBom = alignedBom;
        }

        public DecomposedBom getAlignedDecomposedBom() {
            return this.generatedBom;
        }

        public Collection<ArtifactKey> extensionCatalog() {
            return Collections.emptyList();
        }

        public void setExtensionCatalog(Collection<ArtifactKey> extensionCatalog) {
        }
    }
}

