/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bom.decomposer.maven.GenerateMavenRepoZip;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.util.GlobUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public class MavenRepoZip {
    private static final String JAVADOC = "javadoc";
    private static final String SOURCES = "sources";
    private Path repoDir;
    private MavenArtifactResolver resolver;
    private List<Dependency> managedDeps = Collections.emptyList();
    private MessageWriter log;
    private Set<String> excludedGroupIds = Collections.emptySet();
    private Set<ArtifactKey> excludedArtifacts = Collections.emptySet();
    private List<ArtifactCoords> extraArtifacts = Collections.emptyList();
    private Pattern includedVersionsPattern;
    private final Set<ArtifactCoords> copiedArtifacts = new HashSet<ArtifactCoords>();

    public static Generator newGenerator() {
        return new MavenRepoZip().new Generator();
    }

    private void doGenerate() throws MojoExecutionException {
        this.log.info("Generating Maven repository at " + this.repoDir);
        IoUtils.recursiveDelete((Path)this.repoDir);
        for (Dependency d : this.managedDeps) {
            this.collectDependencies(d.getArtifact());
        }
        for (ArtifactCoords coords : this.extraArtifacts) {
            this.collectDependencies((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
        }
    }

    private void collectDependencies(Artifact artifact) throws MojoExecutionException {
        DependencyNode root;
        if (this.isFilteredOut(artifact)) {
            return;
        }
        try {
            root = this.resolver.collectManagedDependencies(artifact, Collections.emptyList(), this.managedDeps, Collections.emptyList(), Collections.emptyList(), new String[]{"test", "provided"}).getRoot();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to collect dependencies of " + artifact, (Exception)((Object)e));
        }
        this.copyDependencies(root);
    }

    private void copyDependencies(DependencyNode node) throws MojoExecutionException {
        for (DependencyNode child : node.getChildren()) {
            this.copyDependencies(child);
        }
        Artifact artifact = node.getArtifact();
        if (this.isFilteredOut(artifact)) {
            return;
        }
        this.copyArtifact(artifact);
        if (artifact.getExtension().equals("pom")) {
            return;
        }
        if ("jar".equals(artifact.getExtension())) {
            Artifact a = this.resolveOrNull((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), SOURCES, "jar", artifact.getVersion()));
            if (a != null) {
                this.copyArtifact(a);
            }
            if ((a = this.resolveOrNull((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), JAVADOC, "jar", artifact.getVersion()))) != null) {
                this.copyArtifact(a);
            }
        }
    }

    private boolean isFilteredOut(Artifact artifact) {
        return artifact == null || JAVADOC.equals(artifact.getClassifier()) || SOURCES.equals(artifact.getClassifier()) || this.includedVersionsPattern != null && !this.includedVersionsPattern.matcher(artifact.getVersion()).matches() || this.excludedGroupIds.contains(artifact.getGroupId()) || this.excludedArtifacts.contains(MavenRepoZip.getKey(artifact));
    }

    private void copyArtifact(Artifact artifact) throws MojoExecutionException {
        if (!this.copiedArtifacts.add(MavenRepoZip.toCoords(artifact))) {
            return;
        }
        File resolved = artifact.getFile();
        if (resolved == null) {
            resolved = this.resolve(artifact).getFile();
        }
        Path target = this.repoDir.resolve(this.resolver.getSession().getLocalRepositoryManager().getPathForLocalArtifact(artifact));
        MavenRepoZip.copyFile(resolved.toPath(), target);
    }

    private Artifact resolve(Artifact rtArtifact) throws MojoExecutionException {
        try {
            return this.resolver.resolve(rtArtifact).getArtifact();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve " + rtArtifact, (Exception)((Object)e));
        }
    }

    private Artifact resolveOrNull(Artifact rtArtifact) {
        try {
            return this.resolver.resolve(rtArtifact).getArtifact();
        }
        catch (BootstrapMavenException e) {
            return null;
        }
    }

    private static ArtifactKey getKey(Artifact a) {
        return new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension());
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return new ArtifactCoords(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion());
    }

    public static void copyFile(Path source, Path target) throws MojoExecutionException {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories " + target.getParent(), (Exception)e);
        }
        try {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy " + source + " to " + target, (Exception)e);
        }
    }

    public static void main(String[] args) throws Exception {
        Set<String> prodSet = MavenRepoZip.collectPaths(Paths.get(System.getProperty("user.home"), new String[0]).resolve("Downloads/rh-quarkus-2.2.3.GA-maven-repository/maven-repository"));
        Set<String> platformSet = MavenRepoZip.collectPaths(Paths.get(System.getProperty("user.home"), new String[0]).resolve("git/quarkus-platform-product/target/repository"));
        HashSet<String> missing = new HashSet<String>();
        HashSet<String> extra = new HashSet<String>();
        for (String s : prodSet) {
            if (platformSet.contains(s)) continue;
            missing.add(s);
        }
        for (String s : platformSet) {
            if (prodSet.contains(s)) continue;
            extra.add(s);
        }
        if (!missing.isEmpty()) {
            System.out.println("MISSING ARTIFACTS " + missing.size());
            MavenRepoZip.logPaths(missing);
        }
        if (!extra.isEmpty()) {
            System.out.println("EXTRA ARTIFACTS " + extra.size());
            MavenRepoZip.logPaths(extra);
        }
    }

    private static void logPaths(Set<String> prodSet) {
        ArrayList<String> list = new ArrayList<String>(prodSet);
        Collections.sort(list);
        list.forEach(s -> System.out.println((String)s));
    }

    private static Set<String> collectPaths(final Path root) throws IOException {
        final HashSet<String> paths = new HashSet<String>();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String name = file.getFileName().toString();
                if (!name.endsWith(".md5") && !name.endsWith(".sha1")) {
                    paths.add(root.relativize(file).toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }

    public class Generator {
        private Generator() {
        }

        public Generator setConfig(GenerateMavenRepoZip config) {
            MavenRepoZip.this.repoDir = Paths.get(config == null ? "repository" : (config.getRepositoryDir() == null ? "repository" : config.getRepositoryDir()), new String[0]).normalize().toAbsolutePath();
            MavenRepoZip.this.excludedGroupIds = config.getExcludedGroupIds();
            if (!config.getExcludedArtifacts().isEmpty()) {
                MavenRepoZip.this.excludedArtifacts = config.getExcludedArtifacts().stream().map(ArtifactKey::fromString).collect(Collectors.toSet());
            }
            if (!config.getExtraArtifacts().isEmpty()) {
                MavenRepoZip.this.extraArtifacts = config.getExtraArtifacts().stream().map(ArtifactCoords::fromString).collect(Collectors.toList());
            }
            if (config.getIncludedVersionsPattern() != null) {
                MavenRepoZip.this.includedVersionsPattern = Pattern.compile(GlobUtil.toRegexPattern((String)config.getIncludedVersionsPattern()));
            }
            return this;
        }

        public Generator setLog(MessageWriter logger) {
            MavenRepoZip.this.log = logger;
            return this;
        }

        public Generator setMavenArtifactResolver(MavenArtifactResolver mavenResolver) {
            MavenRepoZip.this.resolver = mavenResolver;
            return this;
        }

        public Generator setManagedDependencies(List<Dependency> managedDependencies) {
            MavenRepoZip.this.managedDeps = managedDependencies;
            return this;
        }

        public void generate() throws MojoExecutionException {
            if (MavenRepoZip.this.repoDir == null) {
                MavenRepoZip.this.repoDir = Paths.get("repository", new String[0]);
            }
            if (MavenRepoZip.this.log == null) {
                MavenRepoZip.this.log = MessageWriter.info();
            }
            if (MavenRepoZip.this.resolver != null) {
                DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(MavenRepoZip.this.resolver.getSession());
                final LocalRepositoryManager original = MavenRepoZip.this.resolver.getSession().getLocalRepositoryManager();
                session.setLocalRepositoryManager(new LocalRepositoryManager(){

                    public LocalRepository getRepository() {
                        return original.getRepository();
                    }

                    public String getPathForLocalArtifact(Artifact artifact) {
                        return original.getPathForLocalArtifact(artifact);
                    }

                    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
                        return original.getPathForRemoteArtifact(artifact, repository, context);
                    }

                    public String getPathForLocalMetadata(Metadata metadata) {
                        return original.getPathForLocalMetadata(metadata);
                    }

                    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
                        return original.getPathForRemoteMetadata(metadata, repository, context);
                    }

                    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
                        LocalArtifactResult result = original.find(session, request);
                        if (result.isAvailable() && !MavenRepoZip.this.isFilteredOut(request.getArtifact())) {
                            try {
                                MavenRepoZip.this.copyArtifact(request.getArtifact());
                            }
                            catch (MojoExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return result;
                    }

                    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
                        original.add(session, request);
                        if (!MavenRepoZip.this.isFilteredOut(request.getArtifact())) {
                            try {
                                MavenRepoZip.this.copyArtifact(request.getArtifact());
                            }
                            catch (MojoExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }

                    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
                        return original.find(session, request);
                    }

                    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
                        original.add(session, request);
                    }
                });
                try {
                    MavenRepoZip.this.resolver = new MavenArtifactResolver(new BootstrapMavenContext(BootstrapMavenContext.config().setRepositorySystem(MavenRepoZip.this.resolver.getSystem()).setRepositorySystemSession((RepositorySystemSession)session).setRemoteRepositoryManager(MavenRepoZip.this.resolver.getRemoteRepositoryManager()).setRemoteRepositories(MavenRepoZip.this.resolver.getRepositories()).setCurrentProject(MavenRepoZip.this.resolver.getMavenContext().getCurrentProject())));
                }
                catch (BootstrapMavenException e) {
                    throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
                }
            }
            MavenRepoZip.this.doGenerate();
        }
    }
}

