/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.util.GlobUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;

public class ExtensionDependencyVersionChecker {
    private static final String REDHAT_SUPPORT = "redhat-support";
    private static final Set<String> CHECK_SUPPORT_LEVELS = Set.of("supported");
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> repos;
    private String globVersionPattern;
    private Pattern versionPattern;
    private int checkDepth = Integer.MAX_VALUE;
    private Set<String> checkSupportLevels;

    public static Builder builder() {
        return new ExtensionDependencyVersionChecker().new Builder();
    }

    public List<String> checkDependencyVersions(ExtensionCatalog catalog) {
        List bomConstraints;
        ArtifactCoords bom = catalog.getBom();
        try {
            bomConstraints = this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact((Artifact)new DefaultArtifact(bom.getGroupId(), bom.getArtifactId(), bom.getClassifier(), bom.getType(), bom.getVersion())).setRepositories(this.repos)).getManagedDependencies();
        }
        catch (ArtifactDescriptorException e1) {
            throw new RuntimeException("Failed to resolve " + bom, e1);
        }
        if (bomConstraints.isEmpty()) {
            throw new RuntimeException("Failed to resolve " + bom);
        }
        HashSet bomConstraintKeys = new HashSet(bomConstraints.size());
        bomConstraints.forEach(d -> bomConstraintKeys.add(ExtensionDependencyVersionChecker.toKey(d.getArtifact())));
        ArrayList<String> errors = new ArrayList<String>();
        catalog.getExtensions().forEach(e -> {
            DependencyNode root;
            Object o = e.getMetadata().get(REDHAT_SUPPORT);
            if (o == null) {
                return;
            }
            ArtifactCoords extensionCoords = e.getArtifact();
            if (!(o instanceof List)) {
                System.out.println("Expected redhat-support metadata of " + extensionCoords.toCompactCoords() + " is not an instance of java.util.List but " + o.getClass().getName());
                return;
            }
            if (!((List)o).stream().filter(i -> CHECK_SUPPORT_LEVELS.contains(i)).findFirst().isPresent()) {
                return;
            }
            DefaultArtifact a = new DefaultArtifact(extensionCoords.getGroupId(), extensionCoords.getArtifactId(), extensionCoords.getClassifier(), extensionCoords.getType(), extensionCoords.getVersion());
            try {
                root = this.repoSystem.collectDependencies(this.repoSession, new CollectRequest().setRootArtifact((Artifact)new DefaultArtifact("org.acme", "acme-app", null, "jar", "1.0-SNAPSHOT")).setManagedDependencies(bomConstraints).addDependency(new Dependency((Artifact)a, "compile")).setRepositories(this.repos)).getRoot();
            }
            catch (DependencyCollectionException e1) {
                throw new IllegalStateException("Failed to collect dependencies of " + extensionCoords.toCompactCoords(), e1);
            }
            root.getChildren().forEach(n -> this.checkExtensionDependencyVersion(n.getArtifact(), (DependencyNode)n, this.checkDepth, bomConstraintKeys, errors));
        });
        return errors;
    }

    private void checkExtensionDependencyVersion(Artifact root, DependencyNode node, int depth, Set<ArtifactKey> bomConstraintKeys, List<String> errors) {
        Artifact a = node.getArtifact();
        if (a != null && !this.versionPattern.matcher(a.getVersion()).matches() && bomConstraintKeys.contains(ExtensionDependencyVersionChecker.toKey(a))) {
            errors.add(ExtensionDependencyVersionChecker.toCompactCoords(root) + " depends on " + ExtensionDependencyVersionChecker.toCompactCoords(a) + " that does not match version pattern " + this.globVersionPattern);
            return;
        }
        if (depth == 0) {
            return;
        }
        for (DependencyNode child : node.getChildren()) {
            this.checkExtensionDependencyVersion(root, child, depth - 1, bomConstraintKeys, errors);
        }
    }

    private static ArtifactKey toKey(Artifact a) {
        return ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension());
    }

    private static String toCompactCoords(Artifact a) {
        StringBuilder sb = new StringBuilder();
        sb.append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':');
        if (!a.getClassifier().isEmpty()) {
            sb.append(a.getClassifier()).append(':');
        }
        if (!a.getExtension().equals("jar")) {
            sb.append(a.getExtension()).append(':');
        }
        sb.append(a.getVersion());
        return sb.toString();
    }

    public class Builder {
        private Builder() {
        }

        public Builder setRepositorySystem(RepositorySystem system) {
            ExtensionDependencyVersionChecker.this.repoSystem = system;
            return this;
        }

        public Builder setRepositorySystemSession(RepositorySystemSession session) {
            ExtensionDependencyVersionChecker.this.repoSession = session;
            return this;
        }

        public Builder setRemoteRepositories(List<RemoteRepository> remoteRepos) {
            ExtensionDependencyVersionChecker.this.repos = remoteRepos;
            return this;
        }

        public Builder setVersionPattern(String versionPattern) {
            ExtensionDependencyVersionChecker.this.globVersionPattern = versionPattern;
            return this;
        }

        public Builder setDepth(int depth) {
            ExtensionDependencyVersionChecker.this.checkDepth = depth;
            return this;
        }

        public ExtensionDependencyVersionChecker build() {
            Objects.requireNonNull(ExtensionDependencyVersionChecker.this.repoSystem, "Repository system wasn't initialized");
            Objects.requireNonNull(ExtensionDependencyVersionChecker.this.repoSession, "Repository system session wasn't initialized");
            Objects.requireNonNull(ExtensionDependencyVersionChecker.this.repos, "Remote repositories weren't initialized");
            Objects.requireNonNull(ExtensionDependencyVersionChecker.this.globVersionPattern, "Version pattern wasn't initialized");
            ExtensionDependencyVersionChecker.this.versionPattern = Pattern.compile(GlobUtil.toRegexPattern((String)ExtensionDependencyVersionChecker.this.globVersionPattern));
            if (ExtensionDependencyVersionChecker.this.checkSupportLevels == null) {
                ExtensionDependencyVersionChecker.this.checkSupportLevels = CHECK_SUPPORT_LEVELS;
            }
            return ExtensionDependencyVersionChecker.this;
        }
    }
}

