/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.platform.PlatformMemberConfig;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-marete-config", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE, requiresProject=false)
public class MareteConfigMojo
extends AbstractMojo {
    private static final String DEPS_TO_BUILD_REPORT_SUFFIX = "-deps-to-build.txt";
    @Parameter(required=true, defaultValue="${basedir}/src/main/resources/core/marete-template.yaml")
    File configTemplate;
    @Parameter(required=true, defaultValue="${project.build.directory}/marete-config.yaml")
    File generatedConfig;
    @Parameter
    PlatformConfig platformConfig;
    @Parameter(required=true, defaultValue="${project.build.directory}/dependencies-to-build")
    File depsToBuildReportDir;
    @Parameter(required=true, defaultValue="true", property="curateExpectedBoms")
    boolean curateExpectedBoms = true;
    @Parameter(required=true, defaultValue="true", property="curateUnexpectedFilesExceptions")
    boolean curateUnexpectedFilesExceptions = true;
    @Parameter(required=true, defaultValue="true", property="curateUniqueArtifactsExceptions")
    boolean curateUniqueArtifactsExceptions = true;
    private ObjectMapper mapper = CatalogMapperHelper.initMapper((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory()));
    private Map<ArtifactKey, Set<String>> artifactVersions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        JsonNode mareteConfig = this.readMareteTemplate();
        JsonNode mavenRepo = MareteConfigMojo.getRequiredNode(mareteConfig, "maven-repo");
        List<ArtifactKey> generatedBoms = this.getGeneratedBoms();
        if (this.curateExpectedBoms) {
            this.curateExpectedBoms(mavenRepo, generatedBoms);
        }
        if (this.curateUnexpectedFilesExceptions) {
            this.curateUnexpectedFilesExceptions(mavenRepo, generatedBoms);
        }
        if (this.curateUniqueArtifactsExceptions) {
            this.curateUniqueArtifactsException(mavenRepo);
        }
        this.persistMareteConfig(mareteConfig);
    }

    private Map<ArtifactKey, Set<String>> getArtifactVersions() throws MojoExecutionException {
        if (this.artifactVersions != null) {
            return this.artifactVersions;
        }
        if (!this.depsToBuildReportDir.exists()) {
            this.getLog().warn((CharSequence)("Failed to locate dependencies-to-build reports at " + this.depsToBuildReportDir));
            this.artifactVersions = Map.of();
            return this.artifactVersions;
        }
        HashMap<ArtifactKey, Set<String>> artifactVersions = new HashMap<ArtifactKey, Set<String>>();
        try (Stream<Path> stream = Files.list(this.depsToBuildReportDir.toPath());){
            Iterator i = stream.iterator();
            while (i.hasNext()) {
                Path p = (Path)i.next();
                if (!p.getFileName().toString().endsWith(DEPS_TO_BUILD_REPORT_SUFFIX)) continue;
                Stream<String> ls = Files.lines(p);
                try {
                    Iterator li = ls.iterator();
                    while (li.hasNext()) {
                        String s = (String)li.next();
                        if (s.isBlank() || s.charAt(0) == '#') continue;
                        ArtifactCoords coords = ArtifactCoords.fromString((String)s);
                        artifactVersions.computeIfAbsent(coords.getKey(), k -> new HashSet()).add(coords.getVersion());
                    }
                }
                finally {
                    if (ls == null) continue;
                    ls.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read dependencies-to-build reports", (Exception)e);
        }
        this.artifactVersions = artifactVersions;
        return this.artifactVersions;
    }

    private void curateUnexpectedFilesExceptions(JsonNode mavenRepo, Collection<ArtifactKey> generatedBoms) throws MojoExecutionException {
        Set<String> configuredUnexpectedFiles;
        ArrayNode unexpectedFiles;
        String unexpectedFilesExceptionsFieldName = "unexpected-files-exceptions";
        JsonNode node = mavenRepo.get("unexpected-files-exceptions");
        if (node != null && !(node instanceof NullNode)) {
            if (!(node instanceof ArrayNode)) {
                throw new MojoExecutionException("unexpected-files-exceptions is not an instance of " + ArrayNode.class.getName() + " but " + node.getClass().getName());
            }
            unexpectedFiles = (ArrayNode)node;
            configuredUnexpectedFiles = new HashSet(unexpectedFiles.size());
            for (int i = 0; i < unexpectedFiles.size(); ++i) {
                JsonNode jsonNode = unexpectedFiles.get(i);
                if (!JsonNodeType.STRING.equals((Object)jsonNode.getNodeType())) {
                    throw new MojoExecutionException("Unexpected file is not a STRING type but " + jsonNode.getNodeType());
                }
                configuredUnexpectedFiles.add(jsonNode.asText());
            }
        } else {
            unexpectedFiles = this.mapper.createArrayNode();
            ((ObjectNode)mavenRepo).set("unexpected-files-exceptions", (JsonNode)unexpectedFiles);
            configuredUnexpectedFiles = Set.of();
        }
        for (ArtifactKey generatedBom : generatedBoms) {
            String fileName = generatedBom.getArtifactId() + "-quarkus-platform-descriptor-*.json";
            if (!configuredUnexpectedFiles.contains(fileName)) {
                unexpectedFiles.add(fileName);
            }
            if (configuredUnexpectedFiles.contains(fileName = generatedBom.getArtifactId() + "-quarkus-platform-properties-*.properties")) continue;
            unexpectedFiles.add(fileName);
        }
    }

    private void curateExpectedBoms(JsonNode mavenRepo, Collection<ArtifactKey> generatedBoms) throws MojoExecutionException {
        HashSet<ArtifactKey> configuredExpectedBoms = new HashSet<ArtifactKey>();
        ArrayNode expectedBoms = this.getArtifactKeyArray(mavenRepo, "expected-boms", configuredExpectedBoms);
        for (ArtifactKey generatedBom : generatedBoms) {
            if (configuredExpectedBoms.contains(generatedBom)) continue;
            expectedBoms.add(generatedBom.getGroupId() + ":" + generatedBom.getArtifactId());
        }
    }

    private void curateUniqueArtifactsException(JsonNode mavenRepo) throws MojoExecutionException {
        TreeMap<CallSite, ArtifactKey> foundExceptions = new TreeMap<CallSite, ArtifactKey>();
        for (Map.Entry<ArtifactKey, Set<String>> a : this.getArtifactVersions().entrySet()) {
            if (a.getValue().size() <= 1) continue;
            ArtifactKey key = a.getKey();
            String s = key.getGroupId() + ":" + key.getArtifactId();
            String classifier = key.getClassifier();
            if (classifier != null && !classifier.isBlank()) {
                s = s + ":" + classifier;
            }
            foundExceptions.put((CallSite)((Object)s), key);
        }
        HashSet<ArtifactKey> configuredKeys = new HashSet<ArtifactKey>();
        ArrayNode array = this.getArtifactKeyArray(mavenRepo, "unique-artifacts-exceptions", configuredKeys);
        for (Map.Entry e : foundExceptions.entrySet()) {
            if (configuredKeys.contains(e.getValue())) continue;
            array.add((String)e.getKey());
        }
    }

    private ArrayNode getArtifactKeyArray(JsonNode mavenRepo, String name, Set<ArtifactKey> collectedItems) throws MojoExecutionException {
        ArrayNode expectedBoms;
        JsonNode node = mavenRepo.get(name);
        if (node != null && !(node instanceof NullNode)) {
            if (!(node instanceof ArrayNode)) {
                throw new MojoExecutionException(name + " is not an instance of " + ArrayNode.class.getName() + " but " + node.getClass().getName());
            }
            expectedBoms = (ArrayNode)node;
            for (int i = 0; i < expectedBoms.size(); ++i) {
                JsonNode jsonNode = expectedBoms.get(i);
                if (!JsonNodeType.STRING.equals((Object)jsonNode.getNodeType())) {
                    throw new MojoExecutionException("Expected item is not a STRING type but " + jsonNode.getNodeType());
                }
                ArtifactKey key = ArtifactKey.fromString((String)jsonNode.asText());
                collectedItems.add(ArtifactKey.ga((String)key.getGroupId(), (String)key.getArtifactId()));
            }
        } else {
            expectedBoms = this.mapper.createArrayNode();
            ((ObjectNode)mavenRepo).set(name, (JsonNode)expectedBoms);
        }
        return expectedBoms;
    }

    private static JsonNode getRequiredNode(JsonNode parent, String name) throws MojoExecutionException {
        JsonNode node = parent.get(name);
        if (node == null) {
            throw new MojoExecutionException("Failed to find " + name + " in the template");
        }
        return node;
    }

    private void persistMareteConfig(JsonNode mareteConfig) throws MojoExecutionException {
        if (!this.generatedConfig.exists()) {
            this.generatedConfig.getParentFile().mkdirs();
        }
        try {
            this.mapper.writer().writeValue(this.generatedConfig, (Object)mareteConfig);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + this.generatedConfig, (Exception)e);
        }
    }

    private JsonNode readMareteTemplate() throws MojoExecutionException {
        JsonNode jsonNode;
        block8: {
            BufferedReader reader = Files.newBufferedReader(this.configTemplate.toPath());
            try {
                jsonNode = this.mapper.readTree((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to parse " + this.configTemplate, (Exception)e);
                }
            }
            reader.close();
        }
        return jsonNode;
    }

    private List<ArtifactKey> getGeneratedBoms() {
        ArrayList<ArtifactKey> expectedBoms = new ArrayList<ArtifactKey>();
        ArtifactCoords universeBom = ArtifactCoords.fromString((String)this.platformConfig.getUniversal().getBom());
        expectedBoms.add(this.ga(universeBom));
        expectedBoms.add(this.ga(ArtifactCoords.fromString((String)this.platformConfig.getCore().getBom())));
        expectedBoms.add(this.ga(this.platformConfig.getCore().getGeneratedBom(universeBom.getGroupId())));
        for (PlatformMemberConfig member : this.platformConfig.getMembers()) {
            if (!member.isEnabled() || member.isHidden()) continue;
            expectedBoms.add(this.ga(member.getGeneratedBom(universeBom.getGroupId())));
        }
        return expectedBoms;
    }

    private ArtifactKey ga(ArtifactCoords coords) {
        return ArtifactKey.ga((String)coords.getGroupId(), (String)coords.getArtifactId());
    }
}

