/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.platform.PlatformMemberConfig;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-pnc-build-config", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE, requiresProject=false)
public class PncBuildConfigMojo
extends AbstractMojo {
    private static final String DEPS_TO_BUILD_REPORT_SUFFIX = "-deps-to-build.txt";
    @Parameter(required=true, defaultValue="${basedir}/src/main/resources/build-config-template.yaml")
    File configTemplate;
    @Parameter(required=true, defaultValue="${project.build.directory}/build-config.yaml")
    File generatedConfig;
    @Parameter
    PlatformConfig platformConfig;
    @Parameter(required=true, defaultValue="true", property="curateExpectedBoms")
    boolean curateExpectedBoms = true;
    @Parameter(required=true, defaultValue="true", property="curateUnexpectedFilesExceptions")
    boolean curateUnexpectedFilesExceptions = true;
    private ObjectMapper mapper = CatalogMapperHelper.initMapper((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory()));

    public void execute() throws MojoExecutionException, MojoFailureException {
        JsonNode buildConfig = this.readBuildConfigTemplate();
        this.persistBuildConfig(buildConfig);
    }

    private void curateUnexpectedFilesExceptions(JsonNode mavenRepo, Collection<ArtifactKey> generatedBoms) throws MojoExecutionException {
        Set<String> configuredUnexpectedFiles;
        ArrayNode unexpectedFiles;
        String unexpectedFilesExceptionsFieldName = "unexpected-files-exceptions";
        JsonNode node = mavenRepo.get("unexpected-files-exceptions");
        if (node != null && !(node instanceof NullNode)) {
            if (!(node instanceof ArrayNode)) {
                throw new MojoExecutionException("unexpected-files-exceptions is not an instance of " + ArrayNode.class.getName() + " but " + node.getClass().getName());
            }
            unexpectedFiles = (ArrayNode)node;
            configuredUnexpectedFiles = new HashSet(unexpectedFiles.size());
            for (int i = 0; i < unexpectedFiles.size(); ++i) {
                JsonNode jsonNode = unexpectedFiles.get(i);
                if (!JsonNodeType.STRING.equals((Object)jsonNode.getNodeType())) {
                    throw new MojoExecutionException("Unexpected file is not a STRING type but " + jsonNode.getNodeType());
                }
                configuredUnexpectedFiles.add(jsonNode.asText());
            }
        } else {
            unexpectedFiles = this.mapper.createArrayNode();
            ((ObjectNode)mavenRepo).set("unexpected-files-exceptions", (JsonNode)unexpectedFiles);
            configuredUnexpectedFiles = Set.of();
        }
        for (ArtifactKey generatedBom : generatedBoms) {
            String fileName = generatedBom.getArtifactId() + "-quarkus-platform-descriptor-*.json";
            if (!configuredUnexpectedFiles.contains(fileName)) {
                unexpectedFiles.add(fileName);
            }
            if (configuredUnexpectedFiles.contains(fileName = generatedBom.getArtifactId() + "-quarkus-platform-properties-*.properties")) continue;
            unexpectedFiles.add(fileName);
        }
    }

    private void curateExpectedBoms(JsonNode mavenRepo, Collection<ArtifactKey> generatedBoms) throws MojoExecutionException {
        HashSet<ArtifactKey> configuredExpectedBoms = new HashSet<ArtifactKey>();
        ArrayNode expectedBoms = this.getArtifactKeyArray(mavenRepo, "expected-boms", configuredExpectedBoms);
        for (ArtifactKey generatedBom : generatedBoms) {
            if (configuredExpectedBoms.contains(generatedBom)) continue;
            expectedBoms.add(generatedBom.getGroupId() + ":" + generatedBom.getArtifactId());
        }
    }

    private ArrayNode getArtifactKeyArray(JsonNode mavenRepo, String name, Set<ArtifactKey> collectedItems) throws MojoExecutionException {
        ArrayNode expectedBoms;
        JsonNode node = mavenRepo.get(name);
        if (node != null && !(node instanceof NullNode)) {
            if (!(node instanceof ArrayNode)) {
                throw new MojoExecutionException(name + " is not an instance of " + ArrayNode.class.getName() + " but " + node.getClass().getName());
            }
            expectedBoms = (ArrayNode)node;
            for (int i = 0; i < expectedBoms.size(); ++i) {
                JsonNode jsonNode = expectedBoms.get(i);
                if (!JsonNodeType.STRING.equals((Object)jsonNode.getNodeType())) {
                    throw new MojoExecutionException("Expected item is not a STRING type but " + jsonNode.getNodeType());
                }
                ArtifactKey key = ArtifactKey.fromString((String)jsonNode.asText());
                collectedItems.add(ArtifactKey.ga((String)key.getGroupId(), (String)key.getArtifactId()));
            }
        } else {
            expectedBoms = this.mapper.createArrayNode();
            ((ObjectNode)mavenRepo).set(name, (JsonNode)expectedBoms);
        }
        return expectedBoms;
    }

    private static JsonNode getRequiredNode(JsonNode parent, String name) throws MojoExecutionException {
        JsonNode node = parent.get(name);
        if (node == null) {
            throw new MojoExecutionException("Failed to find " + name + " in the template");
        }
        return node;
    }

    private void persistBuildConfig(JsonNode mareteConfig) throws MojoExecutionException {
        if (!this.generatedConfig.exists()) {
            this.generatedConfig.getParentFile().mkdirs();
        }
        try {
            this.mapper.writer().writeValue(this.generatedConfig, (Object)mareteConfig);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + this.generatedConfig, (Exception)e);
        }
    }

    private JsonNode readBuildConfigTemplate() throws MojoExecutionException {
        JsonNode jsonNode;
        block8: {
            BufferedReader reader = Files.newBufferedReader(this.configTemplate.toPath());
            try {
                jsonNode = this.mapper.readTree((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to parse " + this.configTemplate, (Exception)e);
                }
            }
            reader.close();
        }
        return jsonNode;
    }

    private List<ArtifactKey> getGeneratedBoms() {
        ArrayList<ArtifactKey> expectedBoms = new ArrayList<ArtifactKey>();
        ArtifactCoords universeBom = ArtifactCoords.fromString((String)this.platformConfig.getUniversal().getBom());
        expectedBoms.add(this.ga(universeBom));
        expectedBoms.add(this.ga(ArtifactCoords.fromString((String)this.platformConfig.getCore().getBom())));
        expectedBoms.add(this.ga(this.platformConfig.getCore().getGeneratedBom(universeBom.getGroupId())));
        for (PlatformMemberConfig member : this.platformConfig.getMembers()) {
            if (!member.isEnabled() || member.isHidden()) continue;
            expectedBoms.add(this.ga(member.getGeneratedBom(universeBom.getGroupId())));
        }
        return expectedBoms;
    }

    private ArtifactKey ga(ArtifactCoords coords) {
        return ArtifactKey.ga((String)coords.getGroupId(), (String)coords.getArtifactId());
    }
}

