/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.deployment;

import io.quarkus.agroal.deployment.DataSourceDriverBuildItem;
import io.quarkus.agroal.deployment.DataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.quartz.deployment.QuartzJDBCDriverDialectBuildItem;
import io.quarkus.quartz.runtime.QuarkusQuartzConnectionPoolProvider;
import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzRecorder;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.quartz.runtime.QuartzScheduler;
import io.quarkus.quartz.runtime.QuartzSupport;
import io.quarkus.quartz.runtime.StoreType;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.AttributeRestoringConnectionInvocationHandler;
import org.quartz.impl.jdbcjobstore.HSQLDBDelegate;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.SimpleInstanceIdGenerator;
import org.quartz.simpl.SimpleThreadPool;

public class QuartzProcessor {
    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.quartz");
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{QuartzScheduler.class, QuartzSupport.class});
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem connectionProxy(QuartzBuildTimeConfig config) {
        if (config.storeType.equals((Object)StoreType.DB)) {
            return new NativeImageProxyDefinitionBuildItem(new String[]{Connection.class.getName()});
        }
        return null;
    }

    @BuildStep
    QuartzJDBCDriverDialectBuildItem driver(Optional<DataSourceDriverBuildItem> dataSourceDriver, QuartzBuildTimeConfig config) {
        if (config.storeType == StoreType.RAM) {
            if (config.clustered) {
                throw new ConfigurationError("Clustered jobs configured with unsupported job store option");
            }
            return new QuartzJDBCDriverDialectBuildItem(Optional.empty());
        }
        if (!dataSourceDriver.isPresent()) {
            String message = String.format("JDBC Store configured but '%s' datasource is not configured properly. You can configure your datasource by following the guide available at: https://quarkus.io/guides/datasource-guide", config.dataSourceName.isPresent() ? config.dataSourceName.get() : "default");
            throw new ConfigurationError(message);
        }
        return new QuartzJDBCDriverDialectBuildItem(Optional.of(this.guessDriver(dataSourceDriver)));
    }

    private String guessDriver(Optional<DataSourceDriverBuildItem> dataSourceDriver) {
        if (!dataSourceDriver.isPresent()) {
            return StdJDBCDelegate.class.getName();
        }
        String resolvedDriver = dataSourceDriver.get().getDriver();
        if (resolvedDriver.contains("postgresql")) {
            return PostgreSQLDelegate.class.getName();
        }
        if (resolvedDriver.contains("org.h2.Driver")) {
            return HSQLDBDelegate.class.getName();
        }
        if (resolvedDriver.contains("com.microsoft.sqlserver.jdbc.SQLServerResource")) {
            return MSSQLDelegate.class.getName();
        }
        return StdJDBCDelegate.class.getName();
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses(QuartzBuildTimeConfig config, QuartzJDBCDriverDialectBuildItem driverDialect) {
        ArrayList<ReflectiveClassBuildItem> reflectiveClasses = new ArrayList<ReflectiveClassBuildItem>();
        StoreType storeType = config.storeType;
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleThreadPool.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleInstanceIdGenerator.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(false, false, new String[]{CascadingClassLoadHelper.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, true, new String[]{storeType.clazz}));
        if (storeType.equals((Object)StoreType.DB)) {
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{JobStoreSupport.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, true, new String[]{Connection.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{AbstractTrigger.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleTriggerImpl.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{driverDialect.getDriver().get()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, true, new String[]{"io.quarkus.quartz.runtime.QuartzScheduler$InvokerJob"}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{QuarkusQuartzConnectionPoolProvider.class.getName()}));
        }
        return reflectiveClasses;
    }

    @BuildStep
    public List<LogCleanupFilterBuildItem> logCleanup(QuartzBuildTimeConfig config) {
        StoreType storeType = config.storeType;
        ArrayList<LogCleanupFilterBuildItem> logCleanUps = new ArrayList<LogCleanupFilterBuildItem>();
        logCleanUps.add(new LogCleanupFilterBuildItem(StdSchedulerFactory.class.getName(), new String[]{"Quartz scheduler version:", "Using default implementation for", "Quartz scheduler 'QuarkusQuartzScheduler'"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(org.quartz.core.QuartzScheduler.class.getName(), new String[]{"Quartz Scheduler v", "JobFactory set to:", "Scheduler meta-data:", "Scheduler QuarkusQuartzScheduler"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(storeType.clazz, new String[]{storeType.name + " initialized.", "Handling", "Using db table-based data access locking", "JDBCJobStore threads will inherit ContextClassLoader of thread", "Couldn't\u00a0rollback\u00a0jdbc\u00a0connection", "Database connection shutdown unsuccessful"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(SchedulerSignalerImpl.class.getName(), new String[]{"Initialized Scheduler Signaller of type"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(QuartzSchedulerThread.class.getName(), new String[]{"QuartzSchedulerThread Inheriting ContextClassLoader"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(SimpleThreadPool.class.getName(), new String[]{"Job execution threads will use class loader of thread"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(AttributeRestoringConnectionInvocationHandler.class.getName(), new String[]{"Failed restore connection's original"}));
        return logCleanUps;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void build(QuartzRuntimeConfig runtimeConfig, QuartzBuildTimeConfig buildTimeConfig, QuartzRecorder recorder, BeanContainerBuildItem beanContainer, BuildProducer<ServiceStartBuildItem> serviceStart, QuartzJDBCDriverDialectBuildItem driverDialect, Optional<DataSourceSchemaReadyBuildItem> schemaReadyBuildItem) {
        recorder.initialize(runtimeConfig, buildTimeConfig, beanContainer.getValue(), driverDialect.getDriver());
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("quartz"));
    }
}

