/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class ThreadLocalPool<PoolType extends Pool>
implements Pool {
    private final List<PoolAndThread> allConnections = new ArrayList<PoolAndThread>();
    private final ThreadLocal<PoolType> threadLocal = new ThreadLocal();
    protected final PoolOptions poolOptions;
    protected final Vertx vertx;
    private volatile boolean closed = false;

    public ThreadLocalPool(Vertx vertx, PoolOptions poolOptions) {
        this.vertx = vertx;
        this.poolOptions = poolOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolType pool() {
        this.checkPoolIsOpen();
        Object pool = (Pool)this.threadLocal.get();
        if (pool == null) {
            List<PoolAndThread> list = this.allConnections;
            synchronized (list) {
                this.checkPoolIsOpen();
                pool = this.createThreadLocalPool();
                this.allConnections.add(new PoolAndThread((Pool)pool));
                this.threadLocal.set(pool);
                this.scanForAbandonedConnections();
            }
        }
        return (PoolType)pool;
    }

    private final void scanForAbandonedConnections() {
        ArrayList<PoolAndThread> garbage = new ArrayList<PoolAndThread>();
        for (PoolAndThread pair : this.allConnections) {
            if (!pair.isDead()) continue;
            garbage.add(pair);
        }
        for (PoolAndThread dead : garbage) {
            dead.close();
        }
    }

    private void checkPoolIsOpen() {
        if (this.closed) {
            throw new IllegalStateException("This Pool has been closed");
        }
    }

    protected abstract PoolType createThreadLocalPool();

    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        this.pool().getConnection(handler);
    }

    public Query<RowSet<Row>> query(String sql) {
        return this.pool().query(sql);
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        return this.pool().preparedQuery(sql);
    }

    public void begin(Handler<AsyncResult<Transaction>> handler) {
        this.pool().begin(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<PoolAndThread> list = this.allConnections;
        synchronized (list) {
            this.closed = true;
            for (PoolAndThread pair : this.allConnections) {
                pair.close();
            }
            this.allConnections.clear();
            this.threadLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trackedSize() {
        List<PoolAndThread> list = this.allConnections;
        synchronized (list) {
            return this.allConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSelfFromTracking(PoolType instance) {
        List<PoolAndThread> list = this.allConnections;
        synchronized (list) {
            if (this.closed) {
                return;
            }
            for (PoolAndThread pair : this.allConnections) {
                if (pair.pool != instance) continue;
                this.allConnections.remove(pair);
                if (pair.isCurrentThread()) {
                    this.threadLocal.remove();
                }
                return;
            }
        }
    }

    private static class PoolAndThread {
        private final Pool pool;
        private final WeakReference<Thread> threadReference;

        private PoolAndThread(Pool pool) {
            this.pool = pool;
            this.threadReference = new WeakReference<Thread>(Thread.currentThread());
        }

        boolean isDead() {
            Thread thread = (Thread)this.threadReference.get();
            return thread == null || !thread.isAlive();
        }

        void close() {
            this.pool.close();
        }

        public boolean isCurrentThread() {
            return this.threadReference.get() == Thread.currentThread();
        }
    }
}

