/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import org.jboss.logging.Logger;

public abstract class ThreadLocalPool<PoolType extends Pool>
implements Pool {
    private static final Logger log = Logger.getLogger(ThreadLocalPool.class);
    private final AtomicReference<ThreadLocalPoolSet> poolset = new AtomicReference<ThreadLocalPoolSet>(new ThreadLocalPoolSet());
    protected final PoolOptions poolOptions;
    protected final Vertx vertx;

    public ThreadLocalPool(Vertx vertx, PoolOptions poolOptions) {
        this.vertx = vertx;
        this.poolOptions = poolOptions;
    }

    private PoolType pool() {
        for (int i = 0; i < 3; ++i) {
            ThreadLocalPoolSet currentConnections = this.poolset.get();
            Object p = currentConnections.getPool();
            if (p == null) continue;
            return p;
        }
        throw new IllegalStateException("Multiple attempts to reopen a new pool on a closed instance: aborting");
    }

    protected abstract PoolType createThreadLocalPool();

    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        this.pool().getConnection(handler);
    }

    public Query<RowSet<Row>> query(String sql) {
        return this.pool().query(sql);
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        return this.pool().preparedQuery(sql);
    }

    public void begin(Handler<AsyncResult<Transaction>> handler) {
        this.pool().begin(handler);
    }

    public void close() {
        ThreadLocalPoolSet previousPool = this.poolset.getAndSet(new ThreadLocalPoolSet());
        previousPool.close();
    }

    private class ThreadLocalPoolSet {
        final List<Pool> threadLocalPools = new ArrayList<Pool>();
        final ThreadLocal<PoolType> threadLocal = new ThreadLocal();
        final StampedLock stampedLock = new StampedLock();
        boolean isOpen = true;

        private ThreadLocalPoolSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PoolType getPool() {
            long optimisticRead = this.stampedLock.tryOptimisticRead();
            if (!this.isOpen) {
                return null;
            }
            Object ret = (Pool)this.threadLocal.get();
            if (ret != null) {
                if (this.stampedLock.validate(optimisticRead)) {
                    return ret;
                }
                return null;
            }
            long readLock = this.stampedLock.tryConvertToReadLock(optimisticRead);
            if (readLock == 0L) {
                return null;
            }
            try {
                log.debugf("Making pool for thread: %s", (Object)Thread.currentThread());
                ret = ThreadLocalPool.this.createThreadLocalPool();
                Object object = this.threadLocalPools;
                synchronized (object) {
                    this.threadLocalPools.add((Pool)ret);
                }
                this.threadLocal.set(ret);
                object = ret;
                return object;
            }
            finally {
                this.stampedLock.unlockRead(readLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            long lock = this.stampedLock.writeLock();
            try {
                this.isOpen = false;
                List<Pool> list = this.threadLocalPools;
                synchronized (list) {
                    for (Pool pool : this.threadLocalPools) {
                        log.debugf("Closing pool: %s", (Object)pool);
                        pool.close();
                    }
                }
            }
            finally {
                this.stampedLock.unlockWrite(lock);
            }
        }
    }
}

