/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class ConnectOptionsSupplier<CO extends SqlConnectOptions>
implements Supplier<Future<CO>> {
    private final Vertx vertx;
    private final CredentialsProvider credentialsProvider;
    private final String credentialsProviderName;
    private final List<CO> connectOptionsList;
    private final UnaryOperator<CO> connectOptionsCopy;
    private final Handler<Promise<CO>> blockingCodeHandler;

    public ConnectOptionsSupplier(Vertx vertx, CredentialsProvider credentialsProvider, String credentialsProviderName, List<CO> connectOptionsList, UnaryOperator<CO> connectOptionsCopy) {
        this.vertx = vertx;
        this.credentialsProvider = credentialsProvider;
        this.credentialsProviderName = credentialsProviderName;
        this.connectOptionsList = connectOptionsList;
        this.connectOptionsCopy = connectOptionsCopy;
        this.blockingCodeHandler = new BlockingCodeHandler();
    }

    @Override
    public Future<CO> get() {
        return this.vertx.executeBlocking(this.blockingCodeHandler, false);
    }

    private class BlockingCodeHandler
    implements Handler<Promise<CO>>,
    IntUnaryOperator {
        final AtomicInteger idx = new AtomicInteger();

        private BlockingCodeHandler() {
        }

        public void handle(Promise<CO> promise) {
            Map credentials = ConnectOptionsSupplier.this.credentialsProvider.getCredentials(ConnectOptionsSupplier.this.credentialsProviderName);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            int nextIdx = this.idx.getAndUpdate(this);
            SqlConnectOptions connectOptions = (SqlConnectOptions)ConnectOptionsSupplier.this.connectOptionsCopy.apply((SqlConnectOptions)ConnectOptionsSupplier.this.connectOptionsList.get(nextIdx));
            connectOptions.setUser(user).setPassword(password);
            promise.complete((Object)connectOptions);
        }

        @Override
        public int applyAsInt(int previousIdx) {
            return previousIdx == ConnectOptionsSupplier.this.connectOptionsList.size() - 1 ? 0 : previousIdx + 1;
        }
    }
}

